/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatibleMiscExpressionState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ActionStructureState
extends StructureState {
    static final String DRILLTHROUGH_REPORT_NAME_MEMBER = "drillThroughReportName";
    static final String DRILLTHROUGH_BOOKMARK_LINK_MEMBER = "drillThroughBookmarkLink";
    static final String BOOKMARK_LINK_MEMBER = "bookmarkLink";
    static final String HYPERLINK_MEMBER = "hyperlink";
    static final String DRILLTHROUGH_SEARCH_MEMBER = "drillThroughSearch";
    static final String DRILLTHROUGH_PARAM_BINDINGS_MEMBER = "drillThroughParamBindings";

    public ActionStructureState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
        this.struct = new Action();
    }

    public AbstractParseState startElement(String tagName) {
        if (tagName.equalsIgnoreCase("expression")) {
            return new CompatibleActionExpressionState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (tagName.equalsIgnoreCase("property")) {
            return new CompatibleActionPropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (tagName.equalsIgnoreCase("list-property")) {
            return new CompatibleActionListPropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        return super.startElement(tagName);
    }

    static class CompatibleActionExpressionState
    extends CompatibleMiscExpressionState {
        protected AbstractParseState versionConditionalJumpTo() {
            if (this.handler.versionNumber < 3020100 && "uri".equalsIgnoreCase(this.name)) {
                CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
                state.setName(this.name);
                state.struct = this.struct;
                state.propDefn = this.propDefn;
                return state;
            }
            return null;
        }

        protected AbstractParseState generalJumpTo() {
            if ("targetBookmark".equalsIgnoreCase(this.name)) {
                CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
                state.setName(this.name);
                state.struct = this.struct;
                state.propDefn = this.propDefn;
                return state;
            }
            return super.generalJumpTo();
        }

        public void end() throws SAXException {
            if (this.handler.versionNumber < 3020000) {
                super.end();
            } else {
                String value = this.text.toString();
                if (StringUtil.isBlank(value)) {
                    return;
                }
                this.doEnd(value);
            }
        }

        CompatibleActionExpressionState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
            super(theHandler, element, propDefn, struct);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            super.parseAttrs(attrs);
            if (ActionStructureState.DRILLTHROUGH_REPORT_NAME_MEMBER.equalsIgnoreCase(this.name)) {
                this.name = "reportName";
            } else if (ActionStructureState.BOOKMARK_LINK_MEMBER.equalsIgnoreCase(this.name) || ActionStructureState.DRILLTHROUGH_BOOKMARK_LINK_MEMBER.equalsIgnoreCase(this.name)) {
                this.name = "targetBookmark";
            } else if (ActionStructureState.HYPERLINK_MEMBER.equalsIgnoreCase(this.name)) {
                this.name = "uri";
            }
        }
    }

    static class CompatibleActionPropertyState
    extends PropertyState {
        CompatibleActionPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
            super(theHandler, element, propDefn, struct);
        }

        public void end() throws SAXException {
            if (ActionStructureState.DRILLTHROUGH_REPORT_NAME_MEMBER.equalsIgnoreCase(this.name)) {
                String value = this.text.toString();
                this.setMember(this.struct, this.propDefn.getName(), "reportName", value);
                return;
            }
            super.end();
        }
    }

    static class CompatibleActionListPropertyState
    extends ListPropertyState {
        CompatibleActionListPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
            super(theHandler, element, propDefn, struct);
        }
    }
}

