/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.OverriddenValuesState;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ReportElementState
extends DesignParseState {
    protected DesignElement container = null;
    protected int slotID = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportElementState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler);
        this.container = theContainer;
        this.slotID = slot;
    }

    public ReportElementState(ModuleParserHandler theHandler) {
        super(theHandler);
    }

    public abstract DesignElement getElement();

    protected boolean addToSlot(DesignElement container, int slotID, DesignElement content) {
        ElementDefn containerDefn = (ElementDefn)container.getDefn();
        if (!$assertionsDisabled && !containerDefn.isContainer()) {
            throw new AssertionError();
        }
        SlotDefn slotInfo = (SlotDefn)containerDefn.getSlot(slotID);
        if (!$assertionsDisabled && slotInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !slotInfo.canContain(content)) {
            throw new AssertionError();
        }
        if (container.getExtendsElement() != null) {
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)new ContentException(container, slotID, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN")));
            return false;
        }
        if (!slotInfo.isMultipleCardinality() && container.getSlot(slotID).getCount() > 0) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new ContentException(container, slotID, "Error.ContentException.SLOT_IS_FULL")));
            return false;
        }
        this.addToNamespace(content);
        Module module = this.handler.getModule();
        long elementID = content.getID();
        if (elementID > 0L) {
            DesignElement element = module.getElementByID(elementID);
            if (!$assertionsDisabled && element == content) {
                throw new AssertionError();
            }
            if (element == null) {
                module.addElementID(content);
            } else {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{content.getIdentifier(), element.getIdentifier()}, "Error.DesignParserException.DUPLICATE_ELEMENT_ID")));
                return false;
            }
        }
        container.getSlot(slotID).add(content);
        content.setContainer(container, slotID);
        return true;
    }

    protected void initElement(Attributes attrs, boolean nameRequired) {
        DesignElement element = this.getElement();
        String name = attrs.getValue("name");
        if (StringUtil.isBlank(name)) {
            if (nameRequired) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(element, null, "Error.NameException.NAME_REQUIRED")));
            }
        } else if (name.indexOf(".") != -1) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(element, name, "Error.NameException.DOT_FORBIDDEN")));
        } else {
            element.setName(name);
        }
        if (element.getDefn().canExtend()) {
            String extendsName = attrs.getValue("extends");
            element.setExtendsName(extendsName);
            this.resolveExtendsElement();
        } else if (!StringUtil.isBlank(attrs.getValue("extends"))) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.ILLEGAL_EXTENDS")));
        }
        this.initSimpleElement(attrs);
    }

    protected final void initSimpleElement(Attributes attrs) {
        DesignElement element = this.getElement();
        try {
            String theID = attrs.getValue("id");
            if (!StringUtil.isBlank(theID)) {
                long id = Long.parseLong(theID);
                if (id < 0L) {
                    this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
                }
                element.setID(id);
            }
        }
        catch (NumberFormatException e) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
        }
        String viewAction = attrs.getValue("viewAction");
        if (!StringUtil.isBlank(viewAction)) {
            this.setProperty("viewAction", viewAction);
        }
        if (!this.addToSlot(this.container, this.slotID, element)) {
            return;
        }
    }

    private void resolveExtendsElement() {
        DesignElement element = this.getElement();
        Module module = this.handler.getModule();
        ElementDefn defn = (ElementDefn)element.getDefn();
        int id = defn.getNameSpaceID();
        if (!$assertionsDisabled && id == -1) {
            throw new AssertionError();
        }
        String extendsName = element.getExtendsName();
        if (StringUtil.isBlank(extendsName)) {
            return;
        }
        DesignElement parent = module.resolveElement(extendsName, id, (PropertyDefn)element.getPropertyDefn("extends"));
        if (parent == null) {
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)new InvalidParentException(element, extendsName, "Error.InvalidParentException.PARENT_NOT_FOUND")));
            return;
        }
        try {
            element.checkExtends(parent);
        }
        catch (ExtendsException ex) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
        }
        element.setExtendsElement(parent);
        ElementStructureUtil.refreshStructureFromParent(module, element);
    }

    private void addToNamespace(DesignElement content) {
        String name = content.getName();
        ElementDefn contentDefn = (ElementDefn)content.getDefn();
        if (!$assertionsDisabled && StringUtil.isBlank(name) && contentDefn.getNameOption() == 2) {
            throw new AssertionError();
        }
        Module module = this.handler.getModule();
        if (name == null && contentDefn.getNameOption() == 2) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(this.container, name, "Error.NameException.NAME_REQUIRED")));
            return;
        }
        int id = contentDefn.getNameSpaceID();
        if (name != null && id != -1 && this.container.isManagedByNameSpace(this.slotID)) {
            NameSpace ns = module.getNameSpace(id);
            if (module.getNameSpace(id).contains(name)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new NameException(this.container, name, "Error.NameException.DUPLICATE")));
                return;
            }
            DesignElement parent = content.getExtendsElement();
            if (id == 1 && parent != null && parent.getContainerSlot() != 5) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new ExtendsForbiddenException(content, content.getElementName(), "Error.ExtendsForbiddenException.PARENT_NOT_IN_COMPONENT")));
                return;
            }
            ns.insert(content);
        }
    }

    private void addTheVirualElementsToNamesapce(DesignElement element) {
        ContentIterator contentIter = new ContentIterator(element);
        Module module = this.handler.getModule();
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            if (virtualElement.getName() == null) continue;
            module.makeUniqueName(virtualElement);
            this.addToNamespace(virtualElement);
        }
    }

    protected void parseExtensionName(Attributes attrs, boolean extensionNameRequired) {
        DesignElement element = this.getElement();
        if (!$assertionsDisabled && !(element instanceof IExtendableElement)) {
            throw new AssertionError();
        }
        String extensionName = this.getAttrib(attrs, "extensionName");
        if (StringUtil.isBlank(extensionName)) {
            if (!extensionNameRequired) {
                return;
            }
            SemanticError e = new SemanticError(element, "Error.SemanticError.MISSING_EXTENSION");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
        } else {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                SemanticError e = new SemanticError(element, new String[]{extensionName}, "Error.SemanticError.EXTENSION_NOT_FOUND");
                RecoverableError.dealMissingInvalidExtension(this.handler, e);
            }
        }
        this.setProperty("extensionName", extensionName);
    }

    protected void makeTestExpressionCompatible() {
        List mapRules;
        int i;
        List highlightRules;
        DesignElement element = this.getElement();
        if (this.handler.tempValue.get("highlightRules") != null && (highlightRules = element.getListProperty(this.handler.getModule(), "highlightRules")) != null) {
            for (i = 0; i < highlightRules.size(); ++i) {
                HighlightRule highlightRule = (HighlightRule)highlightRules.get(i);
                highlightRule.setTestExpression((String)this.handler.tempValue.get("highlightRules"));
            }
            this.handler.tempValue.remove("highlightRules");
        }
        if (this.handler.tempValue.get("mapRules") != null && (mapRules = element.getListProperty(this.handler.getModule(), "mapRules")) != null) {
            for (i = 0; i < mapRules.size(); ++i) {
                MapRule mapRule = (MapRule)mapRules.get(i);
                mapRule.setTestExpression((String)this.handler.tempValue.get("mapRules"));
            }
            this.handler.tempValue.remove("mapRules");
        }
    }

    public AbstractParseState startElement(String tagName) {
        ElementDefn defn = (ElementDefn)this.getElement().getDefn();
        if ("overridden-values".equalsIgnoreCase(tagName) && defn.getSlotCount() > 0 && defn.canExtend()) {
            return new OverriddenValuesState((ModuleParserHandler)this.getHandler(), this.getElement());
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        super.end();
        if (this.getElement().getExtendsElement() != null && this.getElement().getDefn().isContainer()) {
            this.addTheVirualElementsToNamesapce(this.getElement());
        }
    }

    static {
        $assertionsDisabled = !ReportElementState.class.desiredAssertionStatus();
    }
}

