/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.util.BoundColumnsMgr;

public class UnusedBoundColumnsMgr
extends BoundColumnsMgr {
    private Set boundColumnNames = new HashSet();
    private DesignElement element;
    private Module module;

    public UnusedBoundColumnsMgr(DesignElementHandle element) {
        this.element = element.getElement();
        this.module = element.getModule();
    }

    protected void handleBoundsForParamBinding(DesignElement element, Module module, String propValue) {
        if (propValue == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)propValue);
        }
        catch (BirtException e) {
            newExprs = null;
        }
        if (newExprs != null && newExprs.size() > 0) {
            for (int i = 0; i < newExprs.size(); ++i) {
                IColumnBinding column = (IColumnBinding)newExprs.get(i);
                this.boundColumnNames.add(column.getResultSetColumnName());
            }
        }
    }

    protected void handleBoundsForValue(DesignElement element, Module module, String propValue) {
        if (propValue == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)propValue);
        }
        catch (BirtException e) {
            newExprs = null;
        }
        if (newExprs != null) {
            for (int i = 0; i < newExprs.size(); ++i) {
                IColumnBinding column = (IColumnBinding)newExprs.get(i);
                this.boundColumnNames.add(column.getResultSetColumnName());
            }
        }
    }

    public static void removedUnusedBoundColumns(DesignElementHandle elementHandle) throws SemanticException {
        if (elementHandle == null || !(elementHandle instanceof ReportItemHandle) && !(elementHandle instanceof ScalarParameterHandle)) {
            return;
        }
        UnusedBoundColumnsMgr mgr = new UnusedBoundColumnsMgr(elementHandle);
        Module module = elementHandle.getModule();
        if (elementHandle instanceof ListingHandle) {
            mgr.dealDataContainerReportItem((ListingElement)mgr.element, module);
        } else if (elementHandle instanceof ReportItemHandle) {
            mgr.dealNonDataContainerReportItem((ReportItem)mgr.element, module);
        } else if (elementHandle instanceof ScalarParameterHandle) {
            mgr.dealScalarParameter((ScalarParameter)mgr.element, module);
        }
        mgr.removeUnusedColumns();
    }

    void removeUnusedColumns() throws SemanticException {
        String propName = null;
        if (this.element instanceof ReportItem) {
            propName = "boundDataColumns";
        } else if (this.element instanceof ScalarParameter) {
            propName = "boundDataColumns";
        } else {
            return;
        }
        List currentList = (List)this.element.getLocalProperty(this.module, propName);
        if (currentList == null || currentList.isEmpty()) {
            return;
        }
        ArrayList<ComputedColumn> unusedList = new ArrayList<ComputedColumn>();
        for (int i = 0; i < currentList.size(); ++i) {
            ComputedColumn column = (ComputedColumn)currentList.get(i);
            if (this.boundColumnNames.contains(column.getName())) continue;
            unusedList.add(column);
        }
        PropertyHandle propHandle = this.element.getHandle(this.module).getPropertyHandle(propName);
        ActivityStack cmdStack = this.module.getActivityStack();
        cmdStack.startTrans();
        try {
            for (int i = 0; i < unusedList.size(); ++i) {
                propHandle.removeItem((ComputedColumn)unusedList.get(i));
            }
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void dealData(DataItem element, Module module) {
        super.dealData(element, module);
        String value = (String)element.getLocalProperty(module, "resultSetColumn");
        if (value == null) {
            return;
        }
        this.boundColumnNames.add(value);
    }

    protected void dealReportItem(ReportItem element, Module module) {
        super.dealReportItem(element, module);
        List columnBindings = (List)element.getLocalProperty(module, "boundDataColumns");
        if (columnBindings != null) {
            for (int i = 0; i < columnBindings.size(); ++i) {
                ComputedColumn paramValue = (ComputedColumn)columnBindings.get(i);
                this.handleBoundsForValue(element, module, paramValue.getExpression());
            }
        }
    }

    protected void dealScalarParameter(ScalarParameter element, Module module) {
        super.dealScalarParameter(element, module);
        List columnBindings = (List)element.getLocalProperty(module, "boundDataColumns");
        if (columnBindings != null) {
            for (int i = 0; i < columnBindings.size(); ++i) {
                ComputedColumn paramValue = (ComputedColumn)columnBindings.get(i);
                this.handleBoundsForValue(element, module, paramValue.getExpression());
            }
        }
    }
}

