/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.io.Serializable;
import java.util.StringTokenizer;

public class IPAddress
implements Serializable {
    private String ipaddr;
    private byte[] ipaddrBytes = new byte[4];

    public IPAddress(IPAddress iPAddress) {
        this.ipaddr = iPAddress.ipaddr;
        int n = 0;
        while (n < 4) {
            this.ipaddrBytes[n] = iPAddress.ipaddrBytes[n];
            ++n;
        }
    }

    public IPAddress(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        this.ipaddrBytes[0] = (byte)n2;
        this.ipaddrBytes[1] = (byte)n3;
        this.ipaddrBytes[2] = (byte)n4;
        this.ipaddrBytes[3] = (byte)n5;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append(".");
        stringBuffer.append(n3);
        stringBuffer.append(".");
        stringBuffer.append(n4);
        stringBuffer.append(".");
        stringBuffer.append(n5);
        this.ipaddr = stringBuffer.toString();
    }

    public IPAddress(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        this.ipaddrBytes[0] = byArray[n];
        this.ipaddrBytes[1] = byArray[n + 1];
        this.ipaddrBytes[2] = byArray[n + 2];
        this.ipaddrBytes[3] = byArray[n + 3];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append(".");
        stringBuffer.append(n3);
        stringBuffer.append(".");
        stringBuffer.append(n4);
        stringBuffer.append(".");
        stringBuffer.append(n5);
        this.ipaddr = stringBuffer.toString();
    }

    public IPAddress(String string) {
        this.ipaddr = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        this.ipaddrBytes[0] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        this.ipaddrBytes[1] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        this.ipaddrBytes[2] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        this.ipaddrBytes[3] = (byte)Integer.parseInt(stringTokenizer.nextToken());
    }

    public String toString() {
        return this.ipaddr;
    }

    public String getIpAddress() {
        return this.ipaddr;
    }

    public byte[] getBytes() {
        return this.ipaddrBytes;
    }

    public boolean equals(IPAddress iPAddress) {
        byte[] byArray = iPAddress.getBytes();
        boolean bl = true;
        int n = 0;
        while (n < 4) {
            if (this.ipaddrBytes[n] != byArray[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public IPAddress applyMask(IPAddress iPAddress) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = iPAddress.getBytes();
        int n = 0;
        while (n < 4) {
            byArray[n] = (byte)(this.ipaddrBytes[n] & byArray2[n]);
            ++n;
        }
        return new IPAddress(byArray, 0);
    }
}

