/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.data.oda.xml.util.ISaxParserConsumer;
import org.eclipse.birt.report.data.oda.xml.util.NestedColumnUtil;
import org.eclipse.birt.report.data.oda.xml.util.RelationInformation;
import org.eclipse.birt.report.data.oda.xml.util.SaxParser;
import org.eclipse.birt.report.data.oda.xml.util.SaxParserComplexNestedQueryHelper;
import org.eclipse.birt.report.data.oda.xml.util.SaxParserUtil;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStream;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class SaxParserConsumer
implements ISaxParserConsumer {
    private static final int INVALID_COLUMN_INDEX = -1;
    private SaxParser sp;
    private Thread spThread;
    private int cachedResultSetRowNo = 0;
    private int currentAvailableMaxLineNo = -1;
    private String rootPath;
    private String[] namesOfCachedComplexNestedColumns;
    private String[] namesOfCachedSimpleNestedColumns;
    private String[] namesOfColumns;
    private String tableName;
    private RelationInformation relationInfo;
    private int cachedTimes;
    private String[][] cachedResultSet;
    private int currentRowNo;
    private SaxParserComplexNestedQueryHelper spNestedQueryHelper;
    private NestedColumnUtil nestedColumnUtil;
    private List cachedRootRows;
    private Map cachedTempRows;
    private List cachedOrderedTempRowRoots;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SaxParserConsumer(RelationInformation rinfo, XMLDataInputStream is, String tName) throws OdaException {
        this.tableName = tName;
        this.relationInfo = rinfo;
        this.nestedColumnUtil = new NestedColumnUtil(this.relationInfo, this.tableName, true);
        this.currentRowNo = 0;
        this.cachedTempRows = new HashMap();
        this.cachedRootRows = new ArrayList();
        this.cachedOrderedTempRowRoots = new ArrayList();
        this.cachedResultSet = new String[10000][this.relationInfo.getTableRealColumnNames(this.tableName).length];
        this.rootPath = this.relationInfo.getTableRootPath(this.tableName).replaceAll("\\Q[@\\E.*\\Q=\\E", "");
        this.namesOfCachedComplexNestedColumns = this.relationInfo.getTableComplexNestedXMLColumnNames(this.tableName);
        this.namesOfCachedSimpleNestedColumns = this.relationInfo.getTableSimpleNestedXMLColumnNames(this.tableName);
        this.namesOfColumns = this.relationInfo.getTableRealColumnNames(this.tableName);
        XMLDataInputStream xdis = is;
        if (this.namesOfCachedComplexNestedColumns.length > 0) {
            this.spNestedQueryHelper = new SaxParserComplexNestedQueryHelper(this, rinfo, xdis, tName);
            try {
                SaxParserConsumer saxParserConsumer = this;
                synchronized (saxParserConsumer) {
                    this.wait();
                }
                while (!this.spNestedQueryHelper.isPrepared()) {
                    saxParserConsumer = this;
                    synchronized (saxParserConsumer) {
                        this.wait(5L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
        }
        this.sp = new SaxParser(xdis, this);
        this.spThread = new Thread(this.sp);
        this.spThread.start();
    }

    public void manipulateData(String path, String value) {
        String currentRootPath;
        String string = currentRootPath = this.cachedRootRows.size() == 0 ? null : this.cachedRootRows.get(this.cachedRootRows.size() - 1).toString();
        if (this.cachedRootRows.size() > 0) {
            for (int n = 0; n < this.cachedRootRows.size(); ++n) {
                String currentRoot = this.cachedRootRows.get(n).toString();
                String[] os = n == 0 ? this.cachedResultSet[this.cachedResultSetRowNo] : (String[])this.cachedTempRows.get(currentRoot);
                this.populateValueToResultArray(path, value, currentRoot, os);
            }
        } else {
            this.populateValueToResultArray(path, value, currentRootPath, this.cachedResultSet[this.cachedResultSetRowNo]);
        }
    }

    private void populateValueToResultArray(String path, String value, String currentRoot, String[] os) {
        for (int i = 0; i < this.namesOfColumns.length; ++i) {
            if (!this.columnPathMatch(currentRoot, this.relationInfo.getTableColumnPath(this.tableName, this.namesOfColumns[i]), path, this.relationInfo.getTableColumnForwardRefNumber(this.tableName, this.namesOfColumns[i]))) continue;
            if (this.isSimpleNestedColumn(this.namesOfColumns[i])) {
                this.nestedColumnUtil.update(this.namesOfColumns[i], path, value);
                continue;
            }
            if (this.namesOfColumns[i].startsWith("-$TEMP_XML_COLUMN$-")) {
                os[i] = value;
                continue;
            }
            if (os[i] != null || !this.isCurrentColumnValid(this.namesOfColumns[i])) continue;
            os[i] = value;
        }
    }

    private boolean columnPathMatch(String rootPath, String tableColumnPath, String currentPath, int columnFowardRef) {
        if (rootPath != null && rootPath.split("/").length + columnFowardRef != currentPath.split("/").length) {
            return false;
        }
        return SaxParserUtil.isSamePath(tableColumnPath, currentPath);
    }

    private boolean isSimpleNestedColumn(String columnName) {
        for (int i = 0; i < this.namesOfCachedSimpleNestedColumns.length; ++i) {
            if (!this.namesOfCachedSimpleNestedColumns[i].equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public void detectNewRow(String path, boolean start) {
        if (SaxParserUtil.isSamePath(this.rootPath, path)) {
            if (start) {
                if (this.cachedRootRows.size() > 0) {
                    this.cachedOrderedTempRowRoots.add(path);
                    this.cachedTempRows.put(path, new String[this.namesOfColumns.length]);
                }
                this.cachedRootRows.add(path);
                return;
            }
            this.populateNestedXMLDataMappingColumns(path);
            this.cachedRootRows.remove(path);
            if (this.cachedRootRows.size() > 0) {
                return;
            }
            if (!this.isCurrentRowValid()) {
                return;
            }
            ++this.cachedResultSetRowNo;
            ++this.currentAvailableMaxLineNo;
            if (this.cachedResultSetRowNo > 9999) {
                this.sp.setStart(false);
                this.cachedResultSetRowNo = 0;
            }
            if (this.cachedOrderedTempRowRoots.size() > 0) {
                int i = 0;
                for (i = 0; i < this.cachedOrderedTempRowRoots.size(); ++i) {
                    String[] result = (String[])this.cachedTempRows.get(this.cachedOrderedTempRowRoots.get(i));
                    this.cachedTempRows.remove(this.cachedOrderedTempRowRoots.get(i));
                    this.cachedResultSet[this.cachedResultSetRowNo] = result;
                    ++this.cachedResultSetRowNo;
                    ++this.currentAvailableMaxLineNo;
                    if (this.cachedResultSetRowNo <= 9999) continue;
                    this.sp.setStart(false);
                    this.cachedResultSetRowNo = 0;
                }
                ArrayList temp = new ArrayList();
                for (int j = i + 1; j < this.cachedOrderedTempRowRoots.size(); ++j) {
                    temp.add(this.cachedOrderedTempRowRoots.get(j));
                }
                this.cachedOrderedTempRowRoots = temp;
            }
        }
    }

    private void populateNestedXMLDataMappingColumns(String currentRootPath) {
        if (this.cachedRootRows.size() > 1) {
            int j;
            int i;
            String currentRoot = this.cachedRootRows.get(this.cachedRootRows.size() - 1).toString();
            String[] os = (String[])this.cachedTempRows.get(currentRoot);
            for (i = 0; i < this.namesOfCachedComplexNestedColumns.length; ++i) {
                j = this.getColumnIndex(this.namesOfCachedComplexNestedColumns[i]);
                if (j == -1) continue;
                os[j] = this.spNestedQueryHelper.getNestedColumnUtil().getNestedColumnValue(this.namesOfCachedComplexNestedColumns[i], currentRootPath);
            }
            for (i = 0; i < this.namesOfCachedSimpleNestedColumns.length; ++i) {
                j = this.getColumnIndex(this.namesOfCachedSimpleNestedColumns[i]);
                if (j == -1) continue;
                os[j] = this.nestedColumnUtil.getNestedColumnValue(this.namesOfCachedSimpleNestedColumns[i], currentRootPath);
            }
        } else {
            int j;
            int i;
            for (i = 0; i < this.namesOfCachedComplexNestedColumns.length; ++i) {
                j = this.getColumnIndex(this.namesOfCachedComplexNestedColumns[i]);
                if (j == -1) continue;
                this.cachedResultSet[this.cachedResultSetRowNo][j] = this.spNestedQueryHelper.getNestedColumnUtil().getNestedColumnValue(this.namesOfCachedComplexNestedColumns[i], currentRootPath);
            }
            for (i = 0; i < this.namesOfCachedSimpleNestedColumns.length; ++i) {
                j = this.getColumnIndex(this.namesOfCachedSimpleNestedColumns[i]);
                if (j == -1) continue;
                this.cachedResultSet[this.cachedResultSetRowNo][j] = this.nestedColumnUtil.getNestedColumnValue(this.namesOfCachedSimpleNestedColumns[i], currentRootPath);
            }
        }
    }

    private int getColumnIndex(String columnName) {
        for (int j = 0; j < this.namesOfColumns.length; ++j) {
            if (!columnName.equals(this.namesOfColumns[j])) continue;
            return j;
        }
        return -1;
    }

    private boolean isCurrentRowValid() {
        for (int i = 0; i < this.cachedResultSet[this.cachedResultSetRowNo].length; ++i) {
            if (!this.relationInfo.getTableFilter(this.tableName).containsKey(this.relationInfo.getTableRealColumnNames(this.tableName)[i]) || !this.isCurrentColumnValueNotMatchFilterValue(i)) continue;
            for (int j = 1; j <= this.cachedResultSet[this.cachedResultSetRowNo].length; ++j) {
                this.cachedResultSet[this.cachedResultSetRowNo][this.getColumnPosition((int)j)] = null;
            }
            return false;
        }
        return true;
    }

    private boolean isCurrentColumnValid(String columnName) {
        HashMap filters = this.relationInfo.getTableColumnFilter(this.tableName, columnName);
        if (filters == null) {
            return true;
        }
        Iterator it = filters.keySet().iterator();
        while (it.hasNext()) {
            Object filterColumnName = it.next();
            Object value = filters.get(filterColumnName);
            if (this.isTwoValueMatch(value, this.cachedResultSet[this.cachedResultSetRowNo][this.getColumnIndex(filterColumnName.toString())])) continue;
            return false;
        }
        return true;
    }

    private boolean isTwoValueMatch(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        return value1.equals(value2);
    }

    private boolean isCurrentColumnValueNotMatchFilterValue(int i) {
        return this.relationInfo.getTableFilter(this.tableName).get(this.relationInfo.getTableRealColumnNames(this.tableName)[i]) != this.cachedResultSet[this.cachedResultSetRowNo][i] && !this.relationInfo.getTableFilter(this.tableName).get(this.relationInfo.getTableRealColumnNames(this.tableName)[i]).equals(this.cachedResultSet[this.cachedResultSetRowNo][i]);
    }

    public synchronized void wakeup() {
        this.notify();
    }

    private int getColumnPosition(int index) {
        return index - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws OdaException {
        while (this.sp.isAlive() && !this.sp.isSuspended()) {
            try {
                SaxParserConsumer saxParserConsumer = this;
                synchronized (saxParserConsumer) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
        }
        if (this.currentRowNo > this.currentAvailableMaxLineNo) {
            if (this.sp.isAlive()) {
                this.resumeThread();
                return this.next();
            }
            return false;
        }
        ++this.currentRowNo;
        return true;
    }

    private void resumeThread() throws OdaException {
        if (this.sp.isSuspended()) {
            ++this.cachedTimes;
            this.cachedResultSetRowNo = 0;
            this.cachedResultSet = new String[10000][this.relationInfo.getTableRealColumnNames(this.tableName).length];
            this.sp.setStart(true);
        }
    }

    public void close() {
        if (this.sp != null) {
            this.sp.stopParsing();
        }
    }

    public String[][] getResultSet() {
        return this.cachedResultSet;
    }

    public int getRowPosition() {
        return this.currentRowNo - this.cachedTimes * 10000 - 1;
    }

    public int getCurrentRowNo() {
        return this.currentRowNo;
    }
}

