/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.data.oda.xml.impl.DataTypes;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ATreeNode {
    public static final int ELEMENT_TYPE = 1;
    public static final int ATTRIBUTE_TYPE = 2;
    public static final int OTHER_TYPE = 0;
    private Object value;
    private ArrayList children = new ArrayList();
    private ATreeNode parent;
    private int type;
    private String dataType;
    private static HashMap xmlTypeToDataType = new HashMap();

    private static String getDataType(String type) throws OdaException {
        Object result = xmlTypeToDataType.get(type);
        if (result == null) {
            return type;
        }
        return result.toString();
    }

    ATreeNode() {
    }

    public Object getValue() {
        return this.value;
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public ATreeNode getParent() {
        return this.parent;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void addChild(Object child) {
        this.children.add(child);
    }

    public void addChild(Object[] children) {
        for (int i = 0; i < children.length; ++i) {
            this.children.add(children[i]);
        }
    }

    public void setParent(ATreeNode parent) {
        this.parent = parent;
        parent.addChild(this);
    }

    public String toString() {
        return this.value.toString();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String type) throws OdaException {
        this.dataType = ATreeNode.getDataType(type);
    }

    static {
        try {
            xmlTypeToDataType.put("string", DataTypes.getTypeString(12));
            xmlTypeToDataType.put("byte", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("decimal", DataTypes.getTypeString(2));
            xmlTypeToDataType.put("double", DataTypes.getTypeString(8));
            xmlTypeToDataType.put("float", DataTypes.getTypeString(8));
            xmlTypeToDataType.put("int", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("integer", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("negativeInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("nonNegativeInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("nonPositiveInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("positiveInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("short", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("date", DataTypes.getTypeString(91));
            xmlTypeToDataType.put("dateTime", DataTypes.getTypeString(93));
            xmlTypeToDataType.put("time", DataTypes.getTypeString(92));
        }
        catch (OdaException odaException) {
            // empty catch block
        }
    }
}

