/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.rcp.gui.connection;

import org.eclipse.aperi.rcp.gui.connection.ConnectionStatus;
import org.eclipse.aperi.rcp.gui.connection.Server;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.core.runtime.PlatformObject;

public class Connection
extends PlatformObject {
    private ConnectionStatus status;
    private Server server;
    private SignonResp signonResp = null;
    private ServerStatusResp serverStatusResp = null;
    private DeviceServerStatusResp deviceServerStatusResp = null;
    private ConnectionStatus dataServerStatus;
    private ConnectionStatus deviceServerStatus;
    private String errorMsg = null;

    public Connection(Server server) {
        this.setServer(server);
        this.setStatus(ConnectionStatus.UNKNOWN);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public ConnectionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConnectionStatus connectionStatus) {
        this.status = connectionStatus;
    }

    public String toString() {
        return this.getServer().toString();
    }

    public void registerError(Response response) {
        this.setStatus(ConnectionStatus.DISCONNECTED);
        if (response == null) {
            this.setErrorMessage(MessageLog.getMessage((String)"GUI0023M", null));
        } else {
            String string = response.getErrorMessage();
            if (string == null) {
                string = MessageLog.getMessage((String)"GUI0022M", null);
            }
            this.setErrorMessage(response.getErrorMessage());
        }
    }

    public DeviceServerStatusResp getDeviceServerStatusResp() {
        return this.deviceServerStatusResp;
    }

    private void setDeviceServerStatusResp(Object object) {
        this.deviceServerStatusResp = (DeviceServerStatusResp)object;
    }

    public ConnectionStatus getDeviceServerStatus() {
        return this.deviceServerStatus;
    }

    public void setDeviceServerStatus(Response response) {
        if (response != null) {
            if (response.status < 4) {
                this.deviceServerStatus = ConnectionStatus.CONNECTED;
            } else {
                this.setErrorMessage(response.getErrorMessage());
                this.deviceServerStatus = ConnectionStatus.DISCONNECTED;
            }
            this.setDeviceServerStatusResp(response.responseData);
        } else {
            this.deviceServerStatus = ConnectionStatus.DISCONNECTED;
        }
    }

    public ServerStatusResp getServerStatusResp() {
        return this.serverStatusResp;
    }

    private void setServerStatusResp(Object object) {
        this.serverStatusResp = (ServerStatusResp)object;
    }

    public ConnectionStatus getDataServerStatus() {
        return this.dataServerStatus;
    }

    public void setDataServerStatus(Response response) {
        if (response != null) {
            if (response.status < 4) {
                this.dataServerStatus = ConnectionStatus.CONNECTED;
            } else {
                this.setErrorMessage(response.getErrorMessage());
                this.dataServerStatus = ConnectionStatus.DISCONNECTED;
            }
            this.setServerStatusResp(response.responseData);
        } else {
            this.dataServerStatus = ConnectionStatus.DISCONNECTED;
        }
    }

    public SignonResp getSignonResp() {
        return this.signonResp;
    }

    public void setSignonResp(Object object) {
        this.signonResp = (SignonResp)object;
    }

    public void setErrorMessage(String string) {
        this.errorMsg = string;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

