/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.SVCBackendControllerUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.ParameterException;

public class SVCExtentUpdatePostProcess
extends SVCBackendControllerUpdatePostProcess {
    public SVCExtentUpdatePostProcess() {
        this("MDISK Update Post Processing");
    }

    protected SVCExtentUpdatePostProcess(String string) {
        super(string);
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"SVCExtentUpdatePostProcess", null);
        logTraceHelper.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("SVCExtentUpdatePostProcess", null, "In Band Virtualization", "IBM", null, null)};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request request, Map map) throws ParameterException {
        Result result;
        LogTraceHelper logTraceHelper;
        block13: {
            logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{request, map});
            result = new Result(1);
            DBConnection dBConnection = null;
            try {
                try {
                    Integer.parseInt((String)map.get("DEVICEID"));
                    String string = (String)map.get("SUBSYSTEMID");
                    dBConnection = ServiceUtils.getConnection();
                    StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)dBConnection);
                    dBConnection.commit();
                    this.processMdisk(dBConnection, string, storageSubsystem);
                    dBConnection.commit();
                    result = new Result(0);
                }
                catch (Exception exception) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.rollback();
                        }
                        catch (SQLException sQLException) {}
                    }
                    result = new Result(1);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)exception.getMessage(), (Throwable)exception, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                logTraceHelper.exit((Object)result);
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (dBConnection == null) break block13;
            }
            try {}
            catch (SQLException sQLException) {}
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processMdisk(DBConnection dBConnection, String string, StorageSubsystem storageSubsystem) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"processMdisk", (Object[])new Object[]{dBConnection, string, storageSubsystem});
        Result result = new Result(1);
        try {
            List list = this.getBackendController(storageSubsystem.getSubsystemId(), dBConnection);
            List list2 = this.getAllInitiatorPorts(storageSubsystem.getSubsystemId(), dBConnection, logTraceHelper);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BackendController backendController = (BackendController)iterator.next();
                logTraceHelper.traceInfo("BackendControllerID :" + backendController.getBackendControllerId());
                StorageSubsystem storageSubsystem2 = this.getStorageSubsystem(backendController.getReferencedSubsystemId(), dBConnection, logTraceHelper);
                if (storageSubsystem2 == null) continue;
                logTraceHelper.traceInfo("BackendController SubsystemID:" + storageSubsystem2.getSubsystemId());
                Vector vector = SVCExtentUpdatePostProcess.processArrayvalues(backendController.getPortWwns(), dBConnection, logTraceHelper);
                List list3 = this.getExtentEntries(backendController, dBConnection);
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    StorageExtent storageExtent = (StorageExtent)iterator2.next();
                    logTraceHelper.traceInfo("StorageExtent : " + storageExtent.getStorageExtentId());
                    String string2 = storageExtent.getName();
                    if (string2 == null) continue;
                    try {
                        this.UpdateMdisk_VolumeID(dBConnection, list2, vector, string2, Integer.toString(storageExtent.getStorageExtentId()));
                    }
                    catch (SQLException sQLException) {
                        logTraceHelper.traceAlways("Problem with MDISK update :" + storageSubsystem2.getSubsystemId() + "Initiator Port :" + list2.toString() + " Target Port :" + ((Object)vector).toString() + " LUNID :" + string2);
                    }
                }
            }
            result.setRc(0);
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        logTraceHelper.exit((Object)result);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setMdisk(Integer n, Integer n2, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"setMdisk", (Object[])new Object[]{dBConnection, n, n2});
        try {
            try {
                Class<?> clazz;
                ColumnInfo columnInfo = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageVolume");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SVID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, n.toString());
                StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor((DBConnection)dBConnection, hashtable, null);
                while (true) {
                    block8: {
                        if (storageVolumeCursor.next()) break block8;
                        storageVolumeCursor.close();
                        break;
                    }
                    StorageVolume storageVolume = storageVolumeCursor.getObject();
                    storageVolume.setMdiskId(n2.intValue());
                    storageVolume.update(dBConnection);
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        logTraceHelper.exit(null);
    }

    protected StorageSubsystem getStorageSubsystem(int n, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        StorageSubsystem storageSubsystem;
        StorageSubsystem storageSubsystem2 = null;
        try {
            Class<?> clazz;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
            hashtable.put(columnInfo, Integer.toString(n));
            StorageSubsystem.StorageSubsystemCursor storageSubsystemCursor = StorageSubsystem.getCursor((DBConnection)dBConnection, hashtable, null);
            if (storageSubsystemCursor.next()) {
                StorageSubsystem storageSubsystem3 = storageSubsystemCursor.getObject();
                logTraceHelper.traceInfo("Found :" + storageSubsystem3.getSubsystemId());
                storageSubsystem2 = storageSubsystem3;
            }
            storageSubsystemCursor.close();
            storageSubsystem = storageSubsystem2;
            Object var9_11 = null;
        }
        catch (SQLException sQLException) {
            try {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                logTraceHelper.traceInfo("StorageSubsystem  :" + storageSubsystem2 + " found.");
                throw throwable;
            }
        }
        logTraceHelper.traceInfo("StorageSubsystem  :" + storageSubsystem2 + " found.");
        return storageSubsystem;
    }

    private List getAllInitiatorPorts(int n, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        Vector<String> vector = new Vector<String>();
        List list = this.getPortEntries(n, dBConnection);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Port port = (Port)iterator.next();
            vector.add(Integer.toString(port.getPortId()));
        }
        logTraceHelper.traceInfo("getAllInitiatorPorts return :" + vector.toArray());
        return vector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getExtentEntries(BackendController backendController, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getExtentEntries", (Object[])new Object[]{backendController, dBConnection});
        LinkedList<StorageExtent> linkedList = new LinkedList<StorageExtent>();
        try {
            try {
                Class<?> clazz;
                ColumnInfo columnInfo = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.StorageExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"BACKEND_CONTROLLER_ID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, Integer.toString(backendController.getBackendControllerId()));
                StorageExtent.StorageExtentCursor storageExtentCursor = StorageExtent.getCursor((DBConnection)dBConnection, hashtable, null);
                while (true) {
                    block8: {
                        if (storageExtentCursor.next()) break block8;
                        storageExtentCursor.close();
                        dBConnection.commit();
                        break;
                    }
                    StorageExtent storageExtent = storageExtentCursor.getObject();
                    logTraceHelper.traceInfo("Found :" + storageExtent.getName());
                    linkedList.add(storageExtent);
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        logTraceHelper.exit(linkedList);
        return linkedList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getBackendController(DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getBackendController", (Object[])new Object[]{dBConnection});
        LinkedList<BackendController> linkedList = new LinkedList<BackendController>();
        try {
            try {
                Class<?> clazz;
                Hashtable hashtable = new Hashtable();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.BackendController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskReportingHelper.getColumnInfo(clazz, (String)"OWNING_SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
                BackendController.BackendControllerCursor backendControllerCursor = BackendController.getCursor((DBConnection)dBConnection, hashtable, null);
                if (backendControllerCursor.next()) {
                    linkedList.add(backendControllerCursor.getObject());
                }
                backendControllerCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        logTraceHelper.exit(linkedList);
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void UpdateMdisk_VolumeID(DBConnection dBConnection, List list, List list2, String string, String string2) throws SQLException {
        LogTraceHelper logTraceHelper;
        block12: {
            block11: {
                logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"UpdateMdisk_VolumeID", (Object[])new Object[]{dBConnection, list, list2, string});
                String string3 = list.toString().substring(1, list.toString().length() - 1);
                String string4 = list2.toString().substring(1, list2.toString().length() - 1);
                try {
                    String string5 = new String();
                    String string6 = new String();
                    if (string.startsWith("000000000000")) {
                        string5 = Integer.toString(Integer.parseInt(string.substring(string.length() - 4, string.length()), 16));
                        string6 = Integer.toString(Integer.parseInt("40" + string.substring(string.length() - 4, string.length() - 2) + "40" + string.substring(string.length() - 2, string.length()), 16));
                    } else {
                        if (!string.startsWith("40")) {
                            Object var19_11 = null;
                            break block11;
                        }
                        string5 = String.valueOf(string.substring(2, 4)) + string.substring(6, 8);
                        string5 = Integer.toString(Integer.parseInt(string5, 16));
                        string6 = string.substring(0, 8);
                        string6 = Integer.toString(Integer.parseInt(string6, 16));
                    }
                    if (!string3.trim().equals("") && !string4.trim().equals("")) {
                        String string7 = "select VOLUME_ID, count(VOLUME_ID) as count from " + DataPath.getTablename() + " where (" + "DEVICE_LUN_ID" + "=" + string5 + " or " + "DEVICE_LUN_ID" + "=" + string6 + ")" + " and " + "DEVICE_LUN_ID" + ">=0" + " and " + "INITIATOR_PORT_ID" + " in (" + string3 + ")" + " and " + "TARGET_PORT_ID" + " in (" + string4 + ")" + " group by " + "VOLUME_ID" + " order by count desc";
                        String string8 = "update " + StorageVolume.getTablename() + " set " + "MDISK_ID" + "=?" + " where " + "SVID" + "=?";
                        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string7, null);
                        String string9 = null;
                        int n = 0;
                        if (dBResultSet.next()) {
                            string9 = dBResultSet.getString("VOLUME_ID");
                            n = dBResultSet.getInt("count");
                        }
                        if (dBResultSet.next() && dBResultSet.getInt("count") == n) {
                            string9 = null;
                        }
                        dBResultSet.close();
                        if (string9 == null) {
                            logTraceHelper.traceHigh("MDISK update failed for LUN '" + string + "' since the are two different volumes assigned with " + n + " pathes for the above LUN.");
                            break block12;
                        } else {
                            logTraceHelper.traceHigh("Invoking SQL " + string8 + " with parameters " + "MDISK_ID" + ": " + string2 + ", " + "SVID" + ": " + string9);
                            Vector<ColumnInfo> vector = new Vector<ColumnInfo>(2);
                            vector.add(StorageVolume.getColumnInfo((String)"MDISK_ID"));
                            vector.add(StorageVolume.getColumnInfo((String)"SVID"));
                            Vector<String> vector2 = new Vector<String>(2);
                            vector2.add(string2);
                            vector2.add(string9);
                            int n2 = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)dBConnection, (String)string8, (Hashtable)ComplexQuery.generateHashtable(vector, vector2));
                            dBConnection.commit();
                            logTraceHelper.traceHigh("MDISK Query update result: " + n2 + " for " + string2);
                        }
                        break block12;
                    }
                    logTraceHelper.traceHigh("MDISK Query update failed: No InitiatorPorts " + list + " or TargetPorts " + list2 + " for LUN '" + string + "'");
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var19_12 = null;
                    logTraceHelper.exit(null);
                    throw throwable;
                }
            }
            logTraceHelper.exit(null);
            return;
        }
        Object var19_13 = null;
        logTraceHelper.exit(null);
    }

    protected static Vector processArrayvalues(String string, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        Vector<String> vector = new Vector<String>();
        try {
            int n = string.indexOf("]");
            if (n == -1) {
                n = string.length();
            }
            string = string.substring(string.indexOf("[") + 1, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = SVCExtentUpdatePostProcess.getPortID(string2, dBConnection, logTraceHelper);
                vector.add(string3);
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPortID(String string, DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        String string2 = "";
        try {
            try {
                Class<?> clazz;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"NAME", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, string);
                Port.PortCursor portCursor = Port.getCursor((DBConnection)dBConnection, hashtable, null);
                if (portCursor.next()) {
                    Port port = portCursor.getObject();
                    logTraceHelper.traceInfo("Found :" + port.getName());
                    string2 = Integer.toString(port.getPortId());
                }
                portCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            logTraceHelper.traceInfo("Initiator Port :" + string + " with " + string2 + " found.");
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        logTraceHelper.traceInfo("Initiator Port :" + string + " with " + string2 + " found.");
        return string2;
    }
}

