/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.MappingMaskingProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class SVCProtocolControllerCollectionStep
extends SimpleStep {
    protected String cMapName = null;
    protected IStep cSingleStep = null;
    private MappingMaskingProcessor cProcessor = null;

    public SVCProtocolControllerCollectionStep(String string, IStep iStep, DiskCIMProcessor diskCIMProcessor) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"SVCProtocolControllerCollectionStep", (Object[])new Object[]{string});
        this.cMapName = string;
        this.cSingleStep = iStep;
        this.cProcessor = (MappingMaskingProcessor)diskCIMProcessor;
        logTraceHelper.exit(null);
    }

    public boolean process(String string, Map map) throws Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{string});
        boolean bl = true;
        map.put(this.cMapName, new HashMap());
        this.cSingleStep.process(string, map);
        HashMap hashMap = (HashMap)map.get(this.cMapName);
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            logTraceHelper.traceInfo("Number of COPs in " + this.cMapName + ": " + hashMap.size());
            while (iterator.hasNext()) {
                CIMObjectPath cIMObjectPath = (CIMObjectPath)iterator.next();
                CIMInstance cIMInstance = new CIMInstance(cIMObjectPath);
                map.put("CIM_SCSIProtocolController", cIMInstance);
                logTraceHelper.traceInfo("Adding Protocoll Controller to MaskingInfo and DataPath");
                Hashtable hashtable = DiskCIMProcessor.convertPropertiesToHashtable((Vector)cIMInstance.getAllProperties(), new Hashtable());
                hashtable.put("originalcimclassname", "CIM_SCSIProtocolController");
                this.cProcessor.addProtocolControllerToDatapathAndMaskingInfoForSVC(null, hashtable);
                logTraceHelper.traceInfo("Passing COP " + cIMObjectPath + " with its CIMInstance to next process steps as " + "CIM_SCSIProtocolController");
                this.processNext(string, map);
                map.remove("CIM_SCSIProtocolController");
                logTraceHelper.traceInfo("Removing COP " + cIMObjectPath + " as " + "CIM_SCSIProtocolController");
            }
        }
        logTraceHelper.exit((Object)new Boolean(bl));
        return bl;
    }
}

