/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.IStreamSorter;

public class ArchiveUtil {
    public static String UNIX_SEPERATOR;
    static final String READER_COUNT_FILE_NAME = "/.reader.count";
    static final String[] SKIP_FILES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String generateFullPath(String rootPath, String relativePath) {
        relativePath = ArchiveUtil.convertToSystemString(relativePath);
        if (rootPath != null) {
            if (!rootPath.endsWith(File.separator)) {
                rootPath = rootPath + File.separator;
            }
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
            return rootPath + relativePath;
        }
        return relativePath;
    }

    public static String generateRelativePath(String rootPath, String fullPath) {
        String relativePath = null;
        relativePath = rootPath != null && fullPath.startsWith(rootPath) ? fullPath.substring(rootPath.length()) : fullPath;
        if (!(relativePath = ArchiveUtil.convertToUnixString(relativePath)).startsWith(UNIX_SEPERATOR)) {
            relativePath = UNIX_SEPERATOR + relativePath;
        }
        return relativePath;
    }

    private static String convertToUnixString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separator.charAt(0), UNIX_SEPERATOR.charAt(0));
    }

    private static String convertToSystemString(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(UNIX_SEPERATOR.charAt(0), File.separator.charAt(0));
    }

    public static synchronized String generateUniqueFileFolderName(String originalName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        String folderName = originalName + "_" + dateTimeString;
        Random generator = new Random();
        File folder = new File(folderName);
        while (folder.exists()) {
            folderName = folderName + generator.nextInt();
            folder = new File(folderName);
        }
        return folderName;
    }

    public static void createParentFolder(File fd) {
        if (fd != null && fd.getParentFile() != null && !fd.getParentFile().exists()) {
            fd.getParentFile().mkdirs();
        }
    }

    public static void DeleteAllFiles(File dirOrFile) {
        if (!dirOrFile.exists()) {
            return;
        }
        if (dirOrFile.isFile()) {
            dirOrFile.delete();
        } else {
            if (dirOrFile.listFiles() != null && dirOrFile.listFiles().length > 0) {
                File[] fileList = dirOrFile.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    ArchiveUtil.DeleteAllFiles(fileList[i]);
                }
            }
            dirOrFile.delete();
        }
    }

    public static void zipFolderToStream(String tempFolderPath, OutputStream ostream) {
        ZipOutputStream zipOutput = new ZipOutputStream(ostream);
        File rootDir = new File(tempFolderPath);
        File[] files = rootDir.listFiles();
        try {
            ArchiveUtil.zipFiles(zipOutput, files, tempFolderPath);
            zipOutput.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void zipFiles(ZipOutputStream zipOut, File[] files, String tempFolderPath) throws FileNotFoundException, IOException {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            int len;
            File file = files[i];
            if (file.isDirectory()) {
                File[] dirFiles = file.listFiles();
                ArchiveUtil.zipFiles(zipOut, dirFiles, tempFolderPath);
                continue;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            String relativePath = ArchiveUtil.generateRelativePath(tempFolderPath, file.getPath());
            ZipEntry entry = new ZipEntry(relativePath);
            entry.setTime(file.lastModified());
            zipOut.putNextEntry(entry);
            byte[] buf = new byte[5120];
            while ((len = in.read(buf)) > 0) {
                zipOut.write(buf, 0, len);
            }
            in.close();
            zipOut.closeEntry();
        }
    }

    public static void unzipArchive(File zipArchive, String tempFolderPath) {
        try {
            ZipFile zipFile = new ZipFile(zipArchive);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = ArchiveUtil.generateFullPath(tempFolderPath, entry.getName());
                    File dir = new File(dirName);
                    dir.mkdirs();
                    continue;
                }
                InputStream in = zipFile.getInputStream(entry);
                File file = new File(ArchiveUtil.generateFullPath(tempFolderPath, entry.getName()));
                File dir = new File(file.getParent());
                if (dir.exists()) {
                    if (!$assertionsDisabled && !dir.isDirectory()) {
                        throw new AssertionError();
                    }
                } else {
                    dir.mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buf = new byte[5120];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            zipFile.close();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void archive(String folder, String file) throws IOException {
        ArchiveUtil.archive(folder, null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archive(String folderName, IStreamSorter sorter, String fileName) throws IOException {
        ArchiveUtil.DeleteAllFiles(new File(fileName));
        RandomAccessFile compoundFile = new RandomAccessFile(fileName, "rw");
        try {
            ArchiveUtil.archive(folderName, sorter, compoundFile);
        }
        finally {
            compoundFile.close();
        }
    }

    static boolean needSkip(String file) {
        for (int i = 0; i < SKIP_FILES.length; ++i) {
            if (!SKIP_FILES[i].equals(file)) continue;
            return true;
        }
        return false;
    }

    static void archive(String folderName, IStreamSorter streamSorter, RandomAccessFile compoundFile) throws IOException {
        compoundFile.setLength(0L);
        compoundFile.seek(0L);
        compoundFile.writeLong(0L);
        compoundFile.writeLong(0L);
        ArrayList<File> fileList = new ArrayList<File>();
        folderName = new File(folderName).getCanonicalPath();
        ArchiveUtil.getAllFiles(new File(folderName), fileList);
        if (streamSorter != null) {
            ArrayList<String> streamNameList = new ArrayList<String>();
            for (int i = 0; i < fileList.size(); ++i) {
                File file = (File)fileList.get(i);
                streamNameList.add(ArchiveUtil.generateRelativePath(folderName, file.getAbsolutePath()));
            }
            ArrayList sortedNameList = streamSorter.sortStream(streamNameList);
            if (sortedNameList != null) {
                fileList.clear();
                for (int i = 0; i < sortedNameList.size(); ++i) {
                    String fileName = ArchiveUtil.generateFullPath(folderName, (String)sortedNameList.get(i));
                    fileList.add(new File(fileName));
                }
            }
        }
        long streamRelativePosition = 0L;
        long entryNum = 0L;
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            String relativePath = ArchiveUtil.generateRelativePath(folderName, file.getAbsolutePath());
            if (ArchiveUtil.needSkip(relativePath)) continue;
            compoundFile.writeUTF(relativePath);
            compoundFile.writeLong(streamRelativePosition);
            compoundFile.writeLong(file.length());
            streamRelativePosition += file.length();
            ++entryNum;
        }
        long streamSectionPos = compoundFile.getFilePointer();
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            String relativePath = ArchiveUtil.generateRelativePath(folderName, file.getAbsolutePath());
            if (ArchiveUtil.needSkip(relativePath)) continue;
            ArchiveUtil.copyFileIntoTheArchive(file, compoundFile);
        }
        compoundFile.seek(0L);
        compoundFile.writeLong(streamSectionPos);
        compoundFile.writeLong(entryNum);
    }

    private static long copyFileIntoTheArchive(File in, RandomAccessFile out) throws IOException {
        long totalBytesWritten = 0L;
        FileInputStream fis = new FileInputStream(in);
        byte[] buf = new byte[5120];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            out.write(buf, 0, i);
            totalBytesWritten += (long)i;
        }
        fis.close();
        return totalBytesWritten;
    }

    static void getAllFiles(File dir, ArrayList fileList) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ArchiveUtil.getAllFiles(file, fileList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expand(String file, String folder) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(file);
        try {
            reader.open();
            reader.expandFileArchive(folder);
        }
        finally {
            reader.close();
        }
    }

    static {
        $assertionsDisabled = !ArchiveUtil.class.desiredAssertionStatus();
        UNIX_SEPERATOR = "/";
        SKIP_FILES = new String[]{READER_COUNT_FILE_NAME};
    }
}

