/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control.fabric;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneControlAgent;
import org.eclipse.aperi.util.SRMCrypto;

public class OutbandZoneControl
extends ZoneControlAgent {
    public static String executableLocation;
    static final String className;
    protected Vector openTxns = null;
    protected Object openTxnsVectorLock = null;
    public static int timeOut;
    private static final int DEFAULT_TIMEOUT = 300000;
    private static OutbandZoneControl ozc;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.fabric.OutbandZoneControl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        timeOut = 0;
        ozc = null;
    }

    public static OutbandZoneControl getInstance() {
        if (ozc == null) {
            ozc = new OutbandZoneControl();
        }
        return ozc;
    }

    private OutbandZoneControl() {
        String string = "OutbandZoneControl";
        this.openTxns = new Vector();
        this.openTxnsVectorLock = new Object();
        msgLogger = ZoneConstants.zcAgentMsgLogger;
        traceLogger = ZoneConstants.zcAgentTraceLogger;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
    }

    public ZoneCapabilities getCapabilities(String string) {
        String string2 = "getCapabilities";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            ((Integer)this.SANtoHandle.get(string)).intValue();
            ZoneCapabilities zoneCapabilities = new ZoneCapabilities();
            zoneCapabilities.setSupportsAliases(true);
            zoneCapabilities.setAllowsNumericNameStart(true);
            zoneCapabilities.setSupportsNodeWWN(true);
            zoneCapabilities.setSupportsDomainPort(true);
            zoneCapabilities.setSupportsEmptyZoneAliases(false);
            zoneCapabilities.setSupportsEmptyZones(false);
            zoneCapabilities.setSupportsEmptyZoneSets(false);
            zoneCapabilities.setSupportsFCID(false);
            zoneCapabilities.setSupportsFullZoneDB(true);
            zoneCapabilities.setSupportsOrphanZoneAliases(true);
            zoneCapabilities.setSupportsOrphanZones(true);
            zoneCapabilities.setSupportsSpecialCharacters(false);
            zoneCapabilities.setZcAgentType(0);
            zoneCapabilities.setMaxZoneAliases(-1);
            zoneCapabilities.setMaxZoneMembers(-1);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Capabilities of SAN " + string + " are " + zoneCapabilities.toString());
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            return zoneCapabilities;
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            return null;
        }
    }

    public int ping(String string, String[] stringArray) {
        String string2 = "ping";
        int n = 1111;
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            ((Integer)this.SANtoHandle.get(string)).intValue();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Pinged SAN " + string + ". Return code " + n + ".");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            n = 221111;
        }
        return n;
    }

    public int lock(String string, String[] stringArray) {
        int n;
        block5: {
            String string2 = "lock";
            n = -1;
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
                }
                String string3 = stringArray[0];
                String cfr_ignored_0 = stringArray[1];
                String string4 = stringArray[2];
                SRMCrypto.decrypt((String)string4);
                n = 1;
                if (n > 0 && this.SANtoHandle.get(string) == null) {
                    this.SANtoHandle.put(string, Integer.valueOf(Integer.toString(n)));
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Locked resource: " + string3 + ".");
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                if (!traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
        }
        return n > 0 ? 0 : 1111;
    }

    public int startTransaction(String string) {
        int n = 1111;
        String string2 = "startTransaction";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            this.activateOnCommit = false;
            this.SANtoCommands.put(string, new ArrayList());
            n = this.activateTransactionNative((Integer)this.SANtoHandle.get(string));
            if (n != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to activate transaction with switch " + string + ".  Err = " + n);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrStartTransaction", (Object)string);
                return n;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Started transaction with SAN: " + string);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            return 11111;
        }
        return n;
    }

    public int rollbackTransaction(String string) {
        int n = 0;
        String string2 = "rollbackTransaction";
        try {
            ArrayList arrayList;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
            }
            if ((arrayList = (ArrayList)this.SANtoCommands.remove(string)) != null) {
                arrayList.clear();
                this.SANtoCommands.put(string, arrayList);
            }
            Integer n2 = (Integer)this.SANtoHandle.get(string);
            ZoneDefinition zoneDefinition = (ZoneDefinition)this.SANtoZoneDef.get(string);
            if (n2 != null) {
                // empty if block
            }
        }
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            n = 21111;
        }
        if (n != 0 && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Failed to rollback transaction on SAN " + string + ".  Err = " + n);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        String string = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Set shutdownInvoked to true");
        }
        Object object = this.openTxnsVectorLock;
        synchronized (object) {
            Iterator iterator = this.openTxns.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
            }
            this.openTxnsVectorLock.notifyAll();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    protected int sendCommandsToSwitch(String string, ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, int n) {
        String string2 = "sendCommandsToSwitch";
        int n2 = 0;
        ((Integer)this.SANtoHandle.get(string)).intValue();
        zoneDefinition2.getActiveZoneSet();
        ZoneSet zoneSet = zoneDefinition.getActiveZoneSet();
        boolean bl = n == 1 || n == 2;
        n2 = this.setZoneDB(string, zoneDefinition, n);
        if (n2 != 0) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Error occurred while sending zoning commands to SAN " + string + ".");
            }
            return n2;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Commited transaction with SAN: " + string);
        }
        if (bl) {
            if (zoneSet == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string2, "Enabling a zoning configuration with no activate ZoneSet  on SAN " + string);
                }
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Activated ZoneSet: " + zoneSet.getName() + ", SAN: " + string);
            }
        }
        return n2;
    }

    private int setZoneDB(String string, ZoneDefinition zoneDefinition, int n) {
        String string2 = "setZoneDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        int n2 = 0;
        int n3 = (Integer)this.SANtoHandle.get(string);
        ZoneDefinition zoneDefinition2 = (ZoneDefinition)this.SANtoZoneDef.get(string);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.findSameZoneEntities(zoneDefinition2, zoneDefinition, hashMap, hashMap2, hashMap3);
        if (n == 1 || n == 2) {
            n2 = this.deactivateAndReset(zoneDefinition2, zoneDefinition, n3, string);
        }
        if (n2 == 0) {
            n2 = this.deleteUnlikeZoneAliases(zoneDefinition2, hashMap2, n3, string);
        }
        if (n2 == 0) {
            n2 = this.createUnlikeZoneAliases(zoneDefinition, hashMap2, n3, string);
        }
        if (n2 == 0) {
            n2 = this.deleteUnlikeZones(zoneDefinition2, hashMap3, n3, string);
        }
        if (n2 == 0) {
            n2 = this.createUnlikeZones(zoneDefinition, hashMap3, n3, string);
        }
        if (n2 == 0) {
            n2 = this.deleteUnlikeZoneSets(zoneDefinition2, zoneDefinition, hashMap, n3, string);
        }
        if (n2 == 0) {
            n2 = this.createUnlikeZoneSets(zoneDefinition, zoneDefinition2, hashMap, n3, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private int deactivateAndReset(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, int n, String string) {
        String string2 = "deactivateAndReset";
        int n2 = 0;
        ZoneSet zoneSet = zoneDefinition.getActiveZoneSet();
        if (zoneSet != null) {
            zoneSet.getName();
            ZoneSet zoneSet2 = zoneDefinition2.getActiveZoneSet();
            if (zoneSet2 == null && (n2 = this.activateTransactionNative(n)) != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string2, "Unable to activate transaction with switch " + string + ".  Err = " + n2);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string2, "ZoneControl_ErrStartTransaction", (Object)string);
                return n2;
            }
        }
        return 0;
    }

    private int deleteUnlikeZoneAliases(ZoneDefinition zoneDefinition, HashMap hashMap, int n, String string) {
        ZoneAlias[] zoneAliasArray = zoneDefinition.getAliases();
        int n2 = 0;
        while (n2 < zoneAliasArray.length) {
            hashMap.get(zoneAliasArray[n2].getName());
            ++n2;
        }
        return 0;
    }

    private int createUnlikeZoneAliases(ZoneDefinition zoneDefinition, HashMap hashMap, int n, String string) {
        int n2 = 0;
        ZoneAlias[] zoneAliasArray = zoneDefinition.getAliases();
        int n3 = 0;
        while (n3 < zoneAliasArray.length) {
            if (hashMap.get(zoneAliasArray[n3].getName()) == null) {
                ZoneMember[] zoneMemberArray = zoneDefinition.getMembers(zoneAliasArray[n3]);
                String[] stringArray = new String[zoneMemberArray.length];
                short[] sArray = new short[zoneMemberArray.length];
                int n4 = 0;
                while (n4 < zoneMemberArray.length) {
                    stringArray[n4] = zoneMemberArray[n4].getName();
                    sArray[n4] = zoneMemberArray[n4].getType();
                    ++n4;
                }
            }
            ++n3;
        }
        return n2;
    }

    private int deleteUnlikeZones(ZoneDefinition zoneDefinition, HashMap hashMap, int n, String string) {
        String string2 = "deleteUnlikeZones";
        int n2 = 0;
        Zone[] zoneArray = zoneDefinition.getZones();
        int n3 = 0;
        while (n3 < zoneArray.length) {
            String string3 = zoneArray[n3].getName();
            if (hashMap.get(string3) == null && zoneArray[n3].getVendorType() == 1 && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Going to delete Zone " + zoneArray[n3].getName() + " that has vendorType " + Short.toString(zoneArray[n3].getVendorType()));
            }
            ++n3;
        }
        return n2;
    }

    private int createUnlikeZones(ZoneDefinition zoneDefinition, HashMap hashMap, int n, String string) {
        int n2 = 0;
        Zone[] zoneArray = zoneDefinition.getZones();
        int n3 = 0;
        while (n3 < zoneArray.length) {
            String string2 = zoneArray[n3].getName();
            if (hashMap.get(string2) == null && zoneArray[n3].getVendorType() == 1) {
                ZoneMember[] zoneMemberArray = zoneDefinition.getMembers(zoneArray[n3]);
                ZoneAlias[] zoneAliasArray = zoneDefinition.getAliases(zoneArray[n3]);
                String[] stringArray = new String[zoneMemberArray.length + zoneAliasArray.length];
                short[] sArray = new short[zoneMemberArray.length + zoneAliasArray.length];
                int n4 = 0;
                while (n4 < zoneMemberArray.length) {
                    stringArray[n4] = zoneMemberArray[n4].getName();
                    sArray[n4] = zoneMemberArray[n4].getType();
                    ++n4;
                }
                n4 = 0;
                while (n4 < zoneAliasArray.length) {
                    stringArray[zoneMemberArray.length + n4] = zoneAliasArray[n4].getName();
                    sArray[zoneMemberArray.length + n4] = 15;
                    ++n4;
                }
            }
            ++n3;
        }
        return n2;
    }

    private int deleteUnlikeZoneSets(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, HashMap hashMap, int n, String string) {
        int n2 = 0;
        ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
        int n3 = 0;
        while (n3 < zoneSetArray.length) {
            String string2 = zoneSetArray[n3].getName();
            if (hashMap.get(string2) == null) {
                this.areChangesInZonesOnly(zoneDefinition, zoneDefinition2, string2);
            }
            ++n3;
        }
        return n2;
    }

    private int createUnlikeZoneSets(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, HashMap hashMap, int n, String string) {
        int n2 = 0;
        ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
        int n3 = 0;
        while (n3 < zoneSetArray.length) {
            String string2 = zoneSetArray[n3].getName();
            if (hashMap.get(string2) == null && !this.areChangesInZonesOnly(zoneDefinition2, zoneDefinition, string2)) {
                Zone[] zoneArray = zoneDefinition.getZones(zoneSetArray[n3]);
                Vector<String> vector = new Vector<String>();
                int n4 = 0;
                while (n4 < zoneArray.length) {
                    vector.add(zoneArray[n4].getName());
                    ++n4;
                }
                ZoneSet zoneSet = zoneDefinition2.getZoneSet(zoneSetArray[n3].getName());
                if (zoneSet != null) {
                    Zone[] zoneArray2 = zoneDefinition2.getZones(zoneSet);
                    int n5 = 0;
                    while (n5 < zoneArray2.length) {
                        if (zoneArray2[n5].getVendorType() != 1 && !vector.contains(zoneArray2[n5].getName())) {
                            vector.add(zoneArray2[n5].getName());
                        }
                        ++n5;
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    private boolean areChangesInZonesOnly(ZoneDefinition zoneDefinition, ZoneDefinition zoneDefinition2, String string) {
        Zone[] zoneArray;
        ZoneSet zoneSet = zoneDefinition.getZoneSet(string);
        ZoneSet zoneSet2 = zoneDefinition2.getZoneSet(string);
        if (zoneSet == null || zoneSet2 == null) {
            return false;
        }
        if (zoneSet.getName() == null || zoneSet2.getName() == null) {
            return false;
        }
        if (!zoneSet.getName().equalsIgnoreCase(zoneSet2.getName()) || !zoneSet.getVersion().equalsIgnoreCase(zoneSet2.getVersion())) {
            return false;
        }
        Enumeration enumeration = zoneSet.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)zoneSet.getParameterValue(string2);
            String string4 = (String)zoneSet2.getParameterValue(string2);
            if (string3 == null || string4 == null || string3.equalsIgnoreCase(string4)) continue;
            return false;
        }
        Zone[] zoneArray2 = zoneDefinition.getZones(zoneSet);
        if (zoneArray2.length != (zoneArray = zoneDefinition2.getZones(zoneSet2)).length) {
            return false;
        }
        int n = 0;
        while (n < zoneArray2.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < zoneArray.length && !bl) {
                if (!zoneArray2[n].equals((Object)zoneArray[n2++])) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int activateTransactionNative(int n) {
        String string = "activateTransactionNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        Object object = this.openTxnsVectorLock;
        synchronized (object) {
            this.openTxns.add(new Integer(n));
            this.openTxnsVectorLock.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return 0;
    }

    protected int closeSessionNative(int n) {
        String string = "closeSessionNative";
        int n2 = 0;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n2;
    }

    protected String getCurrentZoningInfoNative(int n) {
        String string = "getCurrentZoningInfoNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        String string2 = null;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    public void finalize() {
        block4: {
            String string = "finalize";
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
    }
}

