/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.IScanner;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;

public abstract class Scanner
implements IScanner {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    public String scanId = null;

    static {
        Class<?> clazz;
        msgLogger = OutbandScanner.msgLogger;
        traceLogger = OutbandScanner.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.Scanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public Response processXMLDeltaScan(String string, String string2, int n, String string3) {
        String string4 = "processXMLDeltaScan with String";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        Object[] objectArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = String.valueOf(stringTokenizer.nextToken()) + "\n";
            vector.add(string5);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return this.processXMLDeltaScan(string, (String[])objectArray, n, string3);
    }

    public Response processXMLDeltaScan(String string, String[] stringArray, int n, String string2) {
        Object object;
        File file;
        boolean bl;
        int n2;
        FileOutputStream fileOutputStream;
        String string3;
        block21: {
            string3 = "processDeltaScan with String[]";
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
            }
            n2 = -1;
            String[] stringArray2 = new String[]{};
            bl = false;
            String string4 = this.benchmarkFileNameFromScanId(string);
            file = new File(String.valueOf(Variables.getExecutableDirectory()) + File.separator + string4 + ".BM_" + string2);
            try {
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    object = new ObjectInputStream(fileInputStream);
                    n2 = (Integer)((ObjectInputStream)object).readObject();
                    stringArray2 = (String[])((ObjectInputStream)object).readObject();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "Comparing data to " + string2 + " version " + n2);
                    }
                    bl = this.compare(stringArray, stringArray2);
                }
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string3, "Scanner_readBenchmarkError", (Object)file.getAbsolutePath());
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                }
                bl = false;
                n2 = -1;
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string3, "Scanner_readBenchmarkError", (Object)file.getAbsolutePath());
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block21;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
        }
        object = new Hashtable<String, String>();
        ((Hashtable)object).put("ScannerID", string);
        ((Hashtable)object).put("BENCHMARK", new Integer(n2));
        ((Hashtable)object).put("BENCHMARK LABEL", string2);
        ((Hashtable)object).put("SAME AS BENCHMARK", new Boolean(bl));
        if (bl) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, n);
            }
            ((Hashtable)object).put("LEVEL", new Integer(n2));
            return new Response(n, stringArray, n2, n2, string2, bl);
        }
        try {
            fileOutputStream = new FileOutputStream(file.getAbsolutePath());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            Integer n3 = new Integer(n2 < 1000 ? n2 + 1 : 0);
            objectOutputStream.writeObject(n3);
            objectOutputStream.writeObject(stringArray);
            objectOutputStream.flush();
            fileOutputStream.close();
            fileOutputStream = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, n);
            }
            ((Hashtable)object).put("LEVEL", new Integer(n3));
            return new Response(n, stringArray, n3.intValue(), n2, string2, bl);
        }
        catch (Exception exception) {
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string3, "Scanner_saveBenchmarkError");
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, n);
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string3, "Scanner_saveBenchmarkError");
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception2);
                }
            }
            return new Response(n, stringArray);
        }
    }

    private String benchmarkFileNameFromScanId(String string) {
        Object[] objectArray;
        String string2 = "benchmarkFileNameFromScanId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":.");
        Vector<Object[]> vector = new Vector<Object[]>();
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            vector.add(objectArray);
        }
        objectArray = null;
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        String string3 = new String("");
        if (objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length - 1) {
                string3 = String.valueOf(string3) + (String)objectArray[n] + "_";
                ++n;
            }
            string3 = String.valueOf(string3) + (String)objectArray[objectArray.length - 1];
        } else {
            string3 = string;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string3;
    }

    public String[] readString(InputStream inputStream) {
        Vector<String> vector;
        String string;
        block8: {
            string = "readString";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            vector = new Vector<String>();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            int n = 0;
            String string2 = "TOS error";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "readString with filter for error messages embedded in xml\n");
            }
            try {
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    n = string3.indexOf(string2);
                    if (n == -1) {
                        vector.add(string3);
                        continue;
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "scanner output filtered is " + string3 + "\n");
                }
            }
            catch (IOException iOException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "Scanner_retrieveDataError");
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)iOException);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)iOException);
            }
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return stringArray;
    }

    public boolean compare(String[] stringArray, String[] stringArray2) {
        String string = "compare";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string, (Object)"Comparing to benchmark ");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        boolean bl = false;
        while (bl < stringArray2.length) {
            stringBuffer2.append(stringArray2[bl]);
            bl += 1;
        }
        bl = stringBuffer.toString().equals(stringBuffer2.toString());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)(bl ? "Match with benchmark" : "Mismatch with benchmark"));
        }
        return bl;
    }
}

