/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner.data;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class Entity {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private String TOPOLOGY = "Topology";
    private String STATISTICS = "StatisticsScanner";
    private String CISCOMDS = "CiscoMDS";
    private String name = null;
    private String type = null;
    private String uniqueId = null;
    private Vector paramList = new Vector();
    private String str = new String();
    private Hashtable xrefs = new Hashtable();
    private Parameter iParameter;

    static {
        Class<?> clazz;
        msgLogger = OutbandScanner.msgLogger;
        traceLogger = OutbandScanner.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.data.Entity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public Entity() {
    }

    public Entity(String string, String string2) {
        this.name = string;
        this.uniqueId = string2;
        this.type = "UNAVAILABLE";
        new Vector();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String string) {
        this.uniqueId = string;
    }

    public void addParameter(String string, String string2) {
        int n;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string2.trim();
        char[] cArray = string3.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            n = cArray[n2];
            if (n >= 32 || n <= 126) {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        String string4 = stringBuffer.toString();
        n = 0;
        while (n < this.paramList.size()) {
            if (this.getParamNameAt(n).equals(string) && this.getParamActualValueAt(n).equals("")) {
                this.setParamValueAt(n, string4);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.paramList.add(new Parameter(string, string4));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Vector getParameterList() {
        return this.paramList;
    }

    public String getParamNameAt(int n) {
        this.iParameter = (Parameter)this.paramList.elementAt(n);
        return this.iParameter.getName();
    }

    public String getParamValueAt(int n) {
        if (this.paramList.size() > n) {
            this.iParameter = (Parameter)this.paramList.elementAt(n);
            return this.iParameter.getValue();
        }
        return null;
    }

    public String getParamActualValueAt(int n) {
        if (this.paramList.size() > n) {
            this.iParameter = (Parameter)this.paramList.elementAt(n);
            return this.iParameter.getActualValue();
        }
        return null;
    }

    public void setParamValueAt(int n, String string) {
        int n2 = 0;
        while (n2 < this.paramList.size()) {
            if (n2 == n) {
                ((Parameter)this.paramList.elementAt(n2)).setValue(string);
            }
            ++n2;
        }
    }

    public void addXrefs(String string, Vector vector) throws Exception {
        String string2 = "addXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter=" + string + " and " + vector));
        }
        if (string.length() == 0 || vector == null) {
            throw new Exception("Error: Entity.addXRefs - missing input parameter");
        }
        Vector<Vector> vector2 = (Vector<Vector>)this.xrefs.get(string);
        if (vector2 == null) {
            vector2 = new Vector<Vector>();
            vector2.add(vector);
            this.xrefs.put(string, vector2);
        } else if (traceLogger != null && traceLogger.isLogging()) {
            String string3 = "A Xref for " + string + " already exists.";
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string2, string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public void addXrefs(String string, String string2) throws Exception {
        String string3 = "addXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, (Object)("Input Parameter=" + string + " and " + string2));
        }
        if (string.length() == 0 || string2.length() == 0) {
            throw new Exception("Error: Entity.addXRefs - missing input parameter");
        }
        Vector<String> vector = (Vector<String>)this.xrefs.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            vector.add(string2);
            this.xrefs.put(string, vector);
        } else if (!this.isUniqueId(string, string2)) {
            vector.add(string2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    public Hashtable getXrefs() {
        return this.xrefs;
    }

    private boolean isUniqueId(String string, String string2) {
        Vector vector = (Vector)this.xrefs.get(string);
        int n = 0;
        while (n < vector.size()) {
            if (((String)vector.elementAt(n)).equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toXml() {
        String string = "toXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        String string2 = "  <" + this.name + "Xml>\n";
        String string3 = "    <UniqueIdXml>" + this.name + "Xml:" + this.uniqueId + "</UniqueIdXml>\n";
        string2 = string2.concat(string3);
        int n = 0;
        while (n < this.paramList.size()) {
            String string4 = ((Parameter)this.paramList.get(n)).toXML();
            string2 = string2.concat(string4);
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    public String toIdXml(Vector vector, String string) throws NoSuchElementException {
        String string2 = "toIdXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter=" + vector));
        }
        String string3 = new String();
        String string4 = new String();
        int n = 0;
        while (n < vector.size()) {
            string3 = "  <" + string + "IdXml>" + string + "Xml:" + vector.elementAt(n) + "</" + string + "IdXml>\n";
            string4 = string4.concat(string3);
            ++n;
        }
        string4 = string4.concat(this.endEntityXml());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string4;
    }

    public String toIdXml(Vector[] vectorArray) throws NoSuchElementException {
        String string = "toIdXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter=" + vectorArray));
        }
        String string2 = new String();
        String string3 = new String();
        int n = 0;
        while (n < vectorArray.length) {
            int n2 = 0;
            while (n2 < vectorArray[n].size()) {
                string2 = "  <" + ((Entity)vectorArray[n].elementAt(n2)).getName() + "IdXml>" + ((Entity)vectorArray[n].elementAt(n2)).getName() + "Xml:" + ((Entity)vectorArray[n].elementAt(n2)).getUniqueId() + "</" + ((Entity)vectorArray[n].elementAt(n2)).getName() + "IdXml>\n";
                string3 = string3.concat(string2);
                ++n2;
            }
            ++n;
        }
        string3 = string3.concat(this.endEntityXml());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string3;
    }

    public String toIdXml(Entity entity) throws NoSuchElementException {
        String string = "toIdXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter=" + entity));
        }
        String string2 = new String();
        String string3 = new String();
        String string4 = null;
        String string5 = entity.getName();
        string3 = string5.equals("San") ? "InterconnectElement" : (string5.equals("FcPort") ? "AttachedFcPort" : (string5.equals("Blade") || string5.equals("Cluster") ? "FcNode" : (string5.equals("FcNode") ? "FcPort" : "FcPort")));
        Enumeration enumeration = this.xrefs.keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            Vector vector = (Vector)this.xrefs.get(string6);
            int n = 0;
            while (n < vector.size()) {
                if (string3.equals("AttachedFcPort")) {
                    string4 = "  <" + string3 + "IdXml>" + "FcPortXml:" + vector.elementAt(n) + "</" + string3 + "IdXml>\n";
                    string2 = string2.concat(string4);
                } else if (string3.equals("FcNode") && string5.equals("Blade")) {
                    int n2 = 0;
                    while (n2 < ((Vector)vector.elementAt(n)).size()) {
                        string4 = "  <" + string3 + "IdXml>" + string3 + "Xml:" + ((Vector)vector.elementAt(n)).elementAt(n2) + "</" + string3 + "IdXml>\n";
                        string2 = string2.concat(string4);
                        ++n2;
                    }
                } else {
                    string4 = "  <" + string3 + "IdXml>" + string3 + "Xml:" + vector.elementAt(n) + "</" + string3 + "IdXml>\n";
                    string2 = string2.concat(string4);
                }
                ++n;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    public String composeXml(Vector[] vectorArray) {
        String string = "composeXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter=" + vectorArray));
        }
        String string2 = new String();
        int n = 0;
        while (n < vectorArray.length) {
            Vector vector = vectorArray[n];
            int n2 = 0;
            while (n2 < vector.size()) {
                Entity entity = (Entity)vector.elementAt(n2);
                string2 = string2.concat(entity.toXml());
                string2 = string2.concat(entity.toIdXml((Entity)vector.elementAt(n2)));
                string2 = string2.concat(entity.endEntityXml());
                ++n2;
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return string2;
    }

    public String endEntityXml() {
        String string = new String();
        string = "  </" + this.name + "Xml>\n";
        return string;
    }

    public String endResultXml(String string) {
        String string2 = "</" + string + "Xml>";
        return string2;
    }

    public String setDocType(String string) {
        String string2 = new String();
        string2 = string2.concat("<?xml version=\"1.0\"?>\n");
        string2 = string.equals(this.TOPOLOGY) ? string2.concat("<!DOCTYPE " + string + "Xml " + this.getTopologyDtd()) : (string.equals(this.CISCOMDS) ? string2.concat("<!DOCTYPE " + string + "Xml " + this.getCiscoMDSDtd()) : (string.equals(this.STATISTICS) ? string2.concat("<!DOCTYPE " + string + "Xml " + this.getStatisticsDtd()) : string2.concat("<!DOCTYPE " + string + "Xml " + this.getSimpleTopologyDtd())));
        string2 = string2.concat("<" + string + "Xml>\n");
        return string2;
    }

    public String setXmlHeader(String string, String string2, String string3, String string4) {
        String string5 = new String();
        string5 = string5.concat("  <HeaderXml>\n");
        string5 = string5.concat("    <ParameterXml>\n");
        string5 = string5.concat("      <NameXml>Version</NameXml>\n");
        string5 = string5.concat("      <ValueXml>" + string4 + "</ValueXml>\n");
        string5 = string5.concat("    </ParameterXml>\n");
        string5 = string5.concat("    <ParameterXml>\n");
        string5 = string5.concat("      <NameXml>Agent Address</NameXml>\n");
        string5 = string5.concat("      <ValueXml>" + string + "</ValueXml>\n");
        string5 = string5.concat("    </ParameterXml>\n");
        string5 = string5.concat("    <ParameterXml>\n");
        string5 = string5.concat("      <NameXml>Scanner Name</NameXml>\n");
        string5 = string5.concat("      <ValueXml>" + string2 + "</ValueXml>\n");
        string5 = string5.concat("    </ParameterXml>\n");
        string5 = string5.concat("    <ParameterXml>\n");
        string5 = string5.concat("      <NameXml>Scan ID</NameXml>\n");
        string5 = string5.concat("      <ValueXml>" + string3 + "</ValueXml>\n");
        string5 = string5.concat("    </ParameterXml>\n");
        string5 = string5.concat("  </HeaderXml>\n");
        return string5;
    }

    private String getStatisticsDtd() {
        String string = new String();
        string = string.concat("[<!-- Statistics Scanner DTD -->\n");
        string = string.concat("<!ELEMENT StatisticsScannerXml (HeaderXml, SwitchParamXml*, PortParamXml*)>\n");
        string = string.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        string = string.concat("<!ELEMENT SwitchParamXml (UniqueIdXml, ParameterXml*)>\n");
        string = string.concat("<!ELEMENT PortParamXml (UniqueIdXml, ParameterXml*)>\n");
        string = string.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        string = string.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Statistics Scanner DTD -->\n");
        return string;
    }

    private String getSimpleTopologyDtd() {
        String string = new String();
        string = string.concat("[<!-- Simple Topology Discover DTD -->\n");
        string = string.concat("<!ELEMENT SimpleTopologyXml (HeaderXml, SanXml*, InterconnectElementXml*, FcPortXml*)>\n");
        string = string.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        string = string.concat("<!ELEMENT SanXml (UniqueIdXml, ParameterXml*, InterconnectElementIdXml*, FcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT InterconnectElementXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>");
        string = string.concat("<!ELEMENT FcPortXml (UniqueIdXml, ParameterXml*)>\n");
        string = string.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        string = string.concat("<!ELEMENT InterconnectElementIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT FcPortIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Simple Topology Discover DTD -->\n");
        return string;
    }

    private String getCiscoMDSDtd() {
        String string = new String();
        string = string.concat("[<!-- Topology Discover DTD -->\n");
        string = string.concat("<!ELEMENT TopologyXml (HeaderXml, SanXml*, InterconnectElementXml*, ZoneXml*, PlatformXml*, SystemXml*, ControllerXml*, FcPortXml*, FcNodeXml*, ZoneSetXml*, ZoneMemberXml*, BladeXml*, ClusterXml*)>\n");
        string = string.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        string = string.concat("<!ELEMENT SanXml (UniqueIdXml, ParameterXml*, InterconnectElementIdXml*, FcPortIdXml*, ZoneSetIdXml*, SanIdXml*)>\n");
        string = string.concat("<!ELEMENT InterconnectElementXml (UniqueIdXml, ParameterXml*, FcPortIdXml*, InterconnectElementIdXml*, BladeIdXml*)>\n");
        string = string.concat("<!ELEMENT ZoneSetXml (UniqueIdXml, ParameterXml*, ZoneIdXml*)>\n");
        string = string.concat("<!ELEMENT ZoneXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT ZoneMemberXml (UniqueIdXml, ParameterXml*)>\n");
        string = string.concat("<!ELEMENT PlatformXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        string = string.concat("<!ELEMENT SystemXml (UniqueIdXml, ParameterXml*, ControllerIdXml*)>\n");
        string = string.concat("<!ELEMENT ControllerXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        string = string.concat("<!ELEMENT FcPortXml (UniqueIdXml, ParameterXml*, AttachedFcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT FcNodeXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT BladeXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        string = string.concat("<!ELEMENT ClusterXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        string = string.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        string = string.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT FcPortIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT InterconnectElementIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ZoneSetIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ZoneIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT FcNodeIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT AttachedFcPortIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ControllerIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT BladeIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ClusterIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT SanIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Topology Discover DTD -->\n");
        return string;
    }

    private String getTopologyDtd() {
        String string = new String();
        string = string.concat("[<!-- Topology Discover DTD -->\n");
        string = string.concat("<!ELEMENT TopologyXml (HeaderXml, SanXml*, InterconnectElementXml*, ZoneXml*, PlatformXml*, SystemXml*, ControllerXml*, FcPortXml*, FcNodeXml*, ZoneSetXml*, ZoneMemberXml*)>\n");
        string = string.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        string = string.concat("<!ELEMENT SanXml (UniqueIdXml, ParameterXml*, SanIdXml*, InterconnectElementIdXml*, FcPortIdXml*, ZoneSetIdXml*)>\n");
        string = string.concat("<!ELEMENT InterconnectElementXml (UniqueIdXml, ParameterXml*, FcPortIdXml*, InterconnectElementIdXml*)>\n");
        string = string.concat("<!ELEMENT ZoneSetXml (UniqueIdXml, ParameterXml*, ZoneIdXml*)>\n");
        string = string.concat("<!ELEMENT ZoneXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT ZoneMemberXml (UniqueIdXml, ParameterXml*)>\n");
        string = string.concat("<!ELEMENT PlatformXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        string = string.concat("<!ELEMENT SystemXml (UniqueIdXml, ParameterXml*, ControllerIdXml*)>\n");
        string = string.concat("<!ELEMENT ControllerXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        string = string.concat("<!ELEMENT FcPortXml (UniqueIdXml, ParameterXml*, AttachedFcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT FcNodeXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        string = string.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        string = string.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT FcPortIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT InterconnectElementIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ZoneSetIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ZoneIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT FcNodeIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT AttachedFcPortIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ControllerIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT SanIdXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        string = string.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Topology Discover DTD -->\n");
        return string;
    }

    public String toString() {
        String string = new String();
        string = string.concat("\nEntity\n");
        string = string.concat("  Type     = " + this.getType() + "\n");
        string = string.concat("  UniqueId = " + this.getUniqueId() + "\n");
        string = string.concat("  Parameters\n");
        int n = 0;
        while (n < this.getParameterList().size()) {
            Parameter parameter = (Parameter)this.getParameterList().elementAt(n);
            string = string.concat("    " + parameter.getName() + " = " + parameter.getActualValue() + "\n");
            ++n;
        }
        return string;
    }

    public void initTopologyParms() {
    }

    public void initSwitchStatsParms() {
        this.addParameter("State", "");
        this.addParameter("Status", "");
    }

    public void initPortStatsParms() {
        this.addParameter("WWN", "");
        this.addParameter("State", "");
        this.addParameter("Class3Discards", "");
        this.addParameter("RxLinkResets", "");
        this.addParameter("TxLinkResets", "");
        this.addParameter("RxOfflineSequences", "");
        this.addParameter("TxOfflineSequences", "");
        this.addParameter("LinkFailures", "");
        this.addParameter("InvalidCRC", "");
        this.addParameter("InvalidTxWords", "");
        this.addParameter("PrimitiveSequenceProtocolErrors", "");
        this.addParameter("LossOfSignal", "");
        this.addParameter("LossOfSynchronization", "");
        this.addParameter("InvalidOrderedSets", "");
        this.addParameter("FramesTooLong", "");
        this.addParameter("FramesTruncated", "");
        this.addParameter("AddressErrors", "");
        this.addParameter("DelimiterErrors", "");
        this.addParameter("EncodingDisparityErrors", "");
    }

    public void initSensorStatsParms() {
        this.addParameter("ConnUnitWWN", "");
        this.addParameter("Index", "");
        this.addParameter("Name", "");
        this.addParameter("Status", "");
        this.addParameter("Info", "");
        this.addParameter("Message", "");
        this.addParameter("Type", "");
        this.addParameter("Characteristic", "");
    }

    public void initEventStatsParms() {
        this.addParameter("ConnUnitWWN", "");
        this.addParameter("Index", "");
        this.addParameter("RealTime", "");
        this.addParameter("Uptime", "");
        this.addParameter("Severity", "");
        this.addParameter("Type", "");
        this.addParameter("ObjectID", "");
        this.addParameter("Description", "");
    }

    public void initCiscoParms() {
    }

    public boolean equals(Object object) {
        return object instanceof Entity && ((Entity)object).getUniqueId().equals(this.getUniqueId());
    }
}

