/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner.interfaces;

import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class OutbandScannerProperty {
    static final String className;
    static ILogger msgLogger;
    static ILogger traceLogger;
    private static IConfigService configServiceProxy;
    static String COMMUNITYNAME;
    String MONITORINTERVAL = "60000";
    static String WRITECOMMUNITYNAME;
    String SNMPTIMEOUTTRACING = "OFF";
    String SNMPTRACE = "OFF";
    String SNMPRETRY = "3";
    String SNMPTIMEOUT = "1000";
    String SWITCHPING = "NO";
    String CAPABILITYSCANRETRY = "1";
    String QUERYRETRY = "2";
    String RETRYDELAY = "100";

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.snmp.scanner.interfaces.OutbandScannerProperty");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        configServiceProxy = null;
        COMMUNITYNAME = "public";
        WRITECOMMUNITYNAME = "private";
    }

    public OutbandScannerProperty() {
        IConfigService iConfigService;
        String string = "OutbandScannerProperty";
        msgLogger = OutbandScanner.msgLogger;
        traceLogger = OutbandScanner.traceLogger;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        if ((iConfigService = this.getConfigServiceProxy()).getProperty("SnmpCommunityName", "user") == null) {
            iConfigService.setProperty("SnmpCommunityName", "user", COMMUNITYNAME);
        }
        if (iConfigService.getProperty("OutbandAgentMonitorInterval", "user") == null) {
            iConfigService.setProperty("OutbandAgentMonitorInterval", "user", this.MONITORINTERVAL);
        }
        if (iConfigService.getProperty("SnmpWriteCommunityName", "user") == null) {
            iConfigService.setProperty("SnmpWriteCommunityName", "user", WRITECOMMUNITYNAME);
        }
        if (iConfigService.getProperty("SnmpTimeoutTracing", "user") == null) {
            iConfigService.setProperty("SnmpTimeoutTracing", "user", this.SNMPTRACE);
        }
        if (iConfigService.getProperty("SnmpTrace", "user") == null) {
            iConfigService.setProperty("SnmpTrace", "user", this.SNMPTRACE);
        }
        if (iConfigService.getProperty("SnmpRetryCount", "user") == null) {
            iConfigService.setProperty("SnmpRetryCount", "user", this.SNMPRETRY);
        }
        if (iConfigService.getProperty("SnmpInitialTimeout", "user") == null) {
            iConfigService.setProperty("SnmpInitialTimeout", "user", this.SNMPTIMEOUT);
        }
        if (iConfigService.getProperty("PerformSwitchPing", "user") == null) {
            iConfigService.setProperty("PerformSwitchPing", "user", this.SWITCHPING);
        }
        if (iConfigService.getProperty("ITSANMCapabilityScanRetryCount", "user") == null) {
            iConfigService.setProperty("ITSANMCapabilityScanRetryCount", "user", this.CAPABILITYSCANRETRY);
        }
        if (iConfigService.getProperty("ITSANMQueryRetryCount", "user") == null) {
            iConfigService.setProperty("ITSANMQueryRetryCount", "user", this.QUERYRETRY);
        }
        if (iConfigService.getProperty("ITSANMRetryDelay", "user") == null) {
            iConfigService.setProperty("ITSANMRetryDelay", "user", this.RETRYDELAY);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void setSnmpCommunityName(String string) {
        String string2 = "setSnmpCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (string != null && !string.trim().equals("")) {
            COMMUNITYNAME = string;
        }
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("SnmpCommunityName", "user", COMMUNITYNAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The SNMP community name was set to " + string);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public static String getSnmpCommunityName() {
        IConfigService iConfigService;
        String string;
        String string2 = "getSnmpCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if ((string = (iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpCommunityName", "user")) == null || string.trim().equals("")) {
            string = COMMUNITYNAME;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Returning the SNMP community name = " + string);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string;
    }

    public void setSnmpWriteCommunityName(String string) {
        String string2 = "setSnmpWriteCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (string != null && !string.trim().equals("")) {
            WRITECOMMUNITYNAME = string;
        }
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("SnmpWriteCommunityName", "user", WRITECOMMUNITYNAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "The SNMP Write Community name was set to " + string);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public static String getSnmpWriteCommunityName() {
        IConfigService iConfigService;
        String string;
        String string2 = "getSnmpWriteCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if ((string = (iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpWriteCommunityName", "user")) == null || string.trim().equals("")) {
            string = WRITECOMMUNITYNAME;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Returning the SNMP Write community name = " + string);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string;
    }

    public void setOutbandAgentMonitorInterval(int n) {
        String string = "setOutbandAgentMonitorInterval";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.MONITORINTERVAL = Integer.toString(n);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("OutbandAgentMonitorInterval", "user", this.MONITORINTERVAL);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "The Outband agent monitor interval was set to " + this.MONITORINTERVAL + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getOutbandAgentMonitorInterval() {
        String string = "getOutbandAgentMonitorInterval";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf(this.MONITORINTERVAL);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String string2 = iConfigService.getProperty("OutbandAgentMonitorInterval", "user");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Returning Outband agent monitor interval = " + n + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public void setSnmpRetryCount(int n) {
        String string = "setSnmpRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.SNMPRETRY = Integer.toString(n);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("SnmpRetryCount", "user", this.SNMPRETRY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "The SNMP retry count was set to " + this.SNMPRETRY + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getSnmpRetryCount() {
        String string = "getSnmpRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf(this.SNMPRETRY);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String string2 = iConfigService.getProperty("SnmpRetryCount", "user");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Returning SNMP retry count = " + n + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public void setSnmpInitialTimeout(int n) {
        String string = "setSnmpInitialTimeout";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.SNMPTIMEOUT = Integer.toString(n);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("SnmpInitialTimeout", "user", this.SNMPTIMEOUT);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "The SNMP timeout was set to " + this.SNMPTIMEOUT + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getSnmpInitialTimeout() {
        String string = "getSnmpInitialTimeout";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf(this.SNMPTIMEOUT);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String string2 = iConfigService.getProperty("SnmpInitialTimeout", "user");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Returning SNMP timeout = " + n + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public boolean performSwitchPing() {
        IConfigService iConfigService;
        String string;
        String string2 = "performSwitchPing";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if ((string = (iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("PerformSwitchPing", "user")) == null) {
            string = this.SWITCHPING;
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Switch Ping = " + string + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string.equalsIgnoreCase("Y") || string.equalsIgnoreCase("YES");
    }

    public boolean performSnmpTimeoutTracing() {
        IConfigService iConfigService;
        String string;
        String string2 = "performSnmpTimeoutTracing";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if ((string = (iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpTimeoutTracing", "user")) == null) {
            string = this.SNMPTIMEOUTTRACING;
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Switch timeout trace = " + string + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string.equalsIgnoreCase("ON");
    }

    public boolean performSnmpTrace() {
        IConfigService iConfigService;
        String string;
        String string2 = "performSnmpTrace";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if ((string = (iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpTrace", "user")) == null) {
            string = this.SNMPTRACE;
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string2, "Switch trace = " + string + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return string.equalsIgnoreCase("ON");
    }

    public void setITSANMCapabilityScanRetryCount(int n) {
        String string = "setITSANMCapabilityScanRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.CAPABILITYSCANRETRY = Integer.toString(n);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("ITSANMCapabilityScanRetryCount", "user", this.CAPABILITYSCANRETRY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "The ITSANM Capability scan retry count was set to " + this.CAPABILITYSCANRETRY + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getITSANMCapabilityScanRetryCount() {
        String string = "getITSANMCapabilityScanRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf(this.CAPABILITYSCANRETRY);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String string2 = iConfigService.getProperty("ITSANMCapabilityScanRetryCount", "user");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Returning ITSANM Capabilty scan retry count = " + n + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public void setITSANMQueryRetryCount(int n) {
        String string = "setITSANMQueryRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.QUERYRETRY = Integer.toString(n);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("ITSANMQueryRetryCount", "user", this.QUERYRETRY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "The ITSANM Query retry count was set to " + this.QUERYRETRY + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getITSANMQueryRetryCount() {
        String string = "getITSANMQueryRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf(this.QUERYRETRY);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String string2 = iConfigService.getProperty("ITSANMQueryRetryCount", "user");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Returning ITSANM Query retry count = " + n + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public void setITSANMRetryDelay(int n) {
        String string = "setITSANMRetryDelay";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.RETRYDELAY = Integer.toString(n);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        iConfigService.setProperty("ITSANMRetryDelay", "user", this.RETRYDELAY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "The ITSANM Query retry delay was set to " + this.RETRYDELAY + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int getITSANMRetryDelay() {
        String string = "getITSANMRetryDelay";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        int n = Integer.valueOf(this.RETRYDELAY);
        IConfigService iConfigService = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String string2 = iConfigService.getProperty("ITSANMRetryDelay", "user");
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Returning ITSANM Query retry delay = " + n + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }
}

