/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventHandler;
import org.eclipse.aperi.monitor.eventcorrelator.NoDelayHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DelayPostEventThread
extends Thread {
    static ILogger sMsgLogger;
    static ILogger sTraceLogger;
    static final String CLASSNAME;
    private EventCorrelatorFactory cEventCorrelator;
    private static HashMap sQuiescedEventList;
    private boolean cPostEventStarted = false;
    private static DelayPostEventThread sEventThread;
    private static int sEventCoolOffPeriod;
    private static final int CONFIG_EVENT_COOLOFF_PERIOD_DEFAULT = 30000;
    private static NoDelayHandler noDelayHandler;
    private static final String CONFIG_EVENT_COOLOFF_PERIOD = "EventCoolOffPeriod";
    private static final String DS_CONFIG_GROUP = "DeviceServer";

    static {
        Class<?> clazz;
        sMsgLogger = EventCorrelatorFactory.msgLogger;
        sTraceLogger = EventCorrelatorFactory.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.DelayPostEventThread");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CLASSNAME = clazz.getName();
        sQuiescedEventList = new HashMap();
        sEventThread = null;
        sEventCoolOffPeriod = -1;
        noDelayHandler = null;
    }

    private DelayPostEventThread(EventCorrelatorFactory eventCorrelatorFactory) {
        super("DelayPostEventThread");
        String string = "DelayPostEventThread";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, string);
        }
        this.cEventCorrelator = eventCorrelatorFactory;
        if (sEventCoolOffPeriod == -1) {
            String string2;
            sEventCoolOffPeriod = 30000;
            IConfigService iConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
            if (iConfigService != null && (string2 = iConfigService.getProperty(CONFIG_EVENT_COOLOFF_PERIOD, DS_CONFIG_GROUP)) != null) {
                sEventCoolOffPeriod = Integer.parseInt(string2);
            }
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string);
        }
    }

    public void run() {
        String string = "run";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_API, (Object)CLASSNAME, string);
        }
        while (this.postEventExist()) {
            try {
                this.setPostEventStarted(false);
                if (sTraceLogger.isLogging()) {
                    sTraceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Started new thread " + this.getName());
                }
                DelayPostEventThread.sleep(sEventCoolOffPeriod);
                if (this.cEventCorrelator.shutdownRequested) {
                    if (sTraceLogger.isLogging()) {
                        sTraceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Posting event are stopped since services are shutting down");
                    }
                    if (sTraceLogger.isLogging()) {
                        sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string);
                    }
                    return;
                }
                if (sTraceLogger.isLogging()) {
                    sTraceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, "About to post external event");
                }
                this.setPostEventStarted(true);
                if (!sTraceLogger.isLogging()) continue;
                sTraceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, "Done post event. " + this.getName());
            }
            catch (Exception exception) {
                if (sTraceLogger.isLogging()) {
                    sTraceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, "Exception thrown while running DelayPostEventThread");
                }
                sTraceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)CLASSNAME, string, (Throwable)exception);
            }
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string);
        }
    }

    public static synchronized void addEvent(String string, SRMEvent sRMEvent, EventCorrelatorFactory eventCorrelatorFactory) {
        String string2 = "addEvent";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, string2);
        }
        boolean bl = false;
        if (sEventThread == null) {
            sEventThread = new DelayPostEventThread(eventCorrelatorFactory);
            bl = true;
        }
        if (noDelayHandler == null) {
            noDelayHandler = new NoDelayHandler(eventCorrelatorFactory);
        }
        if (sRMEvent instanceof CIMIndicationEvent) {
            Integer n = DelayPostEventThread.sEventThread.cEventCorrelator.getIndicationSourceType(((CIMIndicationEvent)sRMEvent).getCIMOM());
            if (n == EventCorrelatorFactory.IS_SWITCH) {
                DelayPostEventThread.addEventToQuiescedList(string, sRMEvent);
            } else {
                NoDelayHandler.publishEvent(sRMEvent);
            }
        } else {
            DelayPostEventThread.addEventToQuiescedList(string, sRMEvent);
        }
        if (bl) {
            sEventThread.start();
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string2);
        }
    }

    private static void addEventToQuiescedList(String string, SRMEvent sRMEvent) {
        if (sQuiescedEventList == null) {
            System.out.println("sQuiescedEventList is null");
        } else {
            sQuiescedEventList.put(string, sRMEvent);
        }
    }

    private synchronized boolean postEventExist() {
        String string = "postEventExist";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, string);
        }
        if (sQuiescedEventList.size() > 0) {
            return true;
        }
        this.deactivateThread();
        try {
            this.setPostEventStarted(false);
        }
        catch (Exception exception) {}
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string);
        }
        return false;
    }

    private synchronized void setPostEventStarted(boolean bl) throws Exception {
        String string = "setPostEventStarted";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_ENTRY, (Object)CLASSNAME, string, (Object)(bl ? "YES" : "NO"));
        }
        this.cPostEventStarted = bl;
        if (bl) {
            Iterator iterator = sQuiescedEventList.values().iterator();
            while (iterator.hasNext()) {
                ExternalEvent externalEvent = (ExternalEvent)iterator.next();
                this.cEventCorrelator.publish((SRMEvent)externalEvent);
                EventHandler.handleEventAlert((SRMEvent)externalEvent);
            }
            sQuiescedEventList.clear();
        }
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string);
        }
    }

    public synchronized void deactivateThread() {
        String string = "deactivateThread";
        if (sTraceLogger.isLogging()) {
            sTraceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)CLASSNAME, string);
        }
        sEventThread = null;
        if (sTraceLogger.isLogging()) {
            sTraceLogger.exit(IRecordType.TYPE_EXIT, (Object)CLASSNAME, string);
        }
    }

    public String toString() {
        return "[post event" + (this.cPostEventStarted ? "" : "not") + "started.]";
    }
}

