/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.dbaccess.CIMOMDbAccess;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.indications.CIMEvent;

public class CIMIndicationEvent
extends ExternalEvent {
    private static final long serialVersionUID = -2509984282340584930L;
    private transient CIMEvent cCimEvent = null;
    private transient CIMOM cCimom = null;
    private transient CIMClientWrapper cCimClient = null;

    public CIMIndicationEvent() {
        this.eventName = "TPC_CIM_INDICATION_EVENT";
    }

    public CIMIndicationEvent(String string, String string2, CIMEvent cIMEvent) {
        super(string, string2);
        this.eventName = "TPC_CIM_INDICATION_EVENT";
        this.cCimEvent = cIMEvent;
    }

    public CIMInstance getCIMInstance() {
        return this.cCimEvent.getIndication();
    }

    public CIMEvent getCIMEvent() {
        return this.cCimEvent;
    }

    public CIMObjectPath getSourceCop() {
        try {
            CIMProperty cIMProperty;
            CIMInstance cIMInstance = this.getCIMInstance();
            CIMProperty cIMProperty2 = cIMInstance.getProperty("SourceInstanceModelPath");
            if (cIMProperty2 != null) {
                String string = (String)cIMInstance.getProperty("SourceInstanceModelPath").getValue().getValue();
                return CIMIndicationEvent.parseWithoutHTTP(string);
            }
            if (cIMProperty2 == null && (cIMProperty = cIMInstance.getProperty("SourceInstance")) != null) {
                String string = (String)cIMInstance.getProperty("SourceInstance").getValue().getValue();
                return CIMIndicationEvent.parseWithHTTP(string);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMInstance getSourceInstance() throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getSourceInstance", null);
        CIMInstance cIMInstance = null;
        try {
            CIMObjectPath cIMObjectPath = this.getSourceCop();
            cIMObjectPath.setNameSpace(this.getCIMNameSpace());
            cIMInstance = this.getCIMClient().getInstance(cIMObjectPath, false, true, logTraceHelper);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit(cIMInstance);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)cIMInstance);
        return cIMInstance;
    }

    public String getCIMNameSpace() {
        String string = null;
        CIMObjectPath cIMObjectPath = this.getSourceCop();
        if (cIMObjectPath != null) {
            string = cIMObjectPath.getNameSpace();
        }
        if (string == null || string.trim().length() == 0) {
            string = this.getCIMInstance().getObjectPath().getNameSpace();
        }
        if (string == null || string.trim().length() == 0) {
            string = this.getCIMOM().getInteropSchemaNamespace();
        }
        return string;
    }

    public CIMOM getCIMOM() {
        if (this.cCimom == null) {
            if (this.cCimEvent.getID() != null && this.cCimEvent.getID().trim().length() > 0) {
                try {
                    this.cCimom = CIMOMDbAccess.getCIMMOMByDBKey((int)Integer.parseInt(this.cCimEvent.getID()));
                }
                catch (Exception exception) {}
            }
            if (this.cCimom == null) {
                CIMOM[] cIMOMArray = CIMOMDbAccess.findCIMOMsByNetAddress((InetAddress)this.cCimEvent.getInetAddress());
                if (cIMOMArray.length == 1) {
                    this.cCimom = cIMOMArray[0];
                } else if (cIMOMArray.length > 1) {
                    throw CimomNotIdentifyable.createAmbiguous(cIMOMArray.length);
                }
            }
            if (this.cCimom == null) {
                throw CimomNotIdentifyable.createNothing();
            }
        }
        return this.cCimom;
    }

    public CIMClientWrapper getCIMClient() {
        if (this.cCimClient == null) {
            CIMOM cIMOM = this.getCIMOM();
            String string = this.getCIMNameSpace();
            this.cCimClient = CIMClientPool.getClient((String)cIMOM.getUserId(), (String)cIMOM.getPassword(), (String)cIMOM.getServiceUrl(), (String)string);
        }
        return this.cCimClient;
    }

    public void close() {
        if (this.cCimClient != null) {
            CIMClientPool.returnClient((CIMClientWrapper)this.cCimClient);
            this.cCimClient = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static CIMObjectPath parseWithoutHTTP(String string) throws CIMException {
        String string2 = string;
        String string3 = string2.substring(0, 4);
        String string4 = string3.toLowerCase();
        if (!string4.startsWith("http")) {
            String string5 = "http://host/";
            string = String.valueOf(string5) + string;
        }
        return CIMIndicationEvent.parseWithHTTP(string);
    }

    public static CIMObjectPath parse(String string) throws CIMException {
        String string2;
        String string3;
        String string4;
        char[] cArray = string.toCharArray();
        int n = 0;
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = 0;
        String string5 = null;
        String string6 = null;
        bl = false;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '.' && !bl4) break;
            if (cArray[n3] == ':') {
                if (bl3) {
                    string5 = new String(cArray, 0, n3);
                    n2 = n3 + 1;
                    bl3 = false;
                    bl4 = true;
                } else {
                    string6 = new String(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    bl4 = false;
                }
            }
            ++n3;
        }
        if (n3 == cArray.length) {
            try {
                string4 = string;
                String string7 = string4.substring(0, 4);
                string3 = string7.toLowerCase();
                if (!string3.startsWith("http")) {
                    String string8 = "http://host/";
                    string = String.valueOf(string8) + string;
                    return CIMIndicationEvent.parse(string);
                }
            }
            catch (CIMException cIMException) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" did not have a '.'" + " as a class delimeter"));
            }
        }
        if (!bl3 && bl4) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" did not have a namespace handle"));
        }
        if (string5 != null && !string5.equalsIgnoreCase("HTTP")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not represent a HTTP namespace"));
        }
        string4 = new String(cArray, n2, n3 - n2);
        int n4 = 0;
        n = ++n3;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (n3 < cArray.length - 1 && c == '\\') {
                if (cArray[n3 + 1] != '\"') {
                    ++n3;
                }
            } else {
                if (c == '\"') {
                    boolean bl5 = bl2 = !bl2;
                }
                if (!bl2) {
                    if (c == '=') {
                        n4 = n3 + 1;
                    }
                    if (c == ',' || n3 + 1 == cArray.length) {
                        String string9;
                        if (n3 + 1 == cArray.length && n4 == 0 && bl) {
                            string3 = new CIMProperty();
                            string3.setName("test it");
                            string9 = cArray[n] != '\"' ? new String(cArray, n, n3 - n + 1) : new String(cArray, n + 1, n3 - n + 1 - 2);
                            string3.setValue(new CIMValue((Object)string9, CIMDataType.getPredefinedType((int)8)));
                            string3.setType(CIMDataType.getPredefinedType((int)8));
                            vector.addElement(string3);
                            break;
                        }
                        if (n3 + 1 == cArray.length) {
                            ++n3;
                        }
                        if (n4 == 0) {
                            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Bad key in string (" + string + ")"));
                        }
                        string3 = new String(cArray, n, n4 - n - 1);
                        string9 = cArray[n4] == '\"' ? CIMIndicationEvent.unEscape(new String(cArray, n4 + 1, n3 - n4 - 2)) : (cArray[n4] == '\\' && cArray[n4 + 1] == '\"' ? CIMIndicationEvent.unEscape(new String(cArray, n4 + 2, n3 - n4 - 3)) : new String(cArray, n4, n3 - n4));
                        n4 = 0;
                        n = ++n3;
                        string2 = new CIMProperty();
                        string2.setName(string3);
                        string2.setValue(new CIMValue((Object)string9, CIMDataType.getPredefinedType((int)8)));
                        string2.setType(CIMDataType.getPredefinedType((int)8));
                        vector.addElement(string2);
                        bl = false;
                    }
                }
            }
            ++n3;
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        if (string6 != null) {
            string3 = null;
            string2 = null;
            if (!string6.substring(0, 2).equals("//")) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not specify a host"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string6, "/", false);
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string10 = stringTokenizer.nextToken();
                if (n5 == 0) {
                    string3 = string10;
                } else {
                    string2 = n5 == 1 ? string10 : string2.concat("/" + string10);
                }
                ++n5;
            }
            if (string3 == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not specify a host"));
            }
            if (string2 == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not specify a namespace"));
            }
            cIMObjectPath.setNameSpace(string2);
            cIMObjectPath.setHost(string3);
        }
        cIMObjectPath.setObjectName(string4);
        int n6 = 0;
        while (n6 < vector.size()) {
            cIMObjectPath.addKey((CIMProperty)vector.elementAt(n6));
            ++n6;
        }
        return cIMObjectPath;
    }

    public static CIMObjectPath parseWithHTTP(String string) throws CIMException {
        String string2;
        Object object;
        char[] cArray = string.toCharArray();
        int n = 0;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        bl = false;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '.' && !bl4) break;
            if (cArray[n3] == ':') {
                if (bl3) {
                    string3 = new String(cArray, 0, n3);
                    n2 = n3 + 1;
                    bl3 = false;
                    bl4 = true;
                } else {
                    string4 = new String(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    bl4 = false;
                }
            }
            ++n3;
        }
        if (n3 == cArray.length) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" did not have a '.' as a class delimeter"));
        }
        if (!bl3 && bl4) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" did not have a namespace handle"));
        }
        if (string3 != null && !string3.equalsIgnoreCase("HTTP")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not represent a HTTP namespace"));
        }
        String string5 = new String(cArray, n2, n3 - n2);
        int n4 = 0;
        n = ++n3;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (n3 < cArray.length - 1 && c == '\\') {
                if (cArray[n3 + 1] != '\"') {
                    ++n3;
                }
            } else {
                if (c == '\"') {
                    boolean bl5 = bl2 = !bl2;
                }
                if (!bl2) {
                    if (c == '=') {
                        n4 = n3 + 1;
                    }
                    if (c == ',' || n3 + 1 == cArray.length) {
                        String string6;
                        if (n3 + 1 == cArray.length && n4 == 0 && bl) {
                            object = new CIMProperty();
                            object.setName("test it");
                            string6 = cArray[n] != '\"' ? new String(cArray, n, n3 - n + 1) : new String(cArray, n + 1, n3 - n + 1 - 2);
                            object.setValue(new CIMValue((Object)string6, CIMDataType.getPredefinedType((int)8)));
                            object.setType(CIMDataType.getPredefinedType((int)8));
                            vector.addElement(object);
                            break;
                        }
                        if (n3 + 1 == cArray.length) {
                            ++n3;
                        }
                        if (n4 == 0) {
                            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Bad key in string (" + string + ")"));
                        }
                        object = new String(cArray, n, n4 - n - 1);
                        string6 = cArray[n4] == '\"' ? CIMIndicationEvent.unEscape(new String(cArray, n4 + 1, n3 - n4 - 2)) : (cArray[n4] == '\\' && cArray[n4 + 1] == '\"' ? CIMIndicationEvent.unEscape(new String(cArray, n4 + 2, n3 - n4 - 3)) : new String(cArray, n4, n3 - n4));
                        n4 = 0;
                        n = ++n3;
                        string2 = new CIMProperty();
                        string2.setName((String)object);
                        string2.setValue(new CIMValue((Object)string6, CIMDataType.getPredefinedType((int)8)));
                        string2.setType(CIMDataType.getPredefinedType((int)8));
                        vector.addElement(string2);
                        bl = false;
                    }
                }
            }
            ++n3;
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        if (string4 != null) {
            object = null;
            string2 = null;
            if (!string4.substring(0, 2).equals("//")) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not specify a host"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "/", false);
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string7 = stringTokenizer.nextToken();
                if (n5 == 0) {
                    object = string7;
                } else {
                    string2 = n5 == 1 ? string7 : string2.concat("/" + string7);
                }
                ++n5;
            }
            if (object == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not specify a host"));
            }
            if (string2 == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + string + "\" does not specify a namespace"));
            }
            cIMObjectPath.setNameSpace(string2);
            cIMObjectPath.setHost((String)object);
        }
        cIMObjectPath.setObjectName(string5);
        int n6 = 0;
        while (n6 < vector.size()) {
            cIMObjectPath.addKey((CIMProperty)vector.elementAt(n6));
            ++n6;
        }
        return cIMObjectPath;
    }

    public static String unEscape(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length * 5 + 1 <= n) {
            return null;
        }
        n = 5 * cArray.length + 1;
        char[] cArray2 = new char[n];
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (c == '\\') {
                if (n3 + 1 < cArray.length) {
                    cArray2[n2++] = cArray[++n3];
                }
                bl = false;
            } else {
                cArray2[n2++] = cArray[n3];
            }
            ++n3;
        }
        if (bl) {
            return string;
        }
        cArray2[n2++] = '\u0000';
        return new String(cArray2, 0, n2 - 1);
    }

    public static class CimomNotIdentifyable
    extends RuntimeException {
        private static final long serialVersionUID = 7591189105549313918L;
        private static final String NOTHING = "CIMOM look-up unsuccesful. No database record found for this network address.";
        private static final String AMBIGUOUS = "CIMOM look-up ambiguous. {1} database records found for this network address.";

        public CimomNotIdentifyable(String string) {
            super(string);
        }

        public static CimomNotIdentifyable createNothing() {
            return new CimomNotIdentifyable(NOTHING);
        }

        public static CimomNotIdentifyable createAmbiguous(int n) {
            return new CimomNotIdentifyable(MessageFormat.format(AMBIGUOUS, new Integer(n)));
        }
    }
}

