/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Hba2NodeAlertPopulator
implements IPopulator {
    public static final String deviceType = "node2hba";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.Hba2NodeAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public Hba2NodeAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getNode2HBAData(string3, hashtable, hashtable2)) {
            String string4;
            short s;
            short s2 = 1;
            int n = this.determineResourceId(string3, hashtable);
            int n2 = this.getAlertId(s2, n, s = 174, string4 = (String)hashtable.get("fromObjectUniqueId"));
            if (n2 > 0) {
                String string5;
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 106;
                int[] nArray = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] nArray2 = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = "TPC_NEW_RELATIONSHIP_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string9 = this.getPRValue(n6, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n6], string9);
                    ++n6;
                }
                String string10 = "PhysicalRelationshipEvent";
                int n7 = 0;
                while (n7 < prTecSlotNames.length) {
                    string7 = (String)hashtable2.get(prTecSlotNames[n7]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(prTecSlotNames[n7], string7);
                    ++n7;
                }
                String string11 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "ALR4072I";
                Object[] objectArray = null;
                String string12 = (String)hashtable.get("toObjectLabel");
                if (string12 == null) {
                    string12 = "";
                }
                if ((string6 = (String)hashtable.get("fromObjectLabel")) == null) {
                    string6 = "";
                }
                if ((string5 = (String)hashtable.get("toObjectHLDLabel")) == null) {
                    string5 = "";
                }
                objectArray = new Object[]{string6, string12, string5};
                fabricAlert = new FabricAlert(n4, n, s2, alertDefinition, nArray, n5, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: node2hba" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: node2hba" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getNode2HBAData(string3, hashtable, hashtable2)) {
            String string4;
            short s;
            short s2 = 1;
            int n3 = this.determineResourceId(string3, hashtable);
            int n4 = this.getAlertId(s2, n3, s = 174, string4 = (String)hashtable.get("fromObjectUniqueId"));
            if (n4 > 0) {
                String string5;
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 103;
                if (n == 1) {
                    n7 = 114;
                }
                int[] nArray = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] nArray2 = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = n == 1 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string9 = this.getPRValue(n8, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n8], string9);
                    ++n8;
                }
                String string10 = "PhysicalRelationshipEvent";
                int n9 = 0;
                while (n9 < prTecSlotNames.length) {
                    string7 = (String)hashtable2.get(prTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(prTecSlotNames[n9], string7);
                    ++n9;
                }
                String string11 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "ALR4073W";
                if (n == 1) {
                    string7 = "ALR4074I";
                }
                Object[] objectArray = null;
                String string12 = (String)hashtable.get("toObjectLabel");
                if (string12 == null) {
                    string12 = "";
                }
                if ((string6 = (String)hashtable.get("fromObjectLabel")) == null) {
                    string6 = "";
                }
                if ((string5 = (String)hashtable.get("toObjectHLDLabel")) == null) {
                    string5 = "";
                }
                objectArray = new Object[]{string6, string12, string5};
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: node2hba" + string3);
            }
        } else {
            throw new AlertCreationException("No object found in db for device: node2hba" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) {
        Alert alert = null;
        return alert;
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private int determineResourceId(String string, Hashtable hashtable) {
        int n = -1;
        String string2 = (String)hashtable.get("toObjectHLDUniqueId");
        n = string2 != null && !string2.equals("") ? Integer.parseInt(string2) : Integer.parseInt(string);
        return n;
    }

    private String getPRValue(int n, Hashtable hashtable) {
        if (prVarNames[n].equals("description")) {
            return prVarNames[n];
        }
        if (prVarNames[n].equals("messageId")) {
            return prVarNames[n];
        }
        return (String)hashtable.get(prVarNames[n]);
    }

    private int getAlertId(short s, int n, short s2, String string) {
        int n2 = -1;
        n2 = EventDBAccessor.getAlertIDByResource(s, n, s2);
        if (n2 <= 0) {
            String string2 = EventDBAccessor.getFabricIdForNode(string);
            if (string2 != null && !string2.equals("")) {
                n2 = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(string2), s2);
            }
            if (n2 <= 0) {
                n2 = EventDBAccessor.getAlertIDByResource(s, -1, s2);
            }
        }
        return n2;
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

