/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.interfaces;

import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventXMLParser;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.DataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.ExtractEventFailedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InvalidParameterException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartAction;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.Source;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SnmpSanEventExtractor {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.interfaces.SnmpSanEventExtractor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SmartEvent[] extractEvent(DataManager dataManager, String string) throws ExtractEventFailedException {
        Cloneable cloneable;
        Object object;
        Object object2;
        String string2 = "extractEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter= " + dataManager + " and " + string));
        }
        SmartEvent smartEvent = null;
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "In SnmpSanEventExtractor.extractEvent Parsing Data from xml");
        }
        XMLReader xMLReader = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        try {
            object2 = SAXParserFactory.newInstance();
            ((SAXParserFactory)object2).setValidating(true);
            object = ((SAXParserFactory)object2).newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
            EventXMLParser eventXMLParser = new EventXMLParser();
            xMLReader.setContentHandler(eventXMLParser);
            xMLReader.setErrorHandler(eventXMLParser);
            xMLReader.parse(new InputSource(new StringReader(string)));
            string3 = eventXMLParser.getEventIds()[0];
            string4 = eventXMLParser.getTimeStamps()[0];
            string5 = eventXMLParser.getSourceNames()[0];
            string6 = eventXMLParser.getSourceAddresses()[0];
            string7 = eventXMLParser.getSourceSpecifics()[0];
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "In SnmpSanEventExtractor.extractEvent Parsing Data from xml-done");
            }
        }
        catch (Exception exception) {
            try {
                SmartEvent smartEvent2 = new SmartEvent("name", "address", "Specific Info", "ActionTarget", 0, "ActionDescription", 0, 0, "description", Calendar.getInstance());
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return new SmartEvent[]{smartEvent2};
            }
            catch (Exception exception2) {
                throw new ExtractEventFailedException();
            }
        }
        object2 = String.valueOf(string3) + "." + "Snmp";
        object = dataManager.getData(String.valueOf(object2) + ".SmartEvent.EventType");
        int n = Integer.parseInt((String)object);
        String string8 = dataManager.getData(String.valueOf(object2) + ".SmartEvent.Priority");
        int n2 = Integer.parseInt(string8);
        String string9 = dataManager.getData(String.valueOf(object2) + ".SmartEvent.Description");
        String string10 = dataManager.getData(String.valueOf(object2) + ".SmartEvent.SmartAction.Target");
        String string11 = dataManager.getData(String.valueOf(object2) + ".SmartEvent.SmartAction.ActionType");
        int n3 = Integer.parseInt(string11);
        String string12 = dataManager.getData(String.valueOf(object2) + ".SmartEvent.SmartAction.ActionDescription");
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "In SnmpSanEventExtractor.extractEvent Dot the descriptions");
        }
        Date date = null;
        try {
            cloneable = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
            date = ((DateFormat)cloneable).parse(string4);
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
            throw new ExtractEventFailedException();
        }
        cloneable = Calendar.getInstance();
        ((Calendar)cloneable).setTime(date);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "In SnmpSanEventExtractor.extractEvent Created the calendar");
        }
        try {
            Source source = new Source(string5, string6, string7);
            SmartAction smartAction = new SmartAction(string10, n3, string12);
            smartEvent = new SmartEvent(source, smartAction, n, n2, string9, (Calendar)cloneable);
        }
        catch (InvalidParameterException invalidParameterException) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)invalidParameterException);
            }
            throw new ExtractEventFailedException();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return new SmartEvent[]{smartEvent};
    }
}

