/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.outbandchangeagent.OutbandChangeAgentProperty;
import org.eclipse.aperi.monitor.snmp.EventFilter;
import org.eclipse.aperi.monitor.snmp.SNMPReceiver;
import org.eclipse.aperi.monitor.snmp.SnmpV2Monitor;
import org.eclipse.aperi.monitor.snmp.SocketManager;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.TrapFilter;
import org.eclipse.aperi.snmp.TrapListener;
import org.eclipse.aperi.snmp.data.OctetString;

public class SnmpMonitor
implements TrapFilter,
TrapListener {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    public OutbandChangeAgentProperty iSnmpCAP = null;
    public ResourceBundle resourceBundle = null;
    private EventCorrelatorFactory eventMonitor = null;
    private SnmpV2Monitor snmpV2Monitor = null;
    private SocketManager sManager = null;
    private SNMPReceiver sReceiver = null;

    static {
        Class<?> clazz;
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.snmp.SnmpMonitor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SnmpMonitor(EventCorrelatorFactory eventCorrelatorFactory) {
        String string = "SnmpMonitor";
        this.eventMonitor = eventCorrelatorFactory;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
    }

    private String convertSpecialSymbol(String string) {
        char c = '&';
        String string2 = new String();
        int n = 0;
        while (n < string.length()) {
            string2 = string.charAt(n) == c ? (string.substring(n, string.length()).length() >= 5 ? (!string.substring(n, n + 5).equals("&amp;") ? string2.concat("&amp;") : string2.concat(String.valueOf(string.charAt(n)))) : string2.concat("&amp;")) : string2.concat(String.valueOf(string.charAt(n)));
            ++n;
        }
        return string2;
    }

    public void handle(SnmpTrap snmpTrap) {
        String string = "handle";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        try {
            this.eventMonitor.postSnmpEvent(snmpTrap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public boolean filter(SnmpTrap snmpTrap) {
        CharSequence charSequence;
        System.currentTimeMillis();
        String string = "filter";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            charSequence = new StringBuffer();
            Vector vector = snmpTrap.varBindList();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                SnmpVarBind snmpVarBind = (SnmpVarBind)iterator.next();
                ((StringBuffer)charSequence).append("\t(" + snmpVarBind.get_printable_oid() + "=");
                if (snmpVarBind.get_value() instanceof OctetString) {
                    ((StringBuffer)charSequence).append(String.valueOf(((OctetString)snmpVarBind.get_value()).toDisplayString()) + ")\n");
                    continue;
                }
                ((StringBuffer)charSequence).append(String.valueOf(snmpVarBind.get_printable_value()) + ")\n");
            }
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Trap Received:\n\taddress=" + snmpTrap.agentAddr + " enterprise=" + snmpTrap.enterprise + " generictrap=" + snmpTrap.genericTrap + " specifictrap=" + snmpTrap.specificTrap + "\n" + charSequence);
        }
        charSequence = EventFilter.filterTrap(snmpTrap);
        if (traceLogger.isLogging() && charSequence != null) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Filtered by filter " + (String)charSequence);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, charSequence == null);
        }
        System.currentTimeMillis();
        return charSequence == null;
    }

    public boolean initialize() {
        String string = "initialize";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (this.iSnmpCAP == null) {
            this.iSnmpCAP = new OutbandChangeAgentProperty();
        }
        int n = Integer.parseInt(this.iSnmpCAP.getSnmpTrapPort());
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "SnmpChangeAgent_TrapPort = " + n);
        }
        int n2 = Integer.parseInt(this.iSnmpCAP.getSnmpForwardingPort());
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, string, "SnmpChangeAgent_ForwardingPort = " + n2);
        }
        this.sManager = new SocketManager(n, n2);
        this.sManager.start();
        this.snmpV2Monitor = new SnmpV2Monitor(this.eventMonitor);
        this.sReceiver = new SNMPReceiver(n2, this, this.snmpV2Monitor);
        this.sReceiver.start();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public boolean shutdown() {
        String string = "shutdown";
        boolean bl = false;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.sManager.requestStop();
        this.sReceiver.requestStop();
        bl = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }
}

