/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.Agent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.IAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.UnknownAgentException;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentBuilder
implements IAgentBuilder {
    static final String className;
    private String _hostName;
    private GUID _guid;
    private String _ipAddress;
    private int _agentPort;
    private int _hostID;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    AgentBuilder(GUID gUID, int n, AgentTableReader agentTableReader) throws SQLException, UnknownAgentException {
        block6: {
            DeviceAgent.DeviceAgentCursor deviceAgentCursor = null;
            String string = gUID + ":" + n;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)this, "HostBuilder", (Object)string);
            }
            if (!(deviceAgentCursor = agentTableReader.queryHost(gUID, n)).next()) {
                SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)this, "HostBuilder", "Agent_notExistDB", (Object)string);
                String string2 = String.valueOf(string) + "  is not a known Host.";
                if (SANDiskMgrHostService.trace.isLogging()) {
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "HostBuilder", string2);
                }
                throw new UnknownAgentException();
            }
            DeviceAgent deviceAgent = deviceAgentCursor.getAttributes();
            deviceAgentCursor.close();
            deviceAgentCursor = null;
            Host host = agentTableReader.getResHost(deviceAgent.getHostId());
            this._hostName = host.getHostUrl();
            this._hostID = deviceAgent.getDeviceAgentId();
            this._ipAddress = host.getIpAddress();
            this._agentPort = deviceAgent.getPort();
            try {
                this._guid = new GUID(host.getGuid(), 0);
            }
            catch (Exception exception) {
                SANDiskMgrHostService.messages.exception((Object)className, "HostBuilder", (Throwable)exception);
                if (!SANDiskMgrHostService.trace.isLogging()) break block6;
                SANDiskMgrHostService.trace.exception((Object)className, "HostBuilder", (Throwable)exception);
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)this, "HostBuilder");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Agent getHost(GUID gUID, int n) throws TdmException {
        AgentBuilder agentBuilder;
        block11: {
            agentBuilder = null;
            String string = gUID + ":" + n;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "getHost", (Object)string);
            }
            AgentTableReader agentTableReader = null;
            try {
                try {
                    agentTableReader = SANDiskMgrHostService.getHostTableReader();
                    agentBuilder = new AgentBuilder(gUID, n, agentTableReader);
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getHost", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getHost", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getHost", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getHost", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (agentTableReader != null) {
                    agentTableReader.close();
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (agentTableReader == null) break block11;
                agentTableReader.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getHost");
        }
        return new Agent((IAgentBuilder)agentBuilder);
    }

    AgentBuilder(DeviceAgent.DeviceAgentCursor deviceAgentCursor, AgentTableReader agentTableReader) throws SQLException {
        block2: {
            DeviceAgent deviceAgent = deviceAgentCursor.getAttributes();
            Host host = agentTableReader.getResHost(deviceAgent.getHostId());
            this._hostName = host.getHostUrl();
            this._hostID = deviceAgent.getDeviceAgentId();
            this._ipAddress = host.getIpAddress();
            this._agentPort = deviceAgent.getPort();
            try {
                this._guid = new GUID(host.getGuid(), 0);
            }
            catch (Exception exception) {
                SANDiskMgrHostService.messages.exception((Object)className, "HostBuilder", (Throwable)exception);
                if (!SANDiskMgrHostService.trace.isLogging()) break block2;
                SANDiskMgrHostService.trace.exception((Object)className, "HostBuilder", (Throwable)exception);
            }
        }
    }

    public int getHostID() {
        return this._hostID;
    }

    public String getHostName() {
        return this._hostName;
    }

    public GUID getGUID() {
        return this._guid;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._agentPort;
    }
}

