/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;
import javax.jms.Message;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.PeerDataException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.RemoveActiveAgentException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.UnknownAgentException;
import org.eclipse.aperi.sanmgmt.event.TESTopicExtensionMgr;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.messaging.impl.TESTopicImpl;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;

class HostManager {
    static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.HostManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    HostManager() {
    }

    static TdmAgent bldTdmHostObject(HostQueryInfo hostQueryInfo) throws PeerDataException {
        String string = "";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "bldTdmHostObject");
        }
        TdmAgent tdmAgent = new TdmAgent();
        tdmAgent.version = hostQueryInfo.hostVersion;
        tdmAgent.agentName = hostQueryInfo.hostName;
        tdmAgent.guid = hostQueryInfo.GUID;
        if (tdmAgent.agentName == null || tdmAgent.agentName.equals("")) {
            SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "bldTdmHostObject", "Agent_nameError");
            string = "The Agent returns invalid host name.";
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "bldTdmHostObject", string);
            }
            throw new PeerDataException();
        }
        tdmAgent.ipAddress = hostQueryInfo.hostIP;
        tdmAgent.agentPort = Integer.parseInt(hostQueryInfo.hostPort);
        tdmAgent.osname = hostQueryInfo.osName;
        tdmAgent.status_lstchanged = new Date();
        tdmAgent.status = "AC";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "bldTdmHostObject");
        }
        return tdmAgent;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String addTdmHost(AgentTableUpdater agentTableUpdater, TdmAgent tdmAgent) {
        String string;
        block13: {
            string = null;
            boolean bl = true;
            DeviceAgent.DeviceAgentCursor deviceAgentCursor = null;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "addTdmHost");
            }
            try {
                try {
                    deviceAgentCursor = agentTableUpdater.queryHost(tdmAgent.guid, tdmAgent.agentPort);
                    if (deviceAgentCursor.next()) {
                        DeviceAgent deviceAgent = deviceAgentCursor.getAttributes();
                        deviceAgent.getStatus();
                        tdmAgent.index = deviceAgent.getDeviceAgentId();
                        HostManager.sqlUpdateTdmHost2HostTable(agentTableUpdater, tdmAgent, bl);
                        string = "AC";
                    } else if (agentTableUpdater.createHost(tdmAgent)) {
                        string = "AC";
                    }
                }
                catch (Exception exception) {
                    SANDiskMgrHostService.messages.exception((Object)className, "addTdmHost", (Throwable)exception);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "addTdmHost", (Throwable)exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (deviceAgentCursor == null) throw throwable;
                try {
                    deviceAgentCursor.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (deviceAgentCursor == null) break block13;
            }
            try {}
            catch (SQLException sQLException) {}
            deviceAgentCursor.close();
        }
        if (!SANDiskMgrHostService.trace.isLogging()) return string;
        SANDiskMgrHostService.trace.exit((Object)className, "addTdmHost", string);
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getHostIdByTdmHost(AgentTableReader agentTableReader, GUID gUID, int n) throws UnknownAgentException {
        String string = gUID + ":" + n;
        int n2 = -1;
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getHostIdByTdmHost", (Object)string);
        }
        try {
            try {
                deviceAgentCursor = agentTableReader.queryHost(gUID, n);
                if (!deviceAgentCursor.next()) {
                    SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "getHostIdByTdmHost", "Agent_notExistDB", (Object)string);
                    String string2 = String.valueOf(string) + " is not a known Host.";
                    if (!SANDiskMgrHostService.trace.isLogging()) throw new UnknownAgentException();
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getHostIdByTdmHost", string2);
                    throw new UnknownAgentException();
                }
                DeviceAgent deviceAgent = deviceAgentCursor.getAttributes();
                n2 = deviceAgent.getDeviceAgentId();
            }
            catch (Exception exception) {
                SANDiskMgrHostService.messages.exception((Object)className, "getHostIdByTdmHost", (Throwable)exception);
                if (!SANDiskMgrHostService.trace.isLogging()) throw new UnknownAgentException();
                SANDiskMgrHostService.trace.exception((Object)className, "getHostIdByTdmHost", (Throwable)exception);
                throw new UnknownAgentException();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (deviceAgentCursor == null) throw throwable;
                deviceAgentCursor.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        try {}
        catch (Exception exception) {}
        if (deviceAgentCursor != null) {
            deviceAgentCursor.close();
        }
        if (!SANDiskMgrHostService.trace.isLogging()) return n2;
        SANDiskMgrHostService.trace.exit((Object)className, "getHostIdByTdmHost", n2);
        return n2;
    }

    private static int sqlUpdateTdmHost2HostTable(AgentTableUpdater agentTableUpdater, TdmAgent tdmAgent, boolean bl) {
        int n = -1;
        String string = tdmAgent.getUniqueAgentName();
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "sqlUpdateTdmHost2HostTable", (Object)string, (Object)new Boolean(bl));
        }
        try {
            n = agentTableUpdater.updateHost(tdmAgent, bl);
        }
        catch (Exception exception) {
            SANDiskMgrHostService.messages.exception((Object)className, "sqlUpdateTdmHost2HostTable", (Throwable)exception);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "sqlUpdateTdmHost2HostTable", (Throwable)exception);
            }
            n = -1;
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "sqlUpdateTdmHost2HostTable", n);
        }
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void fireDiskMgrHostEvent(GUID var0, int var1_1, String var2_2) {
        block15: {
            var3_3 = var0 + ":" + var1_1;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)HostManager.className, "fireDiskMgrHostEvent", (Object)var3_3, (Object)var2_2);
            }
            var4_4 = null;
            var5_5 = var3_3;
            SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)HostManager.className, "fireDiskMgrHostEvent", var5_5);
            try {
                try {
                    var6_6 = SANDiskMgrHostService.getFactory();
                    var7_8 = TESTopicExtensionMgr.getExtensionMgr();
                    var8_9 = (TESTopicImpl)var7_8.getExtensionImpl("org.eclipse.aperi.monitor.eventcorrelator.data.DiskMgrAgentEvent");
                    v0 = new Class[3];
                    try {
                        v1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v2) {
                        throw new NoClassDefFoundError(v2.getMessage());
                    }
                    v0[0] = v1;
                    v0[1] = Integer.TYPE;
                    try {
                        v3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v4) {
                        throw new NoClassDefFoundError(v4.getMessage());
                    }
                    v0[2] = v3;
                    var9_10 = (TESTopicImpl)var8_9.getClass().getConstructor(v0).newInstance(new Object[]{var0.toNoDotString(), new Integer(var1_1), var2_2});
                    var10_11 = var6_6.createMessage(null);
                    var10_11.setStringProperty("publisherID", "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename");
                    var4_4 = var6_6.createPublisher(var9_10.getClass().getName(), (Message)var10_11);
                    var11_12 = var6_6.createMessage((Serializable)var9_10);
                    var4_4.publish((Message)var11_12);
                }
                catch (Exception var6_7) {
                    SANDiskMgrHostService.messages.exception((Object)HostManager.className, "fireDiskMgrHostEvent", (Throwable)var6_7);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)HostManager.className, "fireDiskMgrHostEvent", (Throwable)var6_7);
                    }
                }
            }
            catch (Throwable var13_13) {
                var12_14 = null;
                try {
                    if (var4_4 == null) throw var13_13;
                    var4_4.close();
                    throw var13_13;
                }
                catch (Exception var14_16) {
                    SANDiskMgrHostService.messages.exception((Object)HostManager.className, "fireDiskMgrHostEvent", (Throwable)var14_16);
                    if (SANDiskMgrHostService.trace.isLogging() == false) throw var13_13;
                    SANDiskMgrHostService.trace.exception((Object)HostManager.className, "fireDiskMgrHostEvent", (Throwable)var14_16);
                }
                throw var13_13;
            }
            {
                var12_15 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 311->326)] { 
lbl52:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            break block15;
lbl55:
            // 1 sources

            catch (Exception var14_17) {
                SANDiskMgrHostService.messages.exception((Object)HostManager.className, "fireDiskMgrHostEvent", (Throwable)var14_17);
                if (!SANDiskMgrHostService.trace.isLogging()) break block15;
                SANDiskMgrHostService.trace.exception((Object)HostManager.className, "fireDiskMgrHostEvent", (Throwable)var14_17);
            }
        }
        if (SANDiskMgrHostService.trace.isLogging() == false) return;
        SANDiskMgrHostService.trace.exit((Object)HostManager.className, "fireDiskMgrHostEvent");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int isHostInactive(AgentTableReader agentTableReader, GUID gUID, int n) throws UnknownAgentException, RemoveActiveAgentException, SqlException {
        String string = gUID + ":" + n;
        int n2 = -1;
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "isHostInactive", (Object)string);
        }
        try {
            try {
                deviceAgentCursor = agentTableReader.queryHost(gUID, n);
                if (!deviceAgentCursor.next()) {
                    SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "isHostInactive", "Agent_notExistDB", (Object)string);
                    String string2 = String.valueOf(string) + " is not a known Host.";
                    if (!SANDiskMgrHostService.trace.isLogging()) throw new UnknownAgentException();
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "isHostInactive", string2);
                    throw new UnknownAgentException();
                }
                DeviceAgent deviceAgent = deviceAgentCursor.getAttributes();
                n2 = deviceAgent.getDeviceAgentId();
                String string3 = deviceAgent.getStatus();
                if (string3.equals("AC")) {
                    SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "isHostInactive", "Agent_removeActiveError", (Object)string);
                    String string4 = "Agent " + string + " can not be removed because it is active.";
                    if (!SANDiskMgrHostService.trace.isLogging()) throw new RemoveActiveAgentException();
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "isHostInactive", string4);
                    throw new RemoveActiveAgentException();
                }
            }
            catch (SQLException sQLException) {
                SANDiskMgrHostService.messages.exception((Object)className, "isHostInactive", (Throwable)sQLException);
                if (!SANDiskMgrHostService.trace.isLogging()) throw new SqlException(sQLException);
                SANDiskMgrHostService.trace.exception((Object)className, "isHostInactive", (Throwable)sQLException);
                throw new SqlException(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (deviceAgentCursor == null) throw throwable;
                deviceAgentCursor.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (Exception exception) {}
        if (deviceAgentCursor != null) {
            deviceAgentCursor.close();
        }
        if (!SANDiskMgrHostService.trace.isLogging()) return n2;
        SANDiskMgrHostService.trace.exit((Object)className, "isHostInactive", string);
        return n2;
    }

    static void removeHost(AgentTableUpdater agentTableUpdater, int n) throws SqlException {
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "removeHost", (Object)new Integer(n));
        }
        try {
            agentTableUpdater.deleteHost(n);
        }
        catch (SQLException sQLException) {
            SANDiskMgrHostService.messages.exception((Object)className, "removeHost", (Throwable)sQLException);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "removeHost", (Throwable)sQLException);
            }
            throw new SqlException(sQLException);
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "removeHost");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void removeInactiveHost(GUID gUID, int n) throws TdmException {
        block11: {
            String string = gUID + ":" + n;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "removeInactiveHost", (Object)string);
            }
            AgentTableUpdater agentTableUpdater = null;
            int n2 = -1;
            try {
                try {
                    agentTableUpdater = SANDiskMgrHostService.getHostTableUpdater();
                    n2 = HostManager.isHostInactive(agentTableUpdater, gUID, n);
                    HostManager.removeHost(agentTableUpdater, n2);
                    HostManager.fireDiskMgrHostEvent(gUID, n, "RM");
                    SANDiskMgrHostService.messages.message(IRecordType.TYPE_INFO, (Object)className, "removeInactiveHost", "User_removeInactiveAgent", (Object)string);
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "removeInactiveHost", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "removeInactiveHost", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "removeInactiveHost", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "removeInactiveHost", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (agentTableUpdater != null) {
                    agentTableUpdater.close();
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (agentTableUpdater == null) break block11;
            }
            agentTableUpdater.close();
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "removeInactiveHost");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getPolicyDomainIDFromAgent(GUID gUID, int n) throws TdmException {
        int n2;
        block12: {
            String string = gUID + ":" + n;
            n2 = -1;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "getPolicyDomainIDFromAgent", (Object)string);
            }
            AgentTableReader agentTableReader = null;
            try {
                try {
                    agentTableReader = SANDiskMgrHostService.getHostTableReader();
                    n2 = agentTableReader.getPolicyDomainIDFromAgent(gUID, n);
                    if (n2 == -1) {
                        SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getPolicyDomainIDFromAgent", "Agent not found");
                        throw new UnknownAgentException();
                    }
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (agentTableReader != null) {
                    agentTableReader.close();
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (agentTableReader == null) break block12;
                agentTableReader.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getPolicyDomainIDFromAgent", n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void moveAgentToDomain(GUID gUID, int n, int n2) throws TdmException {
        int n3;
        block12: {
            String string = gUID + ":" + n;
            n3 = 0;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "moveAgentToDomain", (Object)string);
            }
            AgentTableUpdater agentTableUpdater = null;
            try {
                try {
                    agentTableUpdater = SANDiskMgrHostService.getHostTableUpdater();
                    n3 = agentTableUpdater.moveAgentToDomain(gUID, n, n2);
                    if (n3 == 0) {
                        SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "moveAgentToDomain", "Agent not found");
                        throw new UnknownAgentException();
                    }
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "moveAgentToDomain", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "moveAgentToDomain", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "moveAgentToDomain", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "moveAgentToDomain", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (agentTableUpdater != null) {
                    agentTableUpdater.close();
                }
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (agentTableUpdater == null) break block12;
            }
            agentTableUpdater.close();
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "moveAgentToDomain", n3);
        }
    }
}

