/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.script;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ParamsObject
extends ScriptableObject {
    ModuleHandle module;
    private static final long serialVersionUID = 423299092113453L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParamsObject(ModuleHandle module) {
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.module = module;
    }

    public String getClassName() {
        return "BirtParams";
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        return this.module.findParameter(name) != null;
    }

    public Object get(String name, Scriptable start) {
        Object val = super.get(name, start);
        if (val != NOT_FOUND) {
            return val;
        }
        if (name.equals("length")) {
            return new Integer(this.module.getAllParameters().size());
        }
        ParameterHandle param = this.module.findParameter(name);
        if (param != null) {
            val = this.getParamDefaultValue(param);
        }
        return val;
    }

    private Object getParamDefaultValue(ParameterHandle param) {
        if (!(param instanceof ScalarParameterHandle)) {
            return null;
        }
        ScalarParameterHandle sp = (ScalarParameterHandle)param;
        String defaultValue = sp.getDefaultValue();
        String type = sp.getDataType();
        if (defaultValue == null) {
            if (sp.allowNull()) {
                return null;
            }
            if ("string".equals(type)) {
                if (sp.allowBlank()) {
                    return "";
                }
                return "null";
            }
            if ("float".equals(type)) {
                return new Double(0.0);
            }
            if ("decimal".equals(type)) {
                return new BigDecimal(0.0);
            }
            if ("dateTime".equals(type)) {
                return new Date(0L);
            }
            if ("boolean".equals(type)) {
                return Boolean.FALSE;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        int typeNum = 0;
        if ("string".equals(type)) {
            typeNum = 5;
        } else if ("float".equals(type)) {
            typeNum = 3;
        } else if ("decimal".equals(type)) {
            typeNum = 4;
        } else if ("dateTime".equals(type)) {
            typeNum = 6;
        } else if ("boolean".equals(type)) {
            typeNum = 1;
        }
        try {
            return DataTypeUtil.convert((Object)defaultValue, (int)typeNum);
        }
        catch (BirtException e) {
            return null;
        }
    }

    static {
        $assertionsDisabled = !ParamsObject.class.desiredAssertionStatus();
    }
}

