/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.San.common.EndToEndAdjuster;
import org.eclipse.aperi.San.common.EndToEndGrapher;
import org.eclipse.aperi.San.server.guireq.RespEndToEnd;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class EndToEndTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
TJCTableMouseInterface,
AskForRowIconInterface,
ActionListener,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespEndToEnd[] data;
    private EndToEndAdjuster adjuster;
    private EndToEndGrapher grapher;
    private boolean hasHistory;

    public EndToEndTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        this.hasHistory = guiReportReq.reportSubtype == 73 || guiReportReq.bySubtype == 73;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.setLayout(new BorderLayout());
        this.adjuster = new EndToEndAdjuster(guiReportReq);
        this.grapher = new EndToEndGrapher();
    }

    public void handleResponse(short s, Response response) {
        Class<?> clazz;
        this.data = s <= 4 ? (RespEndToEnd[])response.responseData : null;
        int n = this.data != null ? this.data.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespEndToEnd[])this.adjuster.getArray();
        try {
            clazz = Class.forName("org.eclipse.aperi.common.MutableLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz, TableCellRenderers.space);
        if (this.hasHistory) {
            this.table.setRowIcon(13, false);
        }
        this.table.setMouseListener(this);
        this.table.iconChanger = this;
        if (this.adjuster.frozenRows > 0) {
            this.table.setFrozenRows(this.adjuster.frozenRows);
            this.table.setFrozenRowBackground(Color.yellow);
        }
        if (this.adjuster.frozenColumns > 0) {
            this.table.setFrozenColumns(this.adjuster.frozenColumns);
        }
        this.table.setBaseTableModel(new EndToEndModel());
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart && this.hasHistory) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public boolean select(int n, int n2) {
        boolean bl;
        if (!this.hasHistory) {
            bl = false;
        } else {
            int n3 = this.table.getDataRow(n);
            bl = this.data[n3].reeFilesystemID > 0L;
        }
        return bl;
    }

    public void selectionChanged(boolean bl) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (this.hasHistory) {
            boolean bl = this.table.rowsSelected();
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5105L"));
            jMenuItem.setActionCommand("STG5105L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5107L"));
            jMenuItem.setActionCommand("STG5107L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5109L"));
            jMenuItem.setActionCommand("STG5109L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        EndToEndTable endToEndTable = this.hasHistory ? this : null;
        return endToEndTable;
    }

    public void doubleClick(int n, int n2) {
        this.showDefaultChart(n);
    }

    public void showDefaultChart(int n) {
        if (!this.changeIcon(n)) {
            int[] nArray = new int[]{n};
            this.createHistory("STG5105L", nArray);
        }
    }

    public void showJumpChart() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            nArray[n] = this.table.getDataRow(n);
            ++n;
        }
        this.createHistory("STG5105L", nArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.createHistory(actionEvent.getActionCommand(), this.table.getSelectedRows());
    }

    private void createHistory(String string, int[] nArray) {
        if (nArray.length > 0) {
            GuiReportReq guiReportReq = this.grapher.createHistory(this.grr, this.data, nArray, string);
            this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(guiReportReq.historyTitle), this);
        }
    }

    public boolean changeIcon(int n) {
        return !this.hasHistory || this.data[n].reeFilesystemID <= 0L;
    }

    public EndToEndTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = null;
        if (n2 == 73 || n2 == 74) {
            objectArray = new Object[3];
            String[] stringArray = new String[]{"STG5105L", "STG5107L", "STG5109L"};
            byte[] byArray = new byte[]{1, 1, 1};
            byte[] byArray2 = new byte[]{1, 3, 5};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
            objectArray[2] = byArray2;
        }
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        return null;
    }

    public int[] getGraphID(String string) {
        return null;
    }

    private class EndToEndModel
    extends BaseTableModel {
        public EndToEndModel() {
            this.columnNames = ((EndToEndTable)EndToEndTable.this).adjuster.namesArray;
            this.rowCount = EndToEndTable.this.data.length;
            this.commonAdjuster = EndToEndTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return EndToEndTable.this.adjuster.getCellData(n, EndToEndTable.this.adjuster.translateColumn(n2));
        }
    }
}

