/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskAdjuster
extends CustomReportDataAdjuster {
    static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    static final String PATH = MessageLog.getMessageNoID("STG1219L");
    static final String IN_DISK_ARRAY = MessageLog.getMessageNoID("SAG0200L");
    static final String MANUF = MessageLog.getMessageNoID("STG1105L");
    static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    static final String RPM = MessageLog.getMessageNoID("STG1163L");
    static final String READ_CACHE = MessageLog.getMessageNoID("STG1196L");
    static final String WRITE_CACHE = MessageLog.getMessageNoID("STG1197L");
    static final String FAILURE = MessageLog.getMessageNoID("STG1173L");
    static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    static final String DISCOVERED_TIME = MessageLog.getMessageNoID("STG1134L");
    static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    static final String UNALLOCATED = MessageLog.getMessageNoID("STG4131L");
    static final String DEFECTS_PRI = MessageLog.getMessageNoID("STG1174L");
    static final String DEFECTS_GROWN = MessageLog.getMessageNoID("STG1175L");
    static final String RECOVERED_ERR = MessageLog.getMessageNoID("STG1178L");
    static final String UNRECOVERED_ERR = MessageLog.getMessageNoID("STG1179L");
    static final String WRITE_BYTES = MessageLog.getMessageNoID("STG1204L");
    static final String READ_BYTES = MessageLog.getMessageNoID("STG1207L");
    static final String AWRE_CURR = MessageLog.getMessageNoID("STG1168L");
    static final String AWRE_NEXT = MessageLog.getMessageNoID("STG1245L");
    static final String ARRE_CURR = MessageLog.getMessageNoID("STG1169L");
    static final String ARRE_NEXT = MessageLog.getMessageNoID("STG1246L");
    static final String NER_CURR = MessageLog.getMessageNoID("STG1170L");
    static final String NER_NEXT = MessageLog.getMessageNoID("STG1247L");
    static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    static final String YES = MessageLog.getMessageNoID("GUI0121T");
    static final String NO = MessageLog.getMessageNoID("GUI0122T");
    static final String ON = MessageLog.getMessageNoID("GUI0123T");
    static final String OFF = MessageLog.getMessageNoID("GUI0124T");
    public String[] colNames = new String[]{COMPUTER, PATH, MANUF, MODEL, IN_DISK_ARRAY, RPM, READ_CACHE, WRITE_CACHE, FAILURE, PROBE_TIME, DISCOVERED_TIME, CAPACITY, UNALLOCATED, DEFECTS_PRI, DEFECTS_GROWN, RECOVERED_ERR, UNRECOVERED_ERR, WRITE_BYTES, READ_BYTES, AWRE_CURR, AWRE_NEXT, ARRE_CURR, ARRE_NEXT, NER_CURR, NER_NEXT};
    private static final int COMPUTER_COL = 0;
    private static final int PATH_COL = 1;
    private static final int MANUF_COL = 2;
    private static final int MODEL_COL = 3;
    private static final int IN_DISK_ARRAY_COL = 4;
    private static final int RPM_COL = 5;
    private static final int READ_CACHE_COL = 6;
    private static final int WRITE_CACHE_COL = 7;
    private static final int FAILURE_COL = 8;
    private static final int PROBE_TIME_COL = 9;
    private static final int DISCOVERED_TIME_COL = 10;
    private static final int CAPACITY_COL = 11;
    private static final int UNALLOCATED_COL = 12;
    private static final int DEFECTS_PRI_COL = 13;
    private static final int DEFECTS_GROWN_COL = 14;
    private static final int RECOVERED_ERR_COL = 15;
    private static final int UNRECOVERED_ERR_COL = 16;
    private static final int WRITE_BYTES_COL = 17;
    private static final int READ_BYTES_COL = 18;
    private static final int AWRE_CURR_COL = 19;
    private static final int AWRE_NEXT_COL = 20;
    private static final int ARRE_CURR_COL = 21;
    private static final int ARRE_NEXT_COL = 22;
    private static final int NER_CURR_COL = 23;
    private static final int NER_NEXT_COL = 24;
    private GuiReportReq grr;
    private Share[] shArray;
    public DevAccess[] daArray;
    public Disk[] dskArray;
    public DiskHistory[] dkhArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private int[] rendererArray;
    private boolean batch;
    public int frozenRows;
    private int rowCount;

    public DiskAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 2;
        switch (guiReportReq.reportSubtype) {
            case 39: {
                this.firstColumn = 12;
                break;
            }
            case 23: {
                this.firstColumn = 13;
                break;
            }
            case 24: {
                this.firstColumn = 14;
                break;
            }
            case 25: {
                this.firstColumn = 15;
                break;
            }
            case 26: {
                this.firstColumn = 16;
                break;
            }
            case 18: {
                this.firstColumn = 9;
                break;
            }
            case 37: {
                this.firstColumn = 10;
                break;
            }
            default: {
                this.firstColumn = 0;
            }
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[5] = 5;
        this.rendererArray[13] = 5;
        this.rendererArray[14] = 5;
        this.rendererArray[15] = 5;
        this.rendererArray[16] = 5;
        this.rendererArray[9] = 1;
        this.rendererArray[10] = 1;
        this.rendererArray[11] = 7;
        this.rendererArray[12] = 7;
        this.rendererArray[17] = 7;
        this.rendererArray[18] = 7;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.shArray = (Share[])objectArray;
        this.rowCount = this.shArray.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.daArray = new DevAccess[this.rowCount];
        this.dskArray = new Disk[this.rowCount];
        this.dkhArray = new DiskHistory[this.rowCount];
        this.mDate = new Date[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        int n = 0;
        while (n < this.rowCount) {
            this.mDate[n] = new Date();
            this.mLong[n] = new MutableLong();
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rowCount) {
            Share share = this.shArray[n];
            this.daArray[n] = (DevAccess)share.shResource;
            this.dskArray[n] = (Disk)this.daArray[n].daDevice;
            this.dkhArray[n] = this.dskArray[n].dskHistory;
            this.dskArray[n].dskCapacity *= 512L;
            this.dkhArray[n].dkhFreeSpace *= 512L;
            if (!this.batch && share.shResourceType == 10) {
                share.shComputerName = GuiUtil.getComputer((int)share.shComputerID).gcTSName;
            }
            ++n;
        }
    }

    public void undo() {
        this.dskArray[0].dskCapacity /= 512L;
        this.dkhArray[0].dkhFreeSpace /= 512L;
        Share share = this.shArray[0];
        if (share.shResourceType == 10) {
            share.shComputerName = null;
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        int[] nArray = new int[]{0, 1};
        int[] nArray2 = new int[]{5, 6};
        columnDescriptorArray[19].cdValidValue = nArray2;
        columnDescriptorArray[21].cdValidValue = nArray2;
        columnDescriptorArray[23].cdValidValue = nArray2;
        columnDescriptorArray[7].cdValidValue = nArray2;
        columnDescriptorArray[8].cdValidValue = nArray;
        columnDescriptorArray[6].cdValidValue = nArray2;
        columnDescriptorArray[4].cdValidValue = nArray;
        columnDescriptorArray[20].cdValidValue = ColumnDescriptor.DISK_STATES;
        columnDescriptorArray[22].cdValidValue = ColumnDescriptor.DISK_STATES;
        columnDescriptorArray[24].cdValidValue = ColumnDescriptor.DISK_STATES;
    }

    public Object getArray() {
        return this.shArray;
    }

    public int getNumberRows() {
        return this.shArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getCellData(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.shArray[n].shComputerName;
            }
            case 1: {
                return this.daArray[n].daPath;
            }
            case 2: {
                if ((this.dskArray[n].devFlags & 1) != 0 || this.dskArray[n].devManufacturer.compareTo(" ") == 0 || this.dskArray[n].devManufacturer.toLowerCase().equals("unknown")) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                return this.dskArray[n].devManufacturer;
            }
            case 3: {
                if (this.dskArray[n].devModel.compareTo(" ") == 0) {
                    return UNKNOWN;
                }
                return this.dskArray[n].devModel;
            }
            case 4: {
                return this.bHasTotalRow && n == 0 ? "" : (this.shArray[n].shResourceType == 10 ? NO : YES);
            }
            case 5: {
                this.mInt[n].value = this.dskArray[n].dskRPM;
                return this.mInt[n];
            }
            case 6: {
                return this.bHasTotalRow && n == 0 ? "" : (this.dskArray[n].dskReadCacheDisabled ? OFF : ON);
            }
            case 7: {
                return this.bHasTotalRow && n == 0 ? "" : (this.dskArray[n].dskWriteCacheEnabled ? ON : OFF);
            }
            case 8: {
                return this.bHasTotalRow && n == 0 ? "" : (this.dskArray[n].dskFailurePredicted ? YES : NO);
            }
            case 9: {
                this.mDate[n].setTime(this.dkhArray[n].dkhTimestamp);
                return this.mDate[n];
            }
            case 10: {
                this.mDate[n].setTime(this.dskArray[n].devDiscoveredTime);
                return this.mDate[n];
            }
            case 11: {
                this.mLong[n].value = this.dskArray[n].dskCapacity;
                return this.mLong[n];
            }
            case 12: {
                this.mLong[n].value = this.dkhArray[n].dkhFreeSpace;
                return this.mLong[n];
            }
            case 13: {
                this.mInt[n].value = this.dkhArray[n].dkhPrimaryDefects;
                return this.mInt[n];
            }
            case 14: {
                this.mInt[n].value = this.dkhArray[n].dkhGrownDefects;
                return this.mInt[n];
            }
            case 15: {
                int n3 = this.dkhArray[n].dkhRecoveredWriteErrors < 0 ? 0 : this.dkhArray[n].dkhRecoveredWriteErrors;
                int n4 = this.dkhArray[n].dkhRecoveredReadErrors < 0 ? 0 : this.dkhArray[n].dkhRecoveredReadErrors;
                int n5 = this.dkhArray[n].dkhRecoveredVerifyErrors < 0 ? 0 : this.dkhArray[n].dkhRecoveredVerifyErrors;
                this.mInt[n].value = n3 + n4 + n5;
                return this.mInt[n];
            }
            case 16: {
                int n6 = this.dkhArray[n].dkhUnrecoveredWriteErrors < 0 ? 0 : this.dkhArray[n].dkhUnrecoveredWriteErrors;
                int n7 = this.dkhArray[n].dkhUnrecoveredReadErrors < 0 ? 0 : this.dkhArray[n].dkhUnrecoveredReadErrors;
                int n8 = this.dkhArray[n].dkhUnrecoveredVerifyErrors < 0 ? 0 : this.dkhArray[n].dkhUnrecoveredVerifyErrors;
                this.mInt[n].value = n6 + n7 + n8;
                return this.mInt[n];
            }
            case 17: {
                this.mLong[n].value = this.dkhArray[n].dkhBytesWritten;
                return this.mLong[n];
            }
            case 18: {
                this.mLong[n].value = this.dkhArray[n].dkhBytesRead;
                return this.mLong[n];
            }
            case 19: {
                return this.bHasTotalRow && n == 0 ? "" : (this.dskArray[n].dskAutoWriteRealloc ? ON : OFF);
            }
            case 20: {
                return this.bHasTotalRow && n == 0 ? "" : Disk.STATES[this.dskArray[n].dskDesiredAWRE];
            }
            case 21: {
                return this.bHasTotalRow && n == 0 ? "" : (this.dskArray[n].dskAutoReadRealloc ? ON : OFF);
            }
            case 22: {
                return this.bHasTotalRow && n == 0 ? "" : Disk.STATES[this.dskArray[n].dskDesiredARRE];
            }
            case 23: {
                return this.bHasTotalRow && n == 0 ? "" : (this.dskArray[n].dskNoErrorRecovery ? ON : OFF);
            }
            case 24: {
                return this.bHasTotalRow && n == 0 ? "" : Disk.STATES[this.dskArray[n].dskDesiredNoErrRcvry];
            }
        }
        return null;
    }

    private void addTotal() {
        Share share;
        this.bHasTotalRow = true;
        Share[] shareArray = new Share[this.rowCount + 1];
        shareArray[0] = share = new Share();
        DevAccess devAccess = new DevAccess();
        Disk disk = new Disk();
        DiskHistory diskHistory = new DiskHistory();
        share.shResource = devAccess;
        devAccess.daDevice = disk;
        disk.dskHistory = diskHistory;
        share.shComputerName = MessageLog.getMessageNoID("STG4136L");
        devAccess.daPath = "";
        disk.devManufacturer = "";
        disk.devModel = "";
        diskHistory.dkhPrimaryDefects = -1;
        diskHistory.dkhGrownDefects = -1;
        diskHistory.dkhBytesWritten = -1L;
        diskHistory.dkhBytesRead = -1L;
        int n = 0;
        int n2 = 0;
        while (n2 < this.rowCount) {
            Share share2 = this.shArray[n2];
            Disk disk2 = (Disk)((DevAccess)share2.shResource).daDevice;
            DiskHistory diskHistory2 = disk2.dskHistory;
            if (disk2.dskRPM > 0) {
                disk.dskRPM += disk2.dskRPM;
                ++n;
            }
            if (disk2.dskCapacity > 0L) {
                disk.dskCapacity += disk2.dskCapacity;
            }
            if (diskHistory2.dkhFreeSpace > 0L) {
                diskHistory.dkhFreeSpace += diskHistory2.dkhFreeSpace;
            }
            if (diskHistory2.dkhPrimaryDefects > 0) {
                diskHistory.dkhPrimaryDefects += diskHistory2.dkhPrimaryDefects;
            }
            if (diskHistory2.dkhGrownDefects > 0) {
                diskHistory.dkhGrownDefects += diskHistory2.dkhGrownDefects;
            }
            if (diskHistory2.dkhRecoveredWriteErrors > 0) {
                diskHistory.dkhRecoveredWriteErrors += diskHistory2.dkhRecoveredWriteErrors;
            }
            if (diskHistory2.dkhRecoveredReadErrors > 0) {
                diskHistory.dkhRecoveredReadErrors += diskHistory2.dkhRecoveredReadErrors;
            }
            if (diskHistory2.dkhRecoveredVerifyErrors > 0) {
                diskHistory.dkhRecoveredVerifyErrors += diskHistory2.dkhRecoveredVerifyErrors;
            }
            if (diskHistory2.dkhUnrecoveredWriteErrors > 0) {
                diskHistory.dkhUnrecoveredWriteErrors += diskHistory2.dkhUnrecoveredWriteErrors;
            }
            if (diskHistory2.dkhUnrecoveredReadErrors > 0) {
                diskHistory.dkhUnrecoveredReadErrors += diskHistory2.dkhUnrecoveredReadErrors;
            }
            if (diskHistory2.dkhUnrecoveredVerifyErrors > 0) {
                diskHistory.dkhUnrecoveredVerifyErrors += diskHistory2.dkhUnrecoveredVerifyErrors;
            }
            if (diskHistory2.dkhBytesWritten > 0L) {
                diskHistory.dkhBytesWritten += diskHistory2.dkhBytesWritten;
            }
            if (diskHistory2.dkhBytesRead > 0L) {
                diskHistory.dkhBytesRead += diskHistory2.dkhBytesRead;
            }
            shareArray[n2 + 1] = this.shArray[n2];
            ++n2;
        }
        disk.dskRPM = n > 0 ? (disk.dskRPM /= n) : -1;
        if (diskHistory.dkhPrimaryDefects >= 0) {
            ++diskHistory.dkhPrimaryDefects;
        }
        if (diskHistory.dkhGrownDefects >= 0) {
            ++diskHistory.dkhGrownDefects;
        }
        if (diskHistory.dkhBytesWritten >= 0L) {
            ++diskHistory.dkhBytesWritten;
        }
        if (diskHistory.dkhBytesRead >= 0L) {
            ++diskHistory.dkhBytesRead;
        }
        this.shArray = shareArray;
        this.frozenRows = 1;
        ++this.rowCount;
    }
}

