/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.gui.ComputerDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputersTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    private Computer[] computers;
    private GuiReportReq grr;
    private ComputersAdjuster adjuster;

    public ComputersTable(GuiReportReq guiReportReq) {
        this.grr = guiReportReq;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new ComputersAdjuster(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        this.setLayout(new BorderLayout());
        this.computers = s <= 4 ? (Computer[])response.responseData : null;
        int n = this.computers != null ? this.computers.length : 0;
        if (n == 0) {
            JLabel jLabel = new JLabel(MessageLog.getMessageNoID("STG0020M"));
            jLabel.setHorizontalAlignment(0);
            this.add((Component)jLabel, "Center");
            return;
        }
        this.adjuster.adjust(this.computers, false);
        this.computers = (Computer[])this.adjuster.getArray();
        this.table.setMouseListener(new selectListener());
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        try {
            clazz4 = Class.forName("org.eclipse.aperi.common.MutableInteger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz4, TableCellRenderers.number);
        try {
            clazz3 = Class.forName("org.eclipse.aperi.common.MutableLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz3, TableCellRenderers.space);
        try {
            clazz2 = Class.forName("java.util.Date");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz2, TableCellRenderers.date);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.common.ComputersAdjuster$ComputerHertz");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz, TableCellRenderers.hertz);
        this.table.setRowIcon(10, true);
        this.table.setBaseTableModel(new ComputersTableModel());
        this.table.setAsFirstColumn(this.adjuster.getFirstColumn());
        if (this.adjuster.frozenRows > 0) {
            this.table.setFrozenRows(this.adjuster.frozenRows);
        }
        this.add((Component)this.table, "First");
    }

    private class ComputersTableModel
    extends BaseTableModel {
        ComputersTableModel() {
            this.rowCount = ComputersTable.this.computers.length;
            this.columnNames = ((ComputersTable)ComputersTable.this).adjuster.columnNameList;
            this.commonAdjuster = ComputersTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return ComputersTable.this.adjuster.getCellData(n, ComputersTable.this.adjuster.translateColumn(n2));
        }
    }

    public class selectListener
    extends TJCTableMouseAdapter {
        public boolean select(int n, int n2) {
            return !ComputersTable.this.adjuster.hasTotalsRow() || n != 0;
        }

        public void doubleClick(int n, int n2) {
            if (!ComputersTable.this.adjuster.hasTotalsRow() || n != 0) {
                new ComputerDDI(null, ((ComputersTable)ComputersTable.this).computers[n].gComputer.gcComputerID, ((ComputersTable)ComputersTable.this).computers[n].gComputer.gcTSName);
            }
        }
    }
}

