/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class FSSelector
implements TreeExpansionListener,
GuiRequestor,
TreeSelector.Reparenter {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList[] selections;
    private NameList rootName;
    private TreeSelectorNode sourceFSGroupLabel;
    private TreeSelectorNode sourceCompGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean expandedComputer;
    private TreeSet fsSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private boolean compsOnly;
    private String allObjectsLabel;
    public boolean allFSSelected;
    private boolean includeClusters;
    private boolean clusterExpanding;
    private boolean groupExpanding;
    private static final int ROOT_ID = -7;
    private static final int FS_GROUP_ID = -6;
    private static final int FS_ID = -5;
    private static final int COMP_GROUP_ID = -4;
    private static final int COMP_ID = -3;
    private static final int CLUSTER_ID = -2;
    private static final int ALL_FS_ID = Integer.MAX_VALUE;
    private static final int N_INDICES = 5;
    public static final int CLUSTER_INDEX = 4;

    public FSSelector() {
    }

    public FSSelector(NameList[] nameListArray, boolean bl, boolean bl2) {
        this(nameListArray, bl, bl2, false);
    }

    public FSSelector(NameList[] nameListArray, boolean bl, boolean bl2, boolean bl3) {
        this.selections = nameListArray;
        this.allFSSelected = bl;
        this.compsOnly = bl2;
        this.includeClusters = bl3;
        String string = this.compsOnly ? "STG3100L" : "STG4033L";
        this.allObjectsLabel = MessageLog.getMessageNoID(string);
    }

    public FSSelector(NameList[] nameListArray, boolean bl) {
        this(nameListArray, bl, false, false);
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree, this);
        return this.selector;
    }

    public NameList[] getData() {
        this.allFSSelected = false;
        NameList[] nameListArray = new NameList[5];
        NameList[] nameListArray2 = new NameList[5];
        int n = 0;
        NameList nameList = this.selector.getNameList();
        while (nameList != null) {
            n = nameList.nlInfo;
            if (n == 99) {
                n = 4;
            }
            if (n > 4) {
                if (n == 13) {
                    this.allFSSelected = true;
                }
                nameList = nameList.nlNext;
                continue;
            }
            NameList nameList2 = nameList;
            nameList = nameList2.nlNext;
            nameList2.nlNext = null;
            if (nameListArray2[n] == null) {
                nameListArray[n] = nameList2;
            } else {
                nameListArray2[n].nlNext = nameList2;
            }
            nameListArray2[n] = nameList2;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        if (!this.compsOnly) {
            this.sourceFSGroupLabel = this.addFSGroupLabel(treeSelectorNode);
            this.addFSLabel(treeSelectorNode);
        }
        this.sourceCompGroupLabel = this.addCompGroupLabel(treeSelectorNode);
        this.addCompLabel(treeSelectorNode);
        if (this.includeClusters) {
            this.addClusterLabel(treeSelectorNode);
        }
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        NameList nameList = null;
        NameList nameList2 = null;
        TreeSelectorNode treeSelectorNode4 = this.newRoot();
        NameList nameList3 = this.selections[2];
        while (nameList3 != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addFSGroupLabel(treeSelectorNode4);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList3, true, false, true, true, null));
            nameList3 = nameList3.nlNext;
        }
        this.fillSets(this.selections[3], true, false);
        if (this.allFSSelected && !this.compsOnly || !this.fsSet.isEmpty()) {
            treeSelectorNode2 = this.addFSLabel(treeSelectorNode4);
            if (this.allFSSelected) {
                this.addAllFSNode(treeSelectorNode2, true);
            }
            this.addTreeSet(treeSelectorNode2, this.fsSet);
        }
        treeSelectorNode = null;
        nameList3 = this.selections[0];
        while (nameList3 != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addCompGroupLabel(treeSelectorNode4);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList3, true, false, true, true, null));
            nameList3 = nameList3.nlNext;
        }
        treeSelectorNode = null;
        nameList3 = this.selections[1];
        while (nameList3 != null) {
            NameList nameList4 = nameList3.nlNext;
            nameList3.nlNext = null;
            if ((nameList3.nlState & 1) == 0) {
                if (treeSelectorNode == null) {
                    treeSelectorNode = this.addCompLabel(treeSelectorNode4);
                }
                treeSelectorNode.add(new TreeSelectorNode(nameList3, true, false, true, true, null));
            } else {
                if (nameList2 == null) {
                    nameList = nameList3;
                } else {
                    nameList2.nlNext = nameList3;
                }
                nameList2 = nameList3;
            }
            nameList3 = nameList4;
        }
        if (this.allFSSelected && this.compsOnly) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addCompLabel(treeSelectorNode4);
            }
            this.addAllFSNode(treeSelectorNode, true);
        }
        if (nameList != null || !this.excludeSet.isEmpty()) {
            treeSelectorNode3 = TreeSelector.makeExcludeRoot();
            treeSelectorNode4.add(treeSelectorNode3);
            if (!this.excludeSet.isEmpty()) {
                treeSelectorNode2 = this.addFSLabel(treeSelectorNode3);
                this.addTreeSet(treeSelectorNode2, this.excludeSet);
            }
            if (nameList != null) {
                treeSelectorNode = this.addCompLabel(treeSelectorNode3);
                while (nameList != null) {
                    treeSelectorNode.add(new TreeSelectorNode(nameList, false, true, false, false, null));
                    nameList = nameList.nlNext;
                }
            }
        }
        if (this.includeClusters) {
            treeSelectorNode = null;
            nameList3 = this.selections[4];
            while (nameList3 != null) {
                if (treeSelectorNode == null) {
                    treeSelectorNode = this.addClusterLabel(treeSelectorNode4);
                }
                treeSelectorNode.add(new TreeSelectorNode(nameList3, true, false, true, true, null));
                nameList3 = nameList3.nlNext;
            }
        }
        return treeSelectorNode4;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList[] nameListArray, boolean bl) {
        this.selections = nameListArray;
        this.allFSSelected = bl;
        this.fsSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
        defaultTreeModel.setRoot(treeSelectorNode);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, boolean bl, boolean bl2) {
        boolean bl3 = this.includeClusters;
        boolean bl4 = this.includeClusters;
        if (this.clusterExpanding) {
            bl3 = false;
        }
        int n = -1;
        int n2 = -1;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        while (nameList != null) {
            Cloneable cloneable;
            boolean bl5;
            boolean bl6;
            TreeSet treeSet;
            int n3;
            if ((nameList.nlState & 1) != 0) {
                n3 = n2;
                treeSet = this.excludeSet;
                bl6 = false;
                bl5 = true;
                defaultMutableTreeNode3 = defaultMutableTreeNode2;
            } else {
                n3 = n;
                treeSet = this.fsSet;
                bl6 = bl;
                bl5 = bl2;
                defaultMutableTreeNode3 = defaultMutableTreeNode;
            }
            if (nameList.nlID2 != n3) {
                cloneable = this.newNameList(GuiUtil.getComputer(nameList.nlID2), null, nameList.nlID2, 1, GuiUtil.getComputer((int)nameList.nlID2).gcOsType);
                defaultMutableTreeNode3 = new TreeSelectorNode((NameList)cloneable, false, false, true, false, null, bl3, bl4);
                ((TreeSelectorNode)defaultMutableTreeNode3).setButtonFlag(false);
                if (this.clusterExpanding || this.groupExpanding) {
                    ((TreeSelectorNode)defaultMutableTreeNode3).setButtonFlag(false);
                }
                treeSet.add(defaultMutableTreeNode3);
                if ((nameList.nlState & 1) != 0) {
                    n2 = nameList.nlID2;
                    defaultMutableTreeNode2 = defaultMutableTreeNode3;
                } else {
                    n = nameList.nlID2;
                    defaultMutableTreeNode = defaultMutableTreeNode3;
                }
            }
            cloneable = new TreeSelectorNode(nameList, bl6, bl5, false, false, null, bl3, bl4);
            defaultMutableTreeNode3.add((MutableTreeNode)((Object)cloneable));
            if (this.clusterExpanding || this.groupExpanding) {
                ((TreeSelectorNode)cloneable).setButtonFlag(false);
            }
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public static void invalidateGroups(TreeSelector treeSelector, JTree jTree, short s) {
        FSSelector.invalidateGroups(treeSelector, jTree, s, false);
    }

    public static void invalidateGroups(TreeSelector treeSelector, JTree jTree, short s, boolean bl) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = treeSelectorNode.breadthFirstEnumeration();
        boolean bl2 = true;
        while (bl2 && enumeration.hasMoreElements()) {
            treeSelectorNode = (TreeSelectorNode)enumeration.nextElement();
            int n = treeSelectorNode.getLevel();
            if (n != 2) {
                if (n <= 2) continue;
                bl2 = false;
                continue;
            }
            NameList nameList = treeSelectorNode.getNameList();
            if (nameList.nlInfo != s) continue;
            treeSelector.nodeUnselected(treeSelectorNode);
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treeSelectorNode.getParent();
            int n2 = mutableTreeNode.getIndex(treeSelectorNode);
            defaultTreeModel.removeNodeFromParent(treeSelectorNode);
            treeSelectorNode = new TreeSelectorNode(nameList, true, false, true, true, null, bl, bl);
            defaultTreeModel.insertNodeInto(treeSelectorNode, mutableTreeNode, n2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    private void addGroup(TreeSelectorNode treeSelectorNode, NameList nameList) {
        if (!treeSelectorNode.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList2, true, false, true, true, null, this.includeClusters, this.includeClusters);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, treeSelectorNode, treeSelectorNode2);
    }

    public void addFSGroup(NameList nameList) {
        this.addGroup(this.sourceFSGroupLabel, nameList);
    }

    public void addComputerGroup(NameList nameList) {
        this.addGroup(this.sourceCompGroupLabel, nameList);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Request request;
        Serializable serializable;
        this.clusterExpanding = false;
        this.groupExpanding = false;
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        this.expandedComputer = false;
        if (this.expansionTree == this.sourceTree) {
            switch (nameList.nlID) {
                case -6: {
                    n = 2;
                    break;
                }
                case -4: {
                    n = 0;
                    break;
                }
                case -5: {
                    n = 3;
                    break;
                }
                case -3: {
                    n = 1;
                    break;
                }
                case -2: {
                    n = 99;
                }
            }
        } else if (nameList.nlInfo == 2 || nameList.nlInfo == 0) {
            n = nameList.nlInfo + 1;
            n2 = nameList.nlID;
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 99) {
            n = -1;
            this.clusterExpanding = true;
            serializable = new GroupDefinition();
            ((GroupDefinition)serializable).groupType = (short)99;
            ((GroupDefinition)serializable).ID = nameList.nlID;
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", serializable);
            request.flags = (byte)5;
            GuiClient.doRequest(this, request);
        } else if (nameList.nlInfo == 1 && this.expansionNode.selectable) {
            n = 3;
            n3 = nameList.nlID;
            this.expandedComputer = true;
        } else if (nameList.nlInfo == 13) {
            n = this.compsOnly ? 1 : 3;
        }
        if (n >= 0) {
            serializable = new GuiListReq();
            serializable.listRequested = 10000 + n;
            serializable.groupID = n2;
            serializable.computerID = n3;
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", serializable);
            request.flags = (byte)5;
            GuiClient.doRequest(this, request);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        Serializable serializable = response.responseData;
        NameList nameList = null;
        TreeSelectorNode treeSelectorNode = null;
        boolean bl = this.includeClusters;
        boolean bl2 = this.includeClusters;
        if (serializable instanceof GroupDefinition) {
            GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
            nameList = groupDefinition.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == 2 || nameList.nlInfo == 0 || nameList.nlInfo == 99) {
            if (nameList.nlInfo == 99) {
                bl = false;
            }
            while (nameList != null) {
                treeSelectorNode = new TreeSelectorNode(nameList, true, false, false, true, null, bl, bl2);
                this.expansionNode.add(treeSelectorNode);
                nameList = nameList.nlNext;
            }
        } else {
            boolean bl3;
            boolean bl4 = this.expansionTree == this.sourceTree;
            boolean bl5 = bl3 = !bl4;
            if (nameList.nlInfo == 3) {
                if (bl4 && !this.compsOnly) {
                    this.addAllFSNode(this.expansionNode, false);
                }
                if (this.expandedComputer) {
                    while (nameList != null) {
                        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, bl4, bl3, false, false, null);
                        this.expansionNode.add(treeSelectorNode2);
                        nameList = nameList.nlNext;
                    }
                } else {
                    this.fsSet.clear();
                    this.fillSets(nameList, bl4, bl3);
                    this.addTreeSet(this.expansionNode, this.fsSet);
                }
            } else {
                boolean bl6;
                boolean bl7 = bl6 = bl4 && nameList.nlInfo == 1;
                if (bl6 && this.compsOnly) {
                    this.addAllFSNode(this.expansionNode, false);
                }
                if (this.clusterExpanding) {
                    bl = false;
                }
                while (nameList != null) {
                    TreeSelectorNode treeSelectorNode3 = new TreeSelectorNode(nameList, bl4, bl3, false, bl6, null, bl, bl2);
                    if (this.clusterExpanding || this.groupExpanding) {
                        treeSelectorNode3.setButtonFlag(false);
                    }
                    this.expansionNode.add(treeSelectorNode3);
                    nameList = nameList.nlNext;
                }
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -7, -1, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true, false, null);
    }

    private TreeSelectorNode addFSGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode("STG4032L", -6, treeSelectorNode);
    }

    private TreeSelectorNode makeFSLabel() {
        return this.makeLabelNode("STG1006L", -5);
    }

    private TreeSelectorNode addFSLabel(TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2 = this.makeFSLabel();
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private TreeSelectorNode addCompGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode("STG3012L", -4, treeSelectorNode);
    }

    private TreeSelectorNode makeCompLabel() {
        return this.makeLabelNode("STG4041L", -3);
    }

    private TreeSelectorNode addCompLabel(TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2 = this.makeCompLabel();
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private TreeSelectorNode addClusterLabel(TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2 = this.makeLabelNode("LABEL_CLUSTERS", -2);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private TreeSelectorNode makeLabelNode(String string, int n) {
        String string2 = Util.getString(string);
        NameList nameList = this.newNameList(string2, n, -1, GuiUtil.getComputer((int)n).gcOsType);
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode.setButtonFlag(false);
        treeSelectorNode.setSortKey(n);
        return treeSelectorNode;
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2 = this.makeLabelNode(string, n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllFSNode(TreeSelectorNode treeSelectorNode, boolean bl) {
        NameList nameList = this.newNameList(this.allObjectsLabel, Integer.MAX_VALUE, 13, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.insert(treeSelectorNode2, 0);
    }

    private NameList newNameList(String string, int n, int n2, int n3) {
        return this.newNameList(null, string, n, n2, n3);
    }

    private NameList newNameList(GComputer gComputer, String string, int n, int n2, int n3) {
        NameList nameList = new NameList();
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        nameList.nlID2 = (short)n3;
        if (gComputer != null) {
            nameList.nlName = gComputer.gcTSName;
            nameList.nlClusterDomain = gComputer.gcDomainName;
            nameList.nlClusterID = gComputer.gcClusterID;
            nameList.nlClusterName = gComputer.gcClusterName;
            nameList.nlHostName = gComputer.gcHostedNodeName;
        } else {
            nameList.nlName = string;
        }
        return nameList;
    }

    public TreeSelectorNode reparent(TreeSelectorNode treeSelectorNode, NameList nameList, MutableInteger mutableInteger) {
        int n;
        if (nameList.nlInfo == 1) {
            n = -3;
        } else {
            n = -5;
            mutableInteger.value = 2;
        }
        TreeSelectorNode treeSelectorNode2 = null;
        Enumeration<TreeNode> enumeration = treeSelectorNode.children();
        boolean bl = true;
        int n2 = 0;
        while (bl && enumeration.hasMoreElements()) {
            treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
            if (treeSelectorNode2.hiOrderSortKey == n) {
                bl = false;
                continue;
            }
            ++n2;
        }
        if (bl) {
            if (n == -3) {
                treeSelectorNode2 = this.makeCompLabel();
            } else {
                treeSelectorNode2 = this.makeFSLabel();
                n2 = 0;
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
            defaultTreeModel.insertNodeInto(treeSelectorNode2, treeSelectorNode, n2);
        }
        return treeSelectorNode2;
    }
}

