/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class FabricGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private static boolean test = false;
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList fabricSelections;
    private NameList zoneSelections;
    private NameList zoneSetsSelections;
    public boolean allFabricsSelected;
    public boolean allZonesSelected;
    public boolean allZoneSetsSelected;
    private NameList rootName;
    private TreeSet fabricIncludeSet = new TreeSet();
    private TreeSet fabricExcludeSet = new TreeSet();
    private TreeSet zoneIncludeSet = new TreeSet();
    private TreeSet zoneExcludeSet = new TreeSet();
    private TreeSet zoneSetIncludeSet = new TreeSet();
    private TreeSet zoneSetExcludeSet = new TreeSet();
    private JTree expansionTree;
    private TreeSelectorNode sourceFabricZoneLabel;
    private TreeSelectorNode sourceFabricZoneSetLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean zoneExpanding;
    private boolean zonesetExpanding;
    private static final int ROOT_ID = -5;
    private static final int FABRIC_ID = -4;
    private static final int ZONE_ID = -3;
    private static final int ZONESET_ID = -2;
    private static final int ALL_FABRIC_ID = Integer.MAX_VALUE;
    private static final int ALL_ZONE_ID = 0x7FFFFFFE;
    private static final int ALL_ZONESET_ID = 0x7FFFFFFD;
    public static final int FABRIC_IX = 0;
    public static final int ZONE_IX = 1;
    public static final int ZONESET_IX = 2;
    private static final String FABRIC_LABEL = Util.getString("FabricAlert_FabricTabTitle");
    private static final String ZONE_LABEL = Util.getString("FabricAlert_FabricZoneLabel");
    private static final String ZONESET_LABEL = Util.getString("FabricAlert_FabricZoneSetLabel");
    private static final String ALL_FABRIC_LABEL = Util.getString("FabricAlert_AllFabricLabel");
    private static final String ALL_ZONE_LABEL = Util.getString("FabricAlert_AllZoneLabel");
    private static final String ALL_ZONESET_LABEL = Util.getString("FabricAlert_AllZoneSetLabel");

    public FabricGroupSelector(NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3) {
        this.fabricSelections = nameList;
        this.zoneSelections = nameList2;
        this.zoneSetsSelections = nameList3;
        this.allFabricsSelected = bl;
        this.allZonesSelected = bl2;
        this.allZoneSetsSelected = bl3;
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList[] nameListArray = new NameList[5];
        NameList[] nameListArray2 = new NameList[5];
        NameList nameList = null;
        this.allFabricsSelected = false;
        this.allZonesSelected = false;
        this.allZoneSetsSelected = false;
        NameList nameList2 = this.selector.getNameList();
        while (nameList2 != null) {
            int n = -999;
            if (nameList2.nlInfo == 114) {
                n = 0;
            } else if (nameList2.nlInfo == 127) {
                n = 1;
            } else if (nameList2.nlInfo == 126) {
                n = 2;
            } else if (nameList2.nlInfo == 130) {
                this.allFabricsSelected = true;
            } else if (nameList2.nlInfo == 131) {
                this.allZonesSelected = true;
            } else if (nameList2.nlInfo == 132) {
                this.allZoneSetsSelected = true;
            }
            if (n < 0) {
                nameList2 = nameList2.nlNext;
                continue;
            }
            nameList = nameList2;
            nameList2 = nameList.nlNext;
            nameList.nlNext = null;
            if (nameListArray2[n] == null) {
                nameListArray[n] = nameList;
            } else {
                nameListArray2[n].nlNext = nameList;
            }
            nameListArray2[n] = nameList;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        this.addLabelNode(FABRIC_LABEL, -4, treeSelectorNode);
        this.sourceFabricZoneLabel = this.addLabelNode(ZONE_LABEL, -3, treeSelectorNode);
        this.sourceFabricZoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, treeSelectorNode);
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = null;
        TreeSelectorNode treeSelectorNode5 = this.newRoot();
        this.fillSets(this.fabricSelections, this.fabricIncludeSet, this.fabricExcludeSet, true, false);
        if (this.allFabricsSelected || !this.fabricIncludeSet.isEmpty()) {
            treeSelectorNode = this.addLabelNode(FABRIC_LABEL, -4, treeSelectorNode5);
            if (this.allFabricsSelected) {
                this.addAllMembersNode(ALL_FABRIC_LABEL, Integer.MAX_VALUE, 130, treeSelectorNode, true);
            }
            this.addTreeSet(treeSelectorNode, this.fabricIncludeSet);
        }
        if (!this.fabricExcludeSet.isEmpty()) {
            treeSelectorNode2 = TreeSelector.makeExcludeRoot();
            treeSelectorNode5.add(treeSelectorNode2);
            this.addTreeSet(treeSelectorNode2, this.fabricExcludeSet);
        }
        this.fillSets(this.zoneSelections, this.zoneIncludeSet, this.zoneExcludeSet, true, false);
        if (!this.zoneIncludeSet.isEmpty() || this.allZonesSelected) {
            treeSelectorNode3 = this.addLabelNode(ZONE_LABEL, -3, treeSelectorNode5);
        }
        if (this.allZonesSelected) {
            this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 131, treeSelectorNode3, true);
        }
        this.addTreeSet(treeSelectorNode3, this.zoneIncludeSet);
        this.fillSets(this.zoneSetsSelections, this.zoneSetIncludeSet, this.zoneSetExcludeSet, true, false);
        if (!this.zoneSetIncludeSet.isEmpty() || this.allZoneSetsSelected) {
            treeSelectorNode4 = this.addLabelNode(ZONESET_LABEL, -2, treeSelectorNode5);
        }
        if (this.allZoneSetsSelected) {
            this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFD, 132, treeSelectorNode4, true);
        }
        this.addTreeSet(treeSelectorNode4, this.zoneSetIncludeSet);
        return treeSelectorNode5;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList nameList, NameList nameList2, NameList nameList3, boolean bl, boolean bl2, boolean bl3) {
        this.fabricSelections = nameList;
        this.zoneSelections = nameList2;
        this.zoneSetsSelections = nameList3;
        this.allFabricsSelected = bl;
        this.allZonesSelected = bl2;
        this.allZoneSetsSelected = bl3;
        this.fabricIncludeSet.clear();
        this.fabricExcludeSet.clear();
        this.zoneIncludeSet.clear();
        this.zoneExcludeSet.clear();
        this.zoneSetIncludeSet.clear();
        this.zoneSetExcludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeSelectorNode, true);
        this.selectedTree.setModel(defaultTreeModel);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, TreeSet treeSet, TreeSet treeSet2, boolean bl, boolean bl2) {
        boolean bl3 = true;
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl4;
            boolean bl5;
            TreeSet treeSet3;
            if (Constants.isVirtualServer(nameList.nlID2)) {
                nameList = nameList.nlNext;
                continue;
            }
            if ((nameList.nlState & 1) != 0) {
                treeSet3 = treeSet2;
                bl5 = false;
                bl4 = true;
            } else {
                treeSet3 = treeSet;
                bl5 = bl;
                bl4 = bl2;
            }
            if (this.zoneExpanding) {
                bl3 = false;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl5, bl4, false, false, null, bl3, true);
            if (this.zoneExpanding || this.zonesetExpanding) {
                treeSelectorNode.setButtonFlag(false);
            }
            treeSet3.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    public void addGroup(NameList nameList) {
        TreeSelectorNode treeSelectorNode;
        if (nameList.nlID == -3) {
            treeSelectorNode = this.sourceFabricZoneLabel;
        } else if (nameList.nlID == -2) {
            treeSelectorNode = this.sourceFabricZoneSetLabel;
        } else {
            return;
        }
        if (!treeSelectorNode.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList2, true, false, true, true, null);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, treeSelectorNode, treeSelectorNode2);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.zoneExpanding = false;
        this.zonesetExpanding = false;
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (nameList.nlID == -3) {
                this.sendRequest((short)127, -1);
            } else if (nameList.nlID == -4) {
                this.sendRequest((short)114, -1);
            } else if (nameList.nlID == -2) {
                this.sendRequest((short)126, -1);
            }
        } else if (nameList.nlInfo == 114) {
            this.sendRequest((short)114, nameList.nlID);
        } else if (nameList.nlInfo == 127) {
            this.zoneExpanding = true;
            this.sendRequest(nameList.nlInfo, nameList.nlID);
        } else if (nameList.nlInfo == 126) {
            this.sendRequest(nameList.nlInfo, nameList.nlID);
            this.zonesetExpanding = true;
        } else if (nameList.nlInfo == 130) {
            this.sendRequest((short)114, -1);
        } else if (nameList.nlInfo == 131) {
            this.sendRequest((short)127, -1);
        } else if (nameList.nlInfo == 132) {
            this.sendRequest((short)126, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    protected GuiListReq makeListRequestData(short s, int n) {
        GuiListReq guiListReq = new GuiListReq();
        if (s == 99) {
            guiListReq.listRequested = 11;
        } else {
            if (s == 101) {
                s = (short)99;
            }
            guiListReq.listRequested = 10000 + s;
            guiListReq.groupID = n;
        }
        return guiListReq;
    }

    protected GroupDefinition makeGroupRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendRequest(short s, int n) {
        Request request;
        if (s == 99) {
            GroupDefinition groupDefinition = this.makeGroupRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        } else {
            GuiListReq guiListReq = this.makeListRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        }
        GuiClient.doRequest(this, request);
    }

    private NameList makeFakeData() {
        NameList nameList = null;
        NameList nameList2 = this.expansionNode.getNameList();
        if (nameList2.nlID == -4) {
            NameList nameList3 = new NameList();
            nameList3.nlName = "fabric1";
            nameList3.nlInfo = (short)114;
            nameList3.nlNext = nameList;
            nameList = nameList3;
            nameList3 = new NameList();
            nameList3.nlName = "fabric2";
            nameList3.nlInfo = (short)114;
            nameList3.nlNext = nameList;
            nameList = nameList3;
        } else if (nameList2.nlID == -3) {
            NameList nameList4 = new NameList();
            nameList4.nlName = "zone1";
            nameList4.nlInfo = (short)127;
            nameList4.nlNext = nameList;
            nameList = nameList4;
            nameList4 = new NameList();
            nameList4.nlName = "zone2";
            nameList4.nlInfo = (short)127;
            nameList4.nlNext = nameList;
            nameList = nameList4;
        } else if (nameList2.nlID == -2) {
            NameList nameList5 = new NameList();
            nameList5.nlName = "ZoneSet1";
            nameList5.nlInfo = (short)126;
            nameList5.nlNext = nameList;
            nameList = nameList5;
            nameList5 = new NameList();
            nameList5.nlName = "ZoneSet2";
            nameList5.nlInfo = (short)126;
            nameList5.nlNext = nameList;
            nameList = nameList5;
        }
        return nameList;
    }

    public void handleResponse(short s, Response response) {
        Serializable serializable;
        NameList nameList = null;
        if (test) {
            nameList = this.makeFakeData();
        } else {
            if (s > 4) {
                return;
            }
            serializable = response.responseData;
            if (serializable instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
                nameList = groupDefinition.members;
            } else {
                nameList = (NameList)response.responseData;
            }
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList == null) {
            serializable = this.expansionNode.getNameList();
            if (this.expansionTree == this.sourceTree) {
                if (((NameList)serializable).nlID == -3) {
                    this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 131, this.expansionNode, false);
                } else if (((NameList)serializable).nlID == -4) {
                    this.addAllMembersNode(ALL_FABRIC_LABEL, Integer.MAX_VALUE, 130, this.expansionNode, false);
                } else if (((NameList)serializable).nlID == -2) {
                    this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFD, 132, this.expansionNode, false);
                }
            }
        } else {
            boolean bl;
            boolean bl2 = this.expansionTree == this.sourceTree;
            boolean bl3 = bl = !bl2;
            if (nameList.nlInfo == 114) {
                if (bl2) {
                    this.addAllMembersNode(ALL_FABRIC_LABEL, Integer.MAX_VALUE, 130, this.expansionNode, false);
                }
                this.fabricIncludeSet.clear();
                this.fillSets(nameList, this.fabricIncludeSet, this.fabricExcludeSet, bl2, bl);
                this.addTreeSet(this.expansionNode, this.fabricIncludeSet);
            } else if (nameList.nlInfo == 127) {
                if (bl2) {
                    this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 131, this.expansionNode, false);
                }
                this.zoneIncludeSet.clear();
                this.fillSets(nameList, this.zoneIncludeSet, this.zoneExcludeSet, bl2, bl);
                this.addTreeSet(this.expansionNode, this.zoneIncludeSet);
            } else if (nameList.nlInfo == 126) {
                if (bl2) {
                    this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFD, 132, this.expansionNode, false);
                }
                this.zoneSetIncludeSet.clear();
                this.fillSets(nameList, this.zoneSetIncludeSet, this.zoneSetExcludeSet, bl2, bl);
                this.addTreeSet(this.expansionNode, this.zoneSetIncludeSet);
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        NameList nameList = this.newNameList(string, n, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode2.setButtonFlag(false);
        treeSelectorNode2.setSortKey(n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllMembersNode(String string, int n, int n2, TreeSelectorNode treeSelectorNode, boolean bl) {
        NameList nameList = this.newNameList(string, n, n2);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }
}

