/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class DateFreeForm
extends FreeForm {
    private static void twoDigits(int n, StringBuffer stringBuffer) {
        stringBuffer.append((char)(48 + n / 10));
        stringBuffer.append((char)(48 + n % 10));
    }

    private static String formatDuration(ColumnFilterValue columnFilterValue, short s) {
        String string;
        Object object = columnFilterValue.fvValue;
        if (!(object instanceof MutableLong)) {
            string = "***ERROR***";
        } else {
            MutableLong mutableLong = (MutableLong)object;
            int n = (int)mutableLong.value;
            if (s == 6) {
                n = (int)(mutableLong.value / 1000L);
            }
            long l = n / 86400;
            n = (int)((long)n - l * 86400L);
            StringBuffer stringBuffer = new StringBuffer(8);
            int n2 = n / 3600;
            DateFreeForm.twoDigits(n2, stringBuffer);
            stringBuffer.append(':');
            n -= n2 * 3600;
            n2 = n / 60;
            DateFreeForm.twoDigits(n2, stringBuffer);
            stringBuffer.append(':');
            DateFreeForm.twoDigits(n -= n2 * 60, stringBuffer);
            String string2 = s == 4 ? "STG3269T" : "STG3268T";
            Object[] objectArray = new Object[]{new Long(l), stringBuffer.toString()};
            string = MessageLog.getMessageNoID(string2, objectArray);
        }
        return string;
    }

    private static String formatDate(ColumnFilterValue columnFilterValue) {
        Object object = columnFilterValue.fvValue;
        String string = object instanceof Date ? Util.formatDateTime((Date)object) : "***ERROR***";
        return string;
    }

    public DateFreeForm(ColumnFilter columnFilter) {
        super(columnFilter);
        this.textField.setEditable(false);
    }

    public void getData() throws GeneralException {
        if (this.filter.clfValueList == null) {
            String string = MessageLog.getMessageNoTS("STG3265E");
            throw new GeneralException(string);
        }
    }

    public void refresh() {
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        if (columnFilterValue == null) {
            return;
        }
        short s = this.filter.clfDataType;
        String string = s == 3 ? DateFreeForm.formatDate(columnFilterValue) : DateFreeForm.formatDuration(columnFilterValue, s);
        this.textField.setText(string);
    }
}

