/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.IControlEngine;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class TokenHeartbeat
extends Thread {
    private static ILogger msgLogger = ControlConstants.msgLogger;
    private static ILogger traceLogger = ControlConstants.traceLogger;
    private final String className;
    IControlEngine ce;
    Token token;
    long timestampUpdateInterval;
    boolean bAllDone;

    public TokenHeartbeat(IControlEngine iControlEngine, Token token, long l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.TokenHeartbeat");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.className = clazz.getName();
        this.ce = null;
        this.token = null;
        this.timestampUpdateInterval = 0L;
        this.bAllDone = false;
        String string = "TokenHearbeat";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, string);
        }
        this.ce = iControlEngine;
        this.token = token;
        this.timestampUpdateInterval = l;
        this.setName("tokenHeartbeat Token=" + this.token.getTokenId() + " Client=" + this.token.getClient());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = "run";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, string);
        }
        while (!this.bAllDone) {
            TokenHeartbeat tokenHeartbeat = this;
            synchronized (tokenHeartbeat) {
                try {
                    this.wait(this.timestampUpdateInterval);
                }
                catch (Exception exception) {}
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, this.className, string, "Updating token heartbeat for SAN " + this.token.getResource() + " client " + this.token.getClient());
                }
                if (this.ce.updateTokenTimestamp(this.token) != 1 && traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, this.className, string, "Unable to update Token for SAN " + this.token.getResource() + " client " + this.token.getClient());
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        String string = "shutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, string);
        }
        this.bAllDone = true;
        TokenHeartbeat tokenHeartbeat = this;
        synchronized (tokenHeartbeat) {
            this.notifyAll();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, string);
        }
    }

    public boolean isDone() {
        String string = "isDone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, this.className, string);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.className, string);
        }
        return this.bAllDone;
    }
}

