/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.interfaces;

import java.io.Serializable;
import java.util.Observable;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.util.queue.QueueController;

public class JobInfo
extends Observable
implements Serializable {
    private static final long serialVersionUID = 4730465366538569857L;
    public static final int NOT_RUNNING = 0;
    public static final int RUNNING = 1;
    public static final int FINISHED = 2;
    public static final int CANCELED = 3;
    public static final int REPLACED = 4;
    public static final int ERROR = 99;
    public static final int INVALID_HOST = 100;
    public static final int INVALID_SCANNER = 101;
    public static final int INVALID_PROCESSOR = 103;
    public static final String[] stateStrings = new String[]{"Not Running", "Running", "Finished", "Canceled", "Replaced"};
    public static final int PROCESS_RESPONSE = 1;
    public static final int CLEAR_HISTORY = 2;
    private Response response = null;
    private Response request = null;
    String discoverRequest = null;
    private String resourceQueue;
    private String[] target = null;
    private String resourceId = null;
    private String requestId = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean successful = true;
    private JobInfo previousJob = null;
    private JobInfo nextJob = null;
    private JobInfo replacementJob = null;
    private static int jobNumber = 0;
    private int id = JobInfo.getNextId();
    private int status = 0;
    private int rc = -1;

    private static int getNextId() {
        return ++jobNumber;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        if (this.status == 2 && this.successful && this.nextJob != null) {
            return this.nextJob.getStatus();
        }
        return this.status;
    }

    public void replaceWith(JobInfo jobInfo) {
        this.replacementJob = jobInfo;
        this.status = 4;
    }

    public JobInfo getReplacementJob() {
        return this.replacementJob;
    }

    public Object clone() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.discoverRequest = this.discoverRequest;
        jobInfo.resourceQueue = this.resourceQueue;
        jobInfo.target = this.target;
        jobInfo.resourceId = this.resourceId;
        jobInfo.requestId = this.requestId;
        jobInfo.successful = this.successful;
        jobInfo.previousJob = this.previousJob;
        jobInfo.status = 0;
        jobInfo.nextJob = null;
        return jobInfo;
    }

    public String getId() {
        return new Integer(this.id).toString();
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResourceQueue(String string) {
        this.resourceQueue = string;
    }

    public String getResourceQueue() {
        return this.resourceQueue;
    }

    public void setTarget(String[] stringArray) {
        this.target = stringArray;
    }

    public String[] getTarget() {
        return this.target;
    }

    public void setStartTime(long l) {
        this.startTime = l;
        this.status = 1;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String string) {
        this.resourceId = string;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean bl) {
        this.successful = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void complete(boolean bl) {
        try {
            this.setEndTime(System.currentTimeMillis());
            this.successful = bl;
            this.status = 2;
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            QueueController.getInstance().jobComplete(this);
            throw throwable;
        }
        {
            Object var2_4 = null;
            QueueController.getInstance().jobComplete(this);
            return;
        }
    }

    public void queryComplete(boolean bl) {
        this.setEndTime(System.currentTimeMillis());
        this.successful = bl;
        this.status = 2;
        this.setChanged();
        this.notifyObservers(this);
    }

    public void readComplete() {
        QueueController.getInstance().jobComplete(this);
    }

    public String getDiscoverRequest() {
        return this.discoverRequest;
    }

    public void setDiscoverRequest(String string) {
        this.discoverRequest = string;
    }

    public JobInfo getPreviousJob() {
        return this.previousJob;
    }

    public void setPreviousJob(JobInfo jobInfo) {
        this.previousJob = jobInfo;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String string) {
        this.requestId = string;
    }

    public Response getRequest() {
        if (this.request != null) {
            return this.request;
        }
        if (this.previousJob != null) {
            return this.previousJob.getResponse();
        }
        return null;
    }

    public void setRequest(Response response) {
        this.request = response;
    }

    public String toString() {
        return "JobInfo\n   ID:" + this.getId() + "\n   DiscoverRequest:" + this.getDiscoverRequest() + "\n   Queue:" + this.getResourceQueue() + "\n   Resource:" + this.getResourceId() + "\n   Request:" + this.getRequestId() + "\n   Started at:" + this.getStartTime() + "\n   Duration:" + (this.getEndTime() - this.getStartTime()) + "\n   Successful:" + this.isSuccessful() + "\n    Return Code:" + this.rc + "\n    Status:" + stateStrings[this.status] + (this.status == 4 ? " by " + this.replacementJob.id : "");
    }

    public JobInfo getNextJob() {
        return this.nextJob;
    }

    public void setNextJob(JobInfo jobInfo) {
        this.nextJob = jobInfo;
        jobInfo.setPreviousJob(this);
    }

    public void setReturnCode(int n) {
        this.rc = n;
    }

    public int getReturnCode() {
        return this.rc;
    }
}

