/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;

public class DiskReportingHelper {
    public static Hashtable createWhereClauseMap(Class clazz, Map map, LogTraceHelper logTraceHelper) throws ServerException {
        Hashtable hashtable = null;
        if (map != null) {
            hashtable = new Hashtable(map.size() + 1, 1.0f);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashtable.put(DiskReportingHelper.getColumnInfo(clazz, string, logTraceHelper), map.get(string));
            }
        } else {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public static ColumnInfo getColumnInfo(Class clazz, String string, LogTraceHelper logTraceHelper) throws ServerException {
        try {
            Class<?> clazz2;
            Class[] classArray = new Class[1];
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("getColumnInfo", classArray);
            return (ColumnInfo)method.invoke(null, string);
        }
        catch (SecurityException securityException) {
            throw DiskMessageHelper.getServerException("HWN021503E", securityException.getMessage(), logTraceHelper);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DiskMessageHelper.getServerException("HWN021503E", illegalArgumentException.getMessage(), logTraceHelper);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw DiskMessageHelper.getServerException("HWN021503E", noSuchMethodException.getMessage(), logTraceHelper);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DiskMessageHelper.getServerException("HWN021503E", illegalAccessException.getMessage(), logTraceHelper);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DiskMessageHelper.getServerException("HWN021503E", invocationTargetException.getMessage(), logTraceHelper);
        }
    }

    public static HashMap getAttributes(Object object, String[] stringArray, LogTraceHelper logTraceHelper) throws ServerException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(stringArray.length + 2);
        try {
            Method[] methodArray = object.getClass().getMethods();
            int n = 0;
            while (n < stringArray.length) {
                Method method = DiskReportingHelper.findMethod(methodArray, stringArray[n]);
                if (method == null) {
                    throw DiskMessageHelper.getInvalidParameterException(2, "HWN021520E", stringArray[n], logTraceHelper);
                }
                method.invoke(object, new Object[0]);
                hashMap.put(stringArray[n], method.invoke(object, new Object[0]));
                ++n;
            }
            return hashMap;
        }
        catch (SecurityException securityException) {
            throw DiskMessageHelper.getServerException("HWN021503E", securityException.getMessage(), logTraceHelper);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DiskMessageHelper.getServerException("HWN021503E", illegalArgumentException.getMessage(), logTraceHelper);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DiskMessageHelper.getServerException("HWN021503E", illegalAccessException.getMessage(), logTraceHelper);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DiskMessageHelper.getServerException("HWN021503E", invocationTargetException.getMessage(), logTraceHelper);
        }
    }

    private static Method findMethod(Method[] methodArray, String string) {
        String string2 = string.replaceAll("_", "");
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equalsIgnoreCase("get" + string2)) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }
}

