/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class ConfigurationParameter {
    protected StorageSubsystem[] cStorageSubsystemsForSorting;
    protected StorageSubsystem cStorageSubsystem;
    protected CIMObjectPath cStorageSubsystemCIMOP;
    protected String cStorageSubsystemID;
    protected CapabilityData cCapability;
    protected CIMOM cCimom;
    protected CIMClientWrapper cCIMClientWrapper;
    protected CIMObjectPath[] cVolumeCOPs = new CIMObjectPath[0];
    protected StorageVolume[] cVolumes = new StorageVolume[0];
    protected String[] cVolumeIDs = new String[0];
    protected String[] cVolumeNames = new String[0];
    protected AsyncResult cAsyncResult;
    protected String cAPIMethodName = "";
    protected Token cToken;

    public String getStorageSubsystemID() {
        return this.cStorageSubsystemID;
    }

    public void setStorageSubsystemID(String string) {
        this.cStorageSubsystemID = string;
    }

    public ConfigurationParameter() {
    }

    public ConfigurationParameter(StorageSubsystem storageSubsystem, CIMObjectPath cIMObjectPath) {
        this.cStorageSubsystem = storageSubsystem;
        this.cStorageSubsystemCIMOP = cIMObjectPath;
    }

    public ConfigurationParameter(StorageSubsystem storageSubsystem) {
        this.cStorageSubsystem = storageSubsystem;
    }

    public CapabilityData getCapability() {
        return this.cCapability;
    }

    public StorageSubsystem getStorageSubsystem() {
        return this.cStorageSubsystem;
    }

    public CIMObjectPath getStorageSubsystemCIMOP() {
        return this.cStorageSubsystemCIMOP;
    }

    public void setCapability(CapabilityData capabilityData) {
        this.cCapability = capabilityData;
    }

    public void setStorageSubsystem(StorageSubsystem storageSubsystem) {
        this.cStorageSubsystem = storageSubsystem;
    }

    public void setStorageSubsystemCOP(CIMObjectPath cIMObjectPath) {
        this.cStorageSubsystemCIMOP = cIMObjectPath;
    }

    public AsyncResult getAsyncResult() {
        return this.cAsyncResult;
    }

    public void setAsyncResult(AsyncResult asyncResult) {
        this.cAsyncResult = asyncResult;
    }

    public CIMClientWrapper getCIMClientWrapper() {
        return this.cCIMClientWrapper;
    }

    public void setCIMClientWrapper(CIMClientWrapper cIMClientWrapper) {
        this.cCIMClientWrapper = cIMClientWrapper;
    }

    public String getAPIMethodName() {
        return this.cAPIMethodName;
    }

    public void setAPIMethodName(String string) {
        this.cAPIMethodName = string;
    }

    public Token getToken() {
        return this.cToken;
    }

    public void setToken(Token token) {
        this.cToken = token;
    }

    public CIMOM getCimom() {
        return this.cCimom;
    }

    public void setCimom(CIMOM cIMOM) {
        this.cCimom = cIMOM;
    }

    public StorageSubsystem[] getStorageSubsystemsForSorting() {
        return this.cStorageSubsystemsForSorting;
    }

    public void setStorageSubsystemsForSorting(StorageSubsystem[] storageSubsystemArray) {
        this.cStorageSubsystemsForSorting = storageSubsystemArray;
    }

    public CIMObjectPath[] getVolumeCOPs() {
        return this.cVolumeCOPs;
    }

    public void setVolumeCOPs(CIMObjectPath[] cIMObjectPathArray) {
        this.cVolumeCOPs = cIMObjectPathArray;
    }

    public String[] getVolumeNames() {
        return this.cVolumeNames;
    }

    public void setVolumeNames(String[] stringArray) {
        this.cVolumeNames = stringArray;
    }

    public StorageVolume[] getVolumes() {
        return this.cVolumes;
    }

    public void setVolumes(StorageVolume[] storageVolumeArray) {
        this.cVolumes = storageVolumeArray;
    }

    public String[] getVolumeIDs() {
        return this.cVolumeIDs;
    }

    public void setVolumeIDs(String[] stringArray) {
        this.cVolumeIDs = stringArray;
    }

    public void addParameters(ConfigurationParameter configurationParameter, int n) {
        this.cVolumes = (StorageVolume[])this.addParameter(this.cVolumes, configurationParameter.getVolumes()[n]);
        this.cVolumeIDs = (String[])this.addParameter(this.cVolumeIDs, configurationParameter.getVolumeIDs()[n]);
        this.cVolumeNames = (String[])this.addParameter(this.cVolumeNames, configurationParameter.getVolumeNames()[n]);
    }

    public Object[] addParameter(Object[] objectArray, Object object) {
        Object[] objectArray2 = null;
        if (object instanceof String) {
            objectArray2 = new String[objectArray.length + 1];
        }
        if (object instanceof CIMObjectPath) {
            objectArray2 = new CIMObjectPath[objectArray.length + 1];
        }
        if (object instanceof StorageVolume) {
            objectArray2 = new StorageVolume[objectArray.length + 1];
        }
        if (objectArray2 == null) {
            throw new RuntimeException("Parameter is not of any expected class. Parameter: " + object.toString() + ", Class: " + object.getClass().getName());
        }
        if (objectArray.length != 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[objectArray.length] = object;
        return objectArray2;
    }

    public int getIDOfVolume(String string) {
        int n = 0;
        while (n < this.cVolumes.length) {
            if (string.equals(this.cVolumeIDs[n])) {
                return this.cVolumes[n].getSvid();
            }
            ++n;
        }
        return -1;
    }

    public CIMObjectPath getVolumeCOPForID(String string) {
        int n = 0;
        while (n < this.cVolumeCOPs.length) {
            if (string.equals(this.cVolumeIDs[n])) {
                return this.cVolumeCOPs[n];
            }
            ++n;
        }
        return null;
    }

    public String[] getVolumeIDsForCOPs(CIMObjectPath[] cIMObjectPathArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < cIMObjectPathArray.length) {
            n = 0;
            while (n < this.cVolumeCOPs.length) {
                if (cIMObjectPathArray[n2].equals((Object)this.cVolumeCOPs[n])) {
                    arrayList.add(this.cVolumeIDs[n]);
                }
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    public String[] getVolumeNamesForCOPs(CIMObjectPath[] cIMObjectPathArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < cIMObjectPathArray.length) {
            int n2 = 0;
            while (n2 < this.cVolumeCOPs.length) {
                if (cIMObjectPathArray[n].equals((Object)this.cVolumeCOPs[n2])) {
                    arrayList.add(this.cVolumeNames[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OutputHelper.toStringHeader(this.getClass()));
        stringBuffer.append(this.prepareToString());
        stringBuffer.append(OutputHelper.toStringFooter(this.getClass()));
        return stringBuffer.toString();
    }

    String prepareToStringNoVolumes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CIMOM: ");
        if (this.cCIMClientWrapper != null) {
            stringBuffer.append(this.cCIMClientWrapper.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    String prepareToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.prepareToStringNoVolumes());
        stringBuffer.append("; Storage Volume IDs: {");
        stringBuffer.append(OutputHelper.arrayToCS(this.cVolumeIDs));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

