/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.DiskMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.FabricMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.StormTreeLabel;
import org.eclipse.aperi.TStorm.gui.TapeMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.TStorm.gui.UserPrefEditorSM;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.About;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GlassPaneMouseListener;
import org.eclipse.aperi.gui.GuiApplet;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiConnect;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.SplashPanel;
import org.eclipse.aperi.gui.UserPrefEditor;
import org.eclipse.aperi.gui.WindowMenu;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.charting.AperiChartFactory;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiMain
extends JFrame
implements IGuiMain,
ActionListener,
MouseListener,
MenuListener,
KeyListener {
    public static final String LAF = GuiMain.setSystemLAF();
    public static Frame frame;
    static boolean DEMO_MODE;
    public static final String VERSION = "5.0.0";
    static final String BUILD = "5.0.0_Aperi-incubation-R04-071130-115054";
    private static final short ERROR = 12;
    private static Icon blankIcon;
    private String[] servers;
    public static String server;
    private static Hashtable computerTable;
    public static GuiMain pGuiMain;
    public static BaseTree pBaseTree;
    protected static String userName;
    public static UserPreferences prefs;
    public static DataDisplayInfo nullDDI;
    private static DashMain dashMain;
    public static DashTotalsRow dashTotalsRow;
    private static SplashPanel splashPanel;
    private static String[] lafClassNames;
    private static final String TITLE;
    private static final String NOT_CONNECTED;
    private static final String CONNECTION;
    private static final String NEW_CONNECTION;
    private static final String ERR_GET_COMP;
    private static final String PREFERENCES;
    private static final String LOOK_AND_FEEL;
    private static final String PREF_EDIT;
    private static final String FILE;
    private static final String FILE_SAVE;
    private static final String FILE_SAVE_AS;
    private static final String FILE_EXPORT;
    private static final String FILE_PRINT;
    private static final String FILE_PRINT_TREE;
    private static final String FILE_REFRESH_ALERTS;
    private static final String FILE_CLOSE;
    private static final String FILE_EXIT;
    private static final String VIEW;
    private static final String TREE;
    private static final String DISCONNECT_TITLE;
    private static final String DISCONNECT_WARNING;
    private static final String SYNCH = "SYN";
    public static JSplitPane splitPane;
    public static JScrollPane treePane;
    public static JScrollPane dataPane;
    private static JPanel holderPane;
    private static Component glassPane;
    public static Container contentPane;
    private static GlassPaneMouseListener glassML;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu connection_menu = new JMenu();
    private JMenuItem connectChange = new JMenuItem();
    private JMenu fileMenu = new JMenu();
    public myJMenuItem fileSave = new myJMenuItem();
    public myJMenuItem fileSaveAs = new myJMenuItem();
    public myJMenuItem fileExport = new myJMenuItem();
    public myJMenuItem filePrint = new myJMenuItem();
    public myJMenuItem filePrintTree = new myJMenuItem();
    public static JMenuItem fileClose;
    public static int curProperAdmin;
    private JMenuItem fileRefreshAlerts;
    private JMenuItem fileExit;
    private JMenu viewMenu = new JMenu();
    private JMenuItem viewSynch;
    private JCheckBoxMenuItem showTree = new JCheckBoxMenuItem();
    private JMenu preferencesMenu = new JMenu();
    private JMenu lookAndFeelMenu = new JMenu();
    private JMenuItem prefEdit = new JMenuItem();
    private JMenuItem prefEditSM = new JMenuItem();
    private JMenu windowMenu = new WindowMenu();
    private JMenu helpMenu = new JMenu();
    private JToolBar toolBar = new JToolBar();
    private JButton nextButton = new JButton();
    private JButton backButton = new JButton();
    public JButton printButton = new JButton();
    public static JButton stopButton;
    public static JButton cancelButton;
    public static BaseTreeNode selectedNode;
    private JLabel treeTitle;
    public static JPanel leftPanel;
    public static String adminGroup;
    private static boolean[] showNoSaveMsg;
    public SaveJButton saveButton = new SaveJButton();
    private static Color background;
    protected static GuiApplet applet;
    public static final Color blueGreen;
    public static final Color dustyRose;
    public static final Color purple;
    public static final Color brightRed;
    public static final Color coral;
    public static final Color dkCoral;
    public static final Color ltPink;
    public static final Color leafGreen;
    public static final Color blueSky;
    public static final Color greySky;
    public static final Color swimPool;
    public static final Color ltYellow;
    public static final Color hotPink;
    public static final Color teal;
    public static final Color sage;
    public static final Color bronze;
    public static final Color ocre;
    public static final Color peaGreen;
    public static final Color moss;
    public static final Color seaweed;
    public static final Color violet;
    public static final Color darkBlue;
    public static final Color[] chartColors;
    private static Component savedComponentWithFocus;
    public static Capabilities capabilities;
    public JPanel mainPanel = null;
    public static String platform;
    public static String RCP_PLATFORM;
    public static String SWING_PLATFORM;
    int indentLevel = 0;
    boolean expanded;
    static final String[] indentDots;
    static final String[] indentBlanks;
    private String INDENT_CHARS = "     ";
    String[] indenters;
    public static DataDisplayInfo ddiCurr;
    public static boolean disconnectInProcess;

    static {
        DEMO_MODE = false;
        blankIcon = IconFactory.getBlankIcon(IconFactory.getRedLightIcon().getIconWidth());
        computerTable = null;
        prefs = new UserPreferences();
        nullDDI = new DataDisplayInfo();
        TITLE = String.valueOf(MessageLog.getMessageNoID("GUI0000T")) + ":  ";
        NOT_CONNECTED = MessageLog.getMessageNoID("GUI0010T");
        CONNECTION = Util.getString("LABEL_CONNECTION_MENU");
        NEW_CONNECTION = MessageLog.getMessageNoID("GUI0012L");
        ERR_GET_COMP = MessageLog.getMessageNoID("GUI0016M");
        PREFERENCES = Util.getString("LABEL_PREFERENCES_MENU");
        LOOK_AND_FEEL = MessageLog.getMessageNoID("GUI0112T");
        PREF_EDIT = MessageLog.getMessageNoID("GUI5079L");
        FILE = Util.getString("LABEL_FILE_MENU");
        FILE_SAVE = MessageLog.getMessageNoID("GUI5006L");
        FILE_SAVE_AS = MessageLog.getMessageNoID("GUI5007L");
        FILE_EXPORT = MessageLog.getMessageNoID("GUI5069L");
        FILE_PRINT = MessageLog.getMessageNoID("GUI5098L");
        FILE_PRINT_TREE = MessageLog.getMessageNoID("GUI5099L");
        FILE_REFRESH_ALERTS = MessageLog.getMessageNoID("GUI2047L");
        FILE_CLOSE = MessageLog.getMessageNoID("GUI5008L");
        FILE_EXIT = MessageLog.getMessageNoID("GUI2046L");
        VIEW = Util.getString("LABEL_VIEW_MENU");
        TREE = MessageLog.getMessageNoID("GUI0152L");
        DISCONNECT_TITLE = MessageLog.getMessageNoID("GUI0132T");
        DISCONNECT_WARNING = MessageLog.getMessageNoID("GUI0133T");
        fileClose = new JMenuItem();
        curProperAdmin = 5;
        stopButton = new JButton();
        cancelButton = new JButton();
        showNoSaveMsg = new boolean[7];
        applet = null;
        blueGreen = new Color(64, 204, 204);
        dustyRose = new Color(204, 102, 102);
        purple = new Color(150, 0, 150);
        brightRed = new Color(255, 0, 0);
        coral = new Color(255, 120, 60);
        dkCoral = new Color(220, 35, 35);
        ltPink = new Color(255, 210, 210);
        leafGreen = new Color(188, 255, 50);
        blueSky = new Color(150, 150, 255);
        greySky = new Color(200, 200, 255);
        swimPool = new Color(200, 255, 255);
        ltYellow = new Color(255, 255, 150);
        hotPink = new Color(255, 140, 255);
        teal = new Color(0, 100, 200);
        sage = new Color(180, 220, 180);
        bronze = new Color(200, 100, 0);
        ocre = new Color(200, 150, 0);
        peaGreen = new Color(200, 220, 0);
        moss = new Color(150, 150, 50);
        seaweed = new Color(100, 100, 0);
        violet = new Color(150, 110, 150);
        darkBlue = new Color(0, 0, 200);
        chartColors = new Color[]{Color.blue, darkBlue, brightRed, dkCoral, coral, Color.orange, Color.yellow, peaGreen, leafGreen, Color.green, blueGreen, Color.cyan, teal, purple, Color.magenta, violet, dustyRose, bronze, ocre, moss, seaweed, Color.gray, ltYellow, ltPink, Color.pink, hotPink, blueSky, greySky, swimPool, sage, Color.white};
        savedComponentWithFocus = null;
        RCP_PLATFORM = "RCP";
        SWING_PLATFORM = "SWING";
        indentDots = new String[]{"", ".....", "..........", "...............", "....................", ".........................", "..............................", "...................................", "........................................", ".............................................", "..................................................", "......................................................."};
        indentBlanks = new String[]{"", "     ", "          ", "               ", "                    ", "                         ", "                              ", "                                   ", "                                        ", "                                             ", "                                                  ", "                                                       "};
        disconnectInProcess = false;
    }

    public boolean isProperAdmin() {
        boolean bl = false;
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo != null) {
            BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
            bl = GuiMain.isProperAdmin(baseTreeNode);
        }
        return bl;
    }

    private static boolean isProperAdmin(BaseTreeNode baseTreeNode) {
        boolean bl = false;
        if (baseTreeNode != null) {
            TreeNode[] treeNodeArray = baseTreeNode.getPath();
            int n = treeNodeArray.length;
            if (n < 2) {
                return false;
            }
            TreeNode treeNode = treeNodeArray[1];
            if (treeNode instanceof AdminTreeLabel) {
                bl = capabilities.isAperiAdmin();
                curProperAdmin = 5;
            } else if (treeNode instanceof TreeLabel) {
                bl = capabilities.isAnyAdmin();
                curProperAdmin = 4;
            } else if (treeNode instanceof StormTreeLabel) {
                bl = capabilities.isDataAdmin();
                curProperAdmin = 1;
            } else if (treeNode instanceof DiskMgrTreeLabel) {
                bl = capabilities.isDiskAdmin();
                curProperAdmin = 2;
            } else if (treeNode instanceof FabricMgrTreeLabel) {
                bl = capabilities.isFabricAdmin();
                curProperAdmin = 3;
            } else if (treeNode instanceof TapeMgrTreeLabel) {
                bl = capabilities.isTapeAdmin();
                curProperAdmin = 6;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        new GuiMain(stringArray, null);
    }

    public GuiMain(String[] stringArray, GuiApplet guiApplet) {
        Class<?> clazz;
        GuiManager.getGuiManager().setGuiMain(this);
        platform = SWING_PLATFORM;
        SwingUtilities.updateComponentTreeUI(this);
        GuiMain.prefs.lookAndFeel = LAF;
        applet = guiApplet;
        this.setVisible(false);
        pGuiMain = this;
        int n = 0;
        while (n < 7) {
            GuiMain.showNoSaveMsg[n] = true;
            ++n;
        }
        splitPane = new JSplitPane();
        treePane = new JScrollPane();
        dataPane = new JScrollPane();
        GuiUtil.setAccessible(pGuiMain, TITLE, TITLE);
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.GuiMain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(clazz.getResource("images/icon.gif")));
        glassPane = this.getGlassPane();
        contentPane = this.getContentPane();
        background = contentPane.getBackground();
        GuiMain.setServer(NOT_CONNECTED);
        this.setDefaultCloseOperation(0);
        this.setLocation(0, 0);
        contentPane.setLayout(new BorderLayout(0, 0));
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setSize(dimension.width, dimension.height - 26);
        this.setupMenuBar();
        this.setupToolBar();
        this.setupGlassPane();
        GuiMain.nullDDI.displayInScrollPane = false;
        nullDDI.setDescription(MessageLog.getMessageNoID("STG5238L"));
        splashPanel = new SplashPanel();
        dashMain = new DashMain();
        this.showNull(false);
        String[] stringArray2 = new String[]{"localhost:9549"};
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream("gui.properties");
            properties.load(fileInputStream);
            stringArray2[0] = properties.getProperty("server");
        }
        catch (IOException iOException) {}
        GuiConnect.createServerList(stringArray2);
        if (!DEMO_MODE) {
            splitPane.setDividerLocation((int)((double)dimension.width * 0.27));
            this.setVisible(true);
        }
        new GuiConnect();
        if (DEMO_MODE) {
            splitPane.setDividerLocation((int)((double)dimension.width * 0.27));
            this.setVisible(true);
        }
        this.helpMenu.setNextFocusableComponent(pBaseTree);
        this.addKeyListener(this);
        BaseTree.pBaseTree.setSelectionRow(0);
        BaseTree.pBaseTree.requestFocus();
    }

    private void setupMenuBar() {
        Object object;
        this.setJMenuBar(this.menuBar);
        this.fileMenu.setText(FILE);
        this.fileMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_FILEMENU"));
        GuiUtil.setAccessible(this.fileMenu, FILE, FILE);
        this.menuBar.add(this.fileMenu);
        this.fileSave.setText(FILE_SAVE);
        this.fileSave.setActionCommand("Save");
        this.fileSave.setEnabled(false);
        this.fileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        GuiUtil.setAccessible(this.fileSave, FILE_SAVE, FILE_SAVE);
        this.fileMenu.add(this.fileSave);
        this.viewMenu.setText(VIEW);
        this.viewMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_VIEWMENU"));
        GuiUtil.setAccessible(this.viewMenu, VIEW, VIEW);
        this.menuBar.add(this.viewMenu);
        this.showTree.setActionCommand("tree");
        this.showTree.setText(TREE);
        this.showTree.setSelected(true);
        GuiUtil.setAccessible(this.showTree, TREE, TREE);
        this.viewMenu.add(this.showTree);
        String string = MessageLog.getMessageNoID("GUI0066L");
        this.viewSynch = new JMenuItem(string);
        this.viewSynch.setActionCommand(SYNCH);
        this.viewSynch.addActionListener(this);
        GuiUtil.setAccessible(this.viewSynch, SYNCH, SYNCH);
        this.viewMenu.add(this.viewSynch);
        this.viewMenu.addMenuListener(this);
        this.fileSaveAs.setText(FILE_SAVE_AS);
        this.fileSaveAs.setActionCommand("SaveAs");
        this.fileSaveAs.setEnabled(false);
        this.fileSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        GuiUtil.setAccessible(this.fileSaveAs, FILE_SAVE_AS, FILE_SAVE_AS);
        this.fileMenu.add(this.fileSaveAs);
        this.fileExport.setText(FILE_EXPORT);
        this.fileExport.setActionCommand("Export");
        this.fileExport.setEnabled(false);
        GuiUtil.setAccessible(this.fileExport, FILE_EXPORT, FILE_EXPORT);
        this.fileMenu.add(this.fileExport);
        this.filePrint.setText(FILE_PRINT);
        this.filePrint.setActionCommand("Print");
        this.filePrint.setEnabled(false);
        this.filePrint.addActionListener(this);
        GuiUtil.setAccessible(this.filePrint, FILE_PRINT, FILE_PRINT);
        this.fileMenu.add(this.filePrint);
        this.filePrintTree.setText(FILE_PRINT_TREE);
        this.filePrintTree.setActionCommand("PrintTree");
        this.filePrintTree.addActionListener(this);
        GuiUtil.setAccessible(this.filePrintTree, FILE_PRINT_TREE, FILE_PRINT_TREE);
        this.fileMenu.add(this.filePrintTree);
        this.fileRefreshAlerts = new JMenuItem(FILE_REFRESH_ALERTS);
        this.fileMenu.add(this.fileRefreshAlerts);
        this.fileRefreshAlerts.addActionListener(this);
        GuiUtil.setAccessible(this.fileRefreshAlerts, FILE_REFRESH_ALERTS, FILE_REFRESH_ALERTS);
        fileClose.setText(FILE_CLOSE);
        fileClose.setActionCommand("Close");
        fileClose.setEnabled(true);
        fileClose.addActionListener(this);
        GuiUtil.setAccessible(fileClose, FILE_CLOSE, FILE_CLOSE);
        this.fileMenu.add(fileClose);
        this.fileExit = new JMenuItem(FILE_EXIT);
        this.fileMenu.add(this.fileExit);
        this.fileExit.addActionListener(this);
        GuiUtil.setAccessible(this.fileExit, FILE_EXIT, FILE_EXIT);
        this.connection_menu.setText(CONNECTION);
        this.connection_menu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CONNECTION"));
        GuiUtil.setAccessible(this.connection_menu, CONNECTION, CONNECTION);
        this.menuBar.add(this.connection_menu);
        this.connectChange.setText(NEW_CONNECTION);
        GuiUtil.setAccessible(this.connectChange, NEW_CONNECTION, NEW_CONNECTION);
        this.connection_menu.add(this.connectChange);
        this.preferencesMenu.setText(PREFERENCES);
        this.preferencesMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PREFERENCES"));
        GuiUtil.setAccessible(this.preferencesMenu, PREFERENCES, PREFERENCES);
        this.menuBar.add(this.preferencesMenu);
        this.lookAndFeelMenu.setText(LOOK_AND_FEEL);
        GuiUtil.setAccessible(this.lookAndFeelMenu, LOOK_AND_FEEL, LOOK_AND_FEEL);
        this.preferencesMenu.add(this.lookAndFeelMenu);
        this.prefEdit.setText(PREF_EDIT);
        this.prefEdit.setActionCommand(PREF_EDIT);
        GuiUtil.setAccessible(this.prefEdit, PREF_EDIT, PREF_EDIT);
        this.preferencesMenu.add(this.prefEdit);
        this.preferencesMenu.add(AperiChartFactory.getChartEngineMenu());
        this.menuBar.add(this.windowMenu);
        this.menuBar.add(this.helpMenu);
        String string2 = Util.getString("LABEL_HELP_MENU");
        this.helpMenu.setText(string2);
        this.helpMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        GuiUtil.setAccessible(this.helpMenu, string2, string2);
        new Help().createMenu(this.helpMenu);
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string3 = lookAndFeel.getClass().getName();
        boolean bl = false;
        String string4 = System.getProperty("os.name", " ");
        if (string4.regionMatches(true, 0, "win", 0, 3)) {
            bl = true;
        }
        System.getProperty("java.version", " ");
        ButtonGroup buttonGroup = new ButtonGroup();
        NameList nameList = null;
        int n = 0;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n2 = 0;
        while (n2 < lookAndFeelInfoArray.length) {
            object = lookAndFeelInfoArray[n2].getName();
            if (object != null && (bl || !((String)object).equalsIgnoreCase("windows"))) {
                NameList nameList2 = new NameList();
                nameList2.nlID = n2;
                nameList2.nlName = object;
                nameList2.nlNext = nameList;
                nameList = nameList2;
                ++n;
            }
            ++n2;
        }
        lafClassNames = new String[n];
        n2 = 0;
        while (nameList != null) {
            GuiMain.lafClassNames[n2] = lookAndFeelInfoArray[nameList.nlID].getClassName();
            boolean bl2 = false;
            if (string3.equals(lafClassNames[n2])) {
                bl2 = true;
            }
            object = new JRadioButtonMenuItem(nameList.nlName, bl2);
            ((AbstractButton)object).setActionCommand(lafClassNames[n2]);
            buttonGroup.add((AbstractButton)object);
            this.lookAndFeelMenu.add((JMenuItem)object);
            ((AbstractButton)object).addActionListener(this);
            ++n2;
            nameList = nameList.nlNext;
        }
    }

    private void setupToolBar() {
        contentPane.add("North", this.toolBar);
        this.backButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0007L", null) + "   ");
        this.backButton.setIcon(IconFactory.getBackIcon());
        this.backButton.setRolloverIcon(IconFactory.getRolloverBackIcon());
        this.backButton.setVerticalTextPosition(3);
        this.backButton.setHorizontalTextPosition(0);
        this.backButton.setMargin(new Insets(2, 2, 2, 2));
        this.backButton.addMouseListener(this);
        this.backButton.setEnabled(false);
        this.toolBar.add(this.backButton);
        this.nextButton.setToolTipText(MessageLog.getMessageNoID("GUI0008L", null));
        this.nextButton.setIcon(IconFactory.getNextIcon());
        this.nextButton.setRolloverIcon(IconFactory.getRolloverNextIcon());
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.addMouseListener(this);
        this.nextButton.setEnabled(false);
        this.toolBar.add(this.nextButton);
        this.toolBar.addSeparator();
        this.saveButton.setIcon(IconFactory.getSaveIcon());
        this.saveButton.setRolloverIcon(IconFactory.getRolloverSaveIcon());
        this.saveButton.setVerticalTextPosition(3);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setMargin(new Insets(2, 2, 2, 2));
        this.saveButton.setEnabled(false);
        this.saveButton.setActionCommand("Save");
        this.toolBar.add(this.saveButton);
        this.toolBar.addSeparator();
        this.printButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0009L", null) + "   ");
        this.printButton.setIcon(IconFactory.getPrintIcon());
        this.printButton.setRolloverIcon(IconFactory.getRolloverPrintIcon());
        this.printButton.setVerticalTextPosition(3);
        this.printButton.setHorizontalTextPosition(0);
        this.printButton.setMargin(new Insets(2, 2, 2, 2));
        this.printButton.setEnabled(false);
        this.toolBar.add(this.printButton);
        this.toolBar.addSeparator();
        cancelButton.setToolTipText(MessageLog.getMessageNoID("GUI5010T"));
        cancelButton.setIcon(IconFactory.getRaggedBlackXIcon());
        cancelButton.setRolloverIcon(IconFactory.getRaggedRedXIcon());
        cancelButton.setVerticalTextPosition(3);
        cancelButton.setHorizontalTextPosition(0);
        cancelButton.setMargin(new Insets(2, 2, 2, 2));
        cancelButton.setActionCommand("Cancel");
        this.toolBar.add(cancelButton);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        stopButton.setIcon(IconFactory.getStopIcon());
        stopButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0042T", null) + "   ");
        stopButton.setMargin(new Insets(2, 2, 2, 2));
        this.toolBar.add(stopButton);
        stopButton.setEnabled(false);
        this.enableRollover();
        contentPane.add("Center", splitPane);
        splitPane.setBounds(0, 0, 0, 0);
        treePane.setOpaque(true);
        leftPanel = new JPanel(new BorderLayout(2, 2));
        this.treeTitle = new JLabel(Util.getString("LABEL_TREE_TITLE"));
        this.treeTitle.setOpaque(false);
        this.treeTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_TREE_TITLE"));
        this.treeTitle.setLabelFor(pBaseTree);
        leftPanel.add((Component)this.treeTitle, "North");
        leftPanel.add((Component)treePane, "Center");
        splitPane.add((Component)leftPanel, "left");
        treePane.setBounds(1, 1, 182, 798);
        pBaseTree = new BaseTree();
        pBaseTree.setBackground(Color.white);
        pBaseTree.putClientProperty("JTree.lineStyle", "Angled");
        treePane.getViewport().add(pBaseTree);
        pBaseTree.setBounds(0, 0, 179, 795);
        splitPane.add((Component)dataPane, "right");
        dataPane.setBounds(193, 1, 406, 798);
        TSWindow tSWindow = new TSWindow();
        this.addWindowListener(tSWindow);
        this.showTree.addActionListener(this);
        this.connectChange.addActionListener(this);
        this.prefEdit.addActionListener(this);
        this.prefEditSM.addActionListener(this);
        this.backButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.printButton.addActionListener(this);
        stopButton.addActionListener(this);
        cancelButton.addActionListener(this);
    }

    private void setupGlassPane() {
        glassML = new GlassPaneMouseListener(stopButton, glassPane, contentPane, this);
        glassPane.addMouseListener(glassML);
        glassPane.addMouseMotionListener(glassML);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isAltDown() && keyEvent.getKeyCode() == this.treeTitle.getDisplayedMnemonic()) {
            if (savedComponentWithFocus != null) {
                savedComponentWithFocus.requestFocus();
            } else {
                pBaseTree.setSelectionRow(0);
                pBaseTree.requestFocus();
            }
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 77 && BaseTree.selectedNode != null) {
            Rectangle rectangle = pBaseTree.getPathBounds(BaseTree.selectedPath);
            BaseTree.selectedNode.showPopupMenu(new MouseEvent(pBaseTree, 0, 0L, 0, (int)rectangle.getX(), (int)rectangle.getY(), 1, false));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void windowClosing() {
        if (this.disconnectFromServer()) {
            pGuiMain = null;
            if (applet == null) {
                System.exit(0);
            } else {
                GuiApplet guiApplet = applet;
                synchronized (guiApplet) {
                    applet.notify();
                }
                this.dispose();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        if (mouseEvent.isPopupTrigger() && jButton.isEnabled()) {
            boolean bl = jButton == this.nextButton;
            JPopupMenu jPopupMenu = new JPopupMenu();
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
            int n = 0;
            while ((dataDisplayInfo = bl ? dataDisplayInfo.getNext() : dataDisplayInfo.getPrev()) != null) {
                JMenuItem jMenuItem = new JMenuItem(dataDisplayInfo.toString());
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand(Integer.toString(bl ? ++n : --n));
                if (dataDisplayInfo.changesPending()) {
                    jMenuItem.setIcon(IconFactory.getRedLightIcon());
                } else if (dataDisplayInfo.isEditable()) {
                    jMenuItem.setIcon(IconFactory.getGreenLightIcon());
                } else {
                    jMenuItem.setIcon(blankIcon);
                }
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(jButton, jButton.getWidth(), 0);
        }
    }

    private void setSelectedNode() {
        selectedNode = null;
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo == null) {
            return;
        }
        BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
        if (baseTreeNode == null) {
            return;
        }
        TreeNode[] treeNodeArray = BaseTree.MyTree.getPathToRoot(baseTreeNode);
        if (treeNodeArray == null || treeNodeArray.length == 0) {
            return;
        }
        if (treeNodeArray[0] == (TreeNode)BaseTree.MyTree.getRoot()) {
            selectedNode = baseTreeNode;
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.setSelectedNode();
        this.viewSynch.setEnabled(selectedNode != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.connectChange) {
            if (this.disconnectFromServer()) {
                new GuiConnect();
            }
        } else if (object == this.fileExit) {
            this.windowClosing();
        } else if (object == this.fileRefreshAlerts) {
            AlertManager.refreshAlerts();
        } else if (object == this.showTree) {
            if (this.showTree.isSelected()) {
                splitPane.add((Component)leftPanel, "left");
            } else {
                splitPane.remove(leftPanel);
            }
        } else if (object == this.prefEdit) {
            new UserPrefEditor();
        } else if (object == this.prefEditSM) {
            new UserPrefEditorSM();
        } else if (object == this.backButton) {
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
            if (ddiCurr != nullDDI) {
                dataDisplayInfo = dataDisplayInfo.getPrev();
            }
            if (dataDisplayInfo != null) {
                dataDisplayInfo.reDisplay();
            }
        } else if (object == this.nextButton) {
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent().getNext();
            if (dataDisplayInfo != null) {
                dataDisplayInfo.reDisplay();
            }
        } else if (object == this.printButton || object == this.filePrint) {
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
            if (dataDisplayInfo == null || dashMain.getDisplayedDashboard().isShowing()) {
                GuiMain.nullDDI.panel = dashMain.getDisplayedDashboard();
                nullDDI.setDescription(dashMain.getTitle());
                dataDisplayInfo = nullDDI;
            }
            dataDisplayInfo.printData(null);
        } else if (object == this.filePrintTree) {
            this.printTree(BaseTree.root);
        } else if (object == stopButton) {
            this.endRequestWait();
        } else if (object == cancelButton || object == fileClose) {
            if (GuiMain.nullDDI.panel != null) {
                DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
                if (ddiCurr != nullDDI) {
                    dataDisplayInfo = dataDisplayInfo.getPrev();
                }
                if (dataDisplayInfo != null) {
                    dataDisplayInfo.reDisplay();
                }
            } else {
                DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
                if (dataDisplayInfo != null) {
                    dataDisplayInfo.fileClose();
                }
            }
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName("javax.swing.JRadioButtonMenuItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (clazz.isInstance(object)) {
                this.setLookAndFeel(actionEvent.getActionCommand());
            } else if (object == this.viewSynch) {
                BaseTree.pBaseTree.reselect(selectedNode, false);
            } else {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("javax.swing.JMenuItem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (clazz2.isInstance(object)) {
                    int n = Integer.decode(actionEvent.getActionCommand());
                    boolean bl = n > 0;
                    n = bl ? n : -n;
                    DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
                    int n2 = 0;
                    while (n2++ < n) {
                        DataDisplayInfo dataDisplayInfo2 = dataDisplayInfo = bl ? dataDisplayInfo.getNext() : dataDisplayInfo.getPrev();
                    }
                    dataDisplayInfo.reDisplay();
                }
            }
        }
    }

    public void printTree(BaseTreeNode baseTreeNode) {
        PrintOutputChooser printOutputChooser = new PrintOutputChooser();
        printOutputChooser.allowCSV(false);
        printOutputChooser.allowFormatted(false);
        PrintOptions printOptions = printOutputChooser.getOptions(true, true);
        if (printOptions != null) {
            printOptions.creator = GuiUtil.getUserName();
            printOptions.title = MessageLog.getMessageNoID("GEN0194L");
            printOptions.fileMask = TREE;
            if (printOptions.outputType == 2 || printOptions.outputType == 3 || printOptions.outputType == 4 || printOptions.outputType == 5) {
                printOptions.fileName = PrintTableData.getFileName(printOptions);
                if (printOptions.fileName == null) {
                    return;
                }
            }
            if (printOptions.outputType == 1) {
                BaseTree.setPrintableSubTree(baseTreeNode);
                new PrintPreviewPanel(pBaseTree, false);
                return;
            }
            PrintManager.getPrinter(printOptions);
            if (printOptions.outFile != null) {
                printOptions.printTitle(printOptions.outFile);
                if (printOptions.outputType == 3) {
                    this.INDENT_CHARS = ".....";
                    OutputStreamWriter outputStreamWriter = null;
                    PrintWriter printWriter = null;
                    try {
                        if (printOptions.outFile != null) {
                            outputStreamWriter = new OutputStreamWriter((OutputStream)printOptions.outFile, "UTF-8");
                        }
                    }
                    catch (Exception exception) {
                        GuiUtil.displayErrorMessage(exception.getMessage());
                    }
                    if (printOptions.outFile != null) {
                        printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                    }
                    if (printWriter != null) {
                        printWriter.println("<html>");
                        printWriter.println("<head>");
                        printWriter.print("<title>");
                        if (printOptions.title != null) {
                            printWriter.print(printOptions.title);
                        }
                        printWriter.println("</title>");
                        printWriter.println(" ");
                        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
                        printWriter.println("<style type=\"text/css\">");
                        printWriter.println("   .title   { color: #000066  }");
                        printWriter.println("</style>");
                        printWriter.println(" ");
                        printWriter.println("</head>");
                        printWriter.println("<body>");
                        printWriter.println(" ");
                        printWriter.print("<h2 class=\"title\">");
                        if (printOptions.title != null) {
                            printWriter.print(printOptions.title);
                        }
                        printWriter.println("</h2>");
                        printWriter.println(" ");
                        printWriter.print("<h4 class=\"title\">");
                        printWriter.print(MessageLog.getMessageNoID("GEN0192L"));
                        printWriter.print(" ");
                        printWriter.print(GuiUtil.getUserName());
                        printWriter.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        printWriter.print(MessageLog.getMessageNoID("GEN0193L"));
                        printWriter.print(" ");
                        printWriter.print(Util.formatDateTime(Calendar.getInstance().getTime()));
                        printWriter.println("</h4>");
                        printWriter.println(" ");
                        printWriter.println("<p>");
                        this.printHTMLSubtree(baseTreeNode, printWriter);
                        printWriter.println("</p>");
                        printWriter.println(" ");
                        printWriter.println("</body>");
                        printWriter.println("</html>");
                        printWriter.close();
                    }
                    return;
                }
                this.indenters = indentBlanks;
                this.printSubtree(baseTreeNode);
                PrintManager.printDocument(printOptions);
            }
        }
    }

    private void printSubtree(BaseTreeNode baseTreeNode) {
        if (baseTreeNode.getAllowsChildren()) {
            this.expanded = pBaseTree.isExpanded(new TreePath(baseTreeNode.getPath()));
        }
        if (baseTreeNode.getAllowsChildren() && this.expanded) {
            ++this.indentLevel;
            baseTreeNode.getChildCount();
            Enumeration<TreeNode> enumeration = baseTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.printSubtree((BaseTreeNode)enumeration.nextElement());
            }
            --this.indentLevel;
        }
    }

    private String createTreeIndent(BaseTreeNode baseTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        int n = baseTreeNode.getLevel();
        while (n > 0) {
            stringBuffer.append(this.INDENT_CHARS);
            --n;
        }
        return stringBuffer.toString();
    }

    private void printHTMLSubtree(BaseTreeNode baseTreeNode, PrintWriter printWriter) {
        boolean bl = false;
        if (baseTreeNode.nodeColor != Color.black) {
            bl = true;
            printWriter.print("<font color=\"#");
            printWriter.print(Integer.toHexString(baseTreeNode.nodeColor.getRed()));
            printWriter.print(Integer.toHexString(baseTreeNode.nodeColor.getGreen()));
            printWriter.print(Integer.toHexString(baseTreeNode.nodeColor.getBlue()));
            printWriter.print("\"/>");
        }
        printWriter.print(this.createTreeIndent(baseTreeNode));
        if (baseTreeNode.getAllowsChildren()) {
            if (pBaseTree.isExpanded(new TreePath(baseTreeNode.getPath()))) {
                printWriter.print("- ");
                this.expanded = true;
            } else {
                printWriter.print("+ ");
                this.expanded = false;
            }
        } else {
            printWriter.print("  ");
        }
        printWriter.print(baseTreeNode.toString());
        if (bl) {
            printWriter.print("</font>");
        }
        printWriter.println("<br>");
        if (baseTreeNode.getAllowsChildren() && this.expanded) {
            baseTreeNode.getChildCount();
            Enumeration<TreeNode> enumeration = baseTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.printHTMLSubtree((BaseTreeNode)enumeration.nextElement(), printWriter);
            }
        }
    }

    public void endRequestWait() {
        GuiClient.cancelAll();
        pGuiMain.guiEnabled(true);
    }

    protected void setLookAndFeel(String string) {
        String string2 = null;
        int n = 0;
        while (n < lafClassNames.length) {
            if (string.equals(lafClassNames[n])) {
                string2 = lafClassNames[n];
            }
            ++n;
        }
        if (string2 == null) {
            return;
        }
        try {
            n = splitPane.getDividerLocation() + splitPane.getDividerSize() / 2;
            UIManager.setLookAndFeel(string2);
            GuiMain.prefs.lookAndFeel = string2;
            SwingUtilities.updateComponentTreeUI(this);
            splitPane.setDividerLocation(n - splitPane.getDividerSize() / 2);
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
            while (dataDisplayInfo != null) {
                if (dataDisplayInfo.panel != null) {
                    SwingUtilities.updateComponentTreeUI(dataDisplayInfo.panel);
                }
                dataDisplayInfo = dataDisplayInfo.getNext();
            }
            this.enableRollover();
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            JOptionPane.showMessageDialog(this, MessageLog.getMessageNoID("GUI0109M", objectArray), MessageLog.getMessageNoID("GUI0110T", null), 2);
        }
    }

    protected void setLAFbutton() {
        JPopupMenu jPopupMenu = this.lookAndFeelMenu.getPopupMenu();
        String string = UIManager.getLookAndFeel().getClass().getName();
        int n = 0;
        while (n < lafClassNames.length) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jPopupMenu.getComponent(n);
            if (jRadioButtonMenuItem.getActionCommand().equals(string)) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n;
        }
    }

    private void enableRollover() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GuiMain.this.backButton.setRolloverEnabled(true);
                GuiMain.this.nextButton.setRolloverEnabled(true);
                GuiMain.this.printButton.setRolloverEnabled(true);
                GuiMain.this.saveButton.setRolloverEnabled(true);
                cancelButton.setRolloverEnabled(true);
            }
        });
    }

    public void guiEnabled(boolean bl) {
        glassPane.setVisible(!bl);
        if (savedComponentWithFocus != null) {
            savedComponentWithFocus.requestFocus();
        } else {
            pBaseTree.requestFocus();
        }
        stopButton.setEnabled(!bl);
        if (bl) {
            glassPane.setCursor(Cursor.getPredefinedCursor(0));
            pGuiMain.setCursor(Cursor.getPredefinedCursor(0));
        } else if (savedComponentWithFocus != stopButton) {
            savedComponentWithFocus = pGuiMain.getFocusOwner();
            stopButton.requestFocus();
            glassML.setStopBounds();
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            pGuiMain.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void setServer(String string) {
        pGuiMain.setTitle(String.valueOf(TITLE) + string);
        server = string;
    }

    public void showNull() {
        this.showNull(false);
    }

    public void showNull(boolean bl) {
        if (DataDisplayInfo.getCurrent() != null) {
            DataDisplayInfo.getCurrent().loseFocus();
        }
        GuiMain.nullDDI.panel = server == NOT_CONNECTED || dashTotalsRow == null ? About.getAboutPanel() : dashMain.getDashboard(dashTotalsRow, bl);
        this.setView(nullDDI);
    }

    public static void setTheTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(TITLE);
        stringBuffer.append(server);
        stringBuffer.append(" -- ");
        stringBuffer.append(string);
        pGuiMain.setTitle(stringBuffer.toString());
    }

    public void setView(DataDisplayInfo dataDisplayInfo) {
        if (dataDisplayInfo != nullDDI) {
            GuiMain.nullDDI.panel = null;
        }
        ddiCurr = dataDisplayInfo;
        int n = splitPane.getDividerLocation();
        if (dataDisplayInfo.displayInScrollPane) {
            splitPane.add((Component)dataPane, "right");
            dataPane.setViewportView(dataDisplayInfo.panel);
            contentPane.setBackground(background);
        } else {
            holderPane = new JPanel();
            holderPane.setLayout(new BorderLayout());
            holderPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            holderPane.setBounds(193, 1, 406, 798);
            holderPane.add((Component)dataDisplayInfo.panel, "Center");
            splitPane.add((Component)holderPane, "right");
            contentPane.setBackground(Color.white);
        }
        splitPane.setDividerLocation(n);
        pBaseTree.reselect(dataDisplayInfo.treeNode);
        this.setPrevNext();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(TITLE);
        stringBuffer.append(server);
        if (dataDisplayInfo != nullDDI) {
            stringBuffer.append(" -- ");
            stringBuffer.append(dataDisplayInfo.getDescription());
        }
        pGuiMain.setTitle(stringBuffer.toString());
    }

    public void setPrevNext() {
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        DataDisplayInfo dataDisplayInfo2 = null;
        DataDisplayInfo dataDisplayInfo3 = null;
        if (dataDisplayInfo != null) {
            if (dataDisplayInfo.panel == null) {
                GuiMain.pGuiMain.printButton.setEnabled(false);
            }
            dataDisplayInfo3 = dataDisplayInfo.getNext();
            dataDisplayInfo2 = ddiCurr == nullDDI ? dataDisplayInfo : dataDisplayInfo.getPrev();
        }
        GuiMain.pGuiMain.backButton.setEnabled(dataDisplayInfo2 != null);
        GuiMain.pGuiMain.nextButton.setEnabled(dataDisplayInfo3 != null);
        GuiMain.pGuiMain.backButton.getModel().setRollover(false);
        GuiMain.pGuiMain.nextButton.getModel().setRollover(false);
        GuiMain.pGuiMain.printButton.getModel().setRollover(false);
    }

    public boolean disconnectFromServer() {
        disconnectInProcess = true;
        DataDisplayInfo.removeAllWithoutChanges();
        this.removeAllDDIChanged();
        if (DataDisplayInfo.getCurrent() == null) {
            if (server != NOT_CONNECTED) {
                GuiClient.saveUserPrefs();
            }
            computerTable = null;
            GuiMain.setServer(NOT_CONNECTED);
            BaseTree.pBaseTree.setVisible(false);
            GuiClient.serverStatusResp = null;
            this.showNull(false);
            disconnectInProcess = false;
            int n = 0;
            while (n < 7) {
                GuiMain.showNoSaveMsg[n] = true;
                ++n;
            }
            return true;
        }
        DataDisplayInfo.getCurrent().reDisplay();
        return false;
    }

    public void removeAllDDIChanged() {
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo != null) {
            Object[] objectArray = new String[]{MessageLog.getMessageNoID("GUI0113L"), MessageLog.getMessageNoID("GUI0114L")};
            int n = 0;
            BaseTreeNode baseTreeNode = dataDisplayInfo.treeNode;
            if (GuiMain.isProperAdmin(baseTreeNode)) {
                n = JOptionPane.showOptionDialog(pGuiMain, DISCONNECT_WARNING, DISCONNECT_TITLE, 0, 2, null, objectArray, objectArray[1]);
            }
            if (n == 0) {
                GuiMain.removeAllDDI();
            }
        }
    }

    private static void removeAllDDI() {
        DataDisplayInfo dataDisplayInfo;
        while ((dataDisplayInfo = DataDisplayInfo.getCurrent()) != null) {
            dataDisplayInfo.remove();
        }
    }

    public static String getUserName() {
        if (userName == null) {
            userName = System.getProperty("user.name", " ");
        }
        return userName;
    }

    private static String setSystemLAF() {
        String string = null;
        try {
            string = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string);
            return string;
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            JOptionPane.showMessageDialog(null, MessageLog.getMessageNoID("GUI0109M", objectArray), MessageLog.getMessageNoID("GUI0110T", null), 2);
            return null;
        }
    }

    public void setExportActionEnabled(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.fileExport.setEnabledForced();
        } else {
            this.fileExport.setEnabled(bl);
        }
    }

    public void setPrintActionEnabled(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.filePrint.setEnabledForced();
            this.printButton.setEnabled(bl);
        } else {
            this.filePrint.setEnabled(bl);
            this.printButton.setEnabled(bl);
        }
    }

    public void setPrintTreeActionEnabled(boolean bl) {
        this.filePrintTree.setEnabled(bl);
    }

    public void setSaveAsActionEnabled(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.fileSaveAs.setEnabledForced();
        } else {
            this.fileSaveAs.setEnabled(bl);
        }
    }

    public void setSaveActionEnabled(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.fileSave.setEnabledForced();
            this.saveButton.setEnabledForced();
        } else {
            this.fileSave.setEnabled(bl);
            this.saveButton.setEnabled(bl);
        }
    }

    public Frame getFrame() {
        return pGuiMain;
    }

    public ActionListener[] getSaveActionListeners() {
        return this.fileSave.getActionListeners();
    }

    public ActionListener[] getSaveAsActionListeners() {
        return this.fileSaveAs.getActionListeners();
    }

    public void addSaveActionListener(ActionListener actionListener) {
        this.fileSave.addActionListener(actionListener);
        this.saveButton.addActionListener(actionListener);
    }

    public void addSaveAsActionListener(ActionListener actionListener) {
        this.fileSaveAs.addActionListener(actionListener);
    }

    public BaseTree getBaseTree() {
        return pBaseTree;
    }

    public void removeSaveActionListener(ActionListener actionListener) {
        this.fileSave.removeActionListener(actionListener);
        this.saveButton.removeActionListener(actionListener);
    }

    public void removeSaveAsActionListener(ActionListener actionListener) {
        this.fileSaveAs.removeActionListener(actionListener);
    }

    public void setSaveActionToolTip(String string) {
        this.fileSave.setToolTipText(string);
        this.saveButton.setToolTipText(string);
    }

    public void setSaveAsActionToolTip(String string) {
        this.fileSaveAs.setToolTipText(string);
    }

    public void removeExportActionListener(ActionListener actionListener) {
        this.fileExport.removeActionListener(actionListener);
    }

    public void removePrintActionListener(ActionListener actionListener) {
        this.filePrint.removeActionListener(actionListener);
        this.printButton.removeActionListener(actionListener);
    }

    public void addExportActionListener(ActionListener actionListener) {
        this.fileExport.addActionListener(actionListener);
    }

    public void setExportActionToolTip(String string) {
        this.fileExport.setToolTipText(string);
    }

    public void addPrintActionListener(ActionListener actionListener) {
        this.filePrint.addActionListener(actionListener);
        this.printButton.addActionListener(actionListener);
    }

    public void setPrintActionToolTip(String string) {
        this.filePrint.setToolTipText(string);
        this.printButton.setToolTipText(string);
    }

    public ActionListener[] getExportActionListeners() {
        return this.fileExport.getActionListeners();
    }

    public void setDashTotalsRow(DashTotalsRow dashTotalsRow) {
        GuiMain.dashTotalsRow = dashTotalsRow;
    }

    public Capabilities getCapabilities() {
        return capabilities;
    }

    public UserPreferences getUserPrefs() {
        return prefs;
    }

    public DataDisplayInfo getNullDDI() {
        return nullDDI;
    }

    public void addCancelActionListener(ActionListener actionListener) {
        cancelButton.addActionListener(actionListener);
    }

    public void addStopActionListener(ActionListener actionListener) {
        stopButton.addActionListener(actionListener);
    }

    public ActionListener[] getCancelActionListeners() {
        return cancelButton.getActionListeners();
    }

    public ActionListener[] getStopActionListeners() {
        return stopButton.getActionListeners();
    }

    public void removeCancelActionListener(ActionListener actionListener) {
        cancelButton.removeActionListener(actionListener);
    }

    public void removeStopActionListener(ActionListener actionListener) {
        stopButton.removeActionListener(actionListener);
    }

    public void setCancelActionToolTip(String string) {
        cancelButton.setToolTipText(string);
    }

    public void setCancelActionEnabled(boolean bl, boolean bl2) {
        cancelButton.setEnabled(bl);
    }

    public void setStopActionToolTip(String string) {
        stopButton.setToolTipText(string);
    }

    public void setStopActionEnabled(boolean bl, boolean bl2) {
        stopButton.setEnabled(bl);
    }

    public class myJMenuItem
    extends JMenuItem {
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && GuiMain.this.isProperAdmin());
        }

        public void setEnabledForced() {
            super.setEnabled(true);
        }
    }

    public class SaveJButton
    extends JButton {
        public SaveJButton() {
            this.setToolTipText(MessageLog.getMessageNoID("GUI5009T"));
        }

        public void setToolTipText(String string) {
            if (string == null || string.equals("")) {
                super.setToolTipText(MessageLog.getMessageNoID("GUI5009T"));
            } else {
                super.setToolTipText(string);
            }
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = GuiMain.this.isProperAdmin();
            super.setEnabled(bl && bl2);
            if (bl && !bl2 && showNoSaveMsg[curProperAdmin]) {
                String string;
                showNoSaveMsg[GuiMain.curProperAdmin] = false;
                if (curProperAdmin == 4) {
                    string = Util.getString("GUI0166T");
                } else {
                    Object[] objectArray = new Object[]{Capabilities.roleNames[curProperAdmin]};
                    string = MessageLog.getMessageNoID("GUI0154T", objectArray);
                }
                JOptionPane.showMessageDialog(pGuiMain, string, MessageLog.getMessageNoID("GUI0153T"), 2);
            }
        }

        public void setEnabledForced() {
            super.setEnabled(true);
        }
    }

    private class TSWindow
    extends WindowAdapter {
        private TSWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            GuiMain.this.windowClosing();
        }
    }
}

