/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.SpinBox;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogConfigDialog
extends JDialog
implements ActionListener,
GuiRequestor {
    private int computerID;
    private HashMap config;
    private TComboBox lComboBox;
    private SpinBox mfSpinBox;
    private SpinBox mfsSpinBox;
    private JButton okButton;
    private JButton cancelButton;
    private Object name;
    private boolean isAgent;
    private boolean isAudit;
    private JLabel label;
    private JCheckBox enableTrace;
    private String serviceCode;
    private static String[] levelArray = new String[]{"DEBUG_MIN", "DEBUG_MID", "DEBUG_MAX"};
    static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public LogConfigDialog(String string, String string2) {
        this(string, 0, null, false, string2, false);
    }

    public LogConfigDialog(String string, String string2, boolean bl) {
        this(string, 0, null, false, string2, bl);
    }

    public LogConfigDialog(String string, int n, Object object, String string2) {
        this(string, n, object, true, string2, false);
    }

    private LogConfigDialog(String string, int n, Object object, boolean bl, String string2, boolean bl2) {
        super(guiMain.getFrame(), string, true);
        this.computerID = n;
        this.name = object;
        this.isAgent = bl;
        this.isAudit = bl2;
        JComponent jComponent = (JComponent)this.getContentPane();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        this.lComboBox = new TComboBox(levelArray);
        this.mfSpinBox = new SpinBox(2, 2, 100, 1);
        this.mfsSpinBox = new SpinBox(128, 128, 102400, 128);
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.okButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_OK"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Insets insets = new Insets(4, 8, 4, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = insets;
        this.enableTrace = new JCheckBox(Util.getString("ADG0325L"));
        this.enableTrace.addActionListener(this);
        jPanel.add((Component)this.enableTrace, gridBagConstraints);
        if (this.isAudit) {
            this.label = new JLabel(Util.getString("ADG0312L"));
        } else {
            this.label = new JLabel(Util.getString("ADG0311L"));
            jPanel.add((Component)this.label, gridBagConstraints);
            jPanel.add((Component)this.lComboBox, gridBagConstraints2);
        }
        if (string2.equals("org.eclipse.aperi.server.svp.ServerSvp") || string2.equals("org.eclipse.aperi.agent.svp.AgentSvp") || string2.equals("org.eclipse.aperi.common.svp.AuditSvp")) {
            jPanel.add((Component)new JLabel(Util.getString("ADG0312L")), gridBagConstraints);
            jPanel.add((Component)this.mfSpinBox, gridBagConstraints2);
            jPanel.add((Component)new JLabel(Util.getString("ADG0313L")), gridBagConstraints);
            jPanel.add((Component)this.mfsSpinBox, gridBagConstraints2);
        }
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)jPanel, "Center");
        jComponent.add((Component)jPanel2, "South");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        String string3 = null;
        if (string2.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
            string3 = "assrv6";
        } else if (string2.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            string3 = "asag3";
        } else if (string2.equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
            string3 = "assrv25";
        } else if (string2.equals("org.eclipse.aperi.server.svp.CimomSvp")) {
            string3 = "assrv45";
        } else if (string2.equals("org.eclipse.aperi.server.svp.GuiSvp")) {
            string3 = "assrv35";
        } else if (string2.equals("org.eclipse.aperi.server.svp.AgentSvp")) {
            string3 = "assrv30";
        } else if (string2.equals("org.eclipse.aperi.common.svp.AuditSvp")) {
            string3 = "assrv6";
        }
        if (string3 != null) {
            Help.setHelpID(this.getRootPane(), string3);
        }
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        this.pack();
    }

    public void show(HashMap hashMap, String string) {
        this.serviceCode = string;
        this.setTracingConfig(hashMap);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.config.put("enableFlag", new Boolean(this.enableTrace.isSelected()));
            this.config.put("level", this.lComboBox.getSelectedItem());
            this.config.put("maxFiles", "" + this.mfSpinBox.getValue());
            this.config.put("maxFileSize", "" + this.mfsSpinBox.getValue() * 1000);
            Request request = new Request();
            if (this.isAgent) {
                ServerRequest.agentSetTracingConfig(request, this.computerID, this.config, this.serviceCode);
            } else if (this.isAudit) {
                ServerRequest.serverSetAuditConfig(request, this.config, this.serviceCode);
            } else {
                ServerRequest.serverSetTracingConfig(request, this.config, this.serviceCode);
            }
            GuiClient.doRequest(this, request);
        } else if (actionEvent.getSource() == this.enableTrace) {
            if (this.enableTrace.isSelected()) {
                this.label.setEnabled(true);
                this.lComboBox.setEnabled(true);
            } else {
                this.label.setEnabled(false);
                this.lComboBox.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.hide();
        }
    }

    private void setTracingConfig(HashMap hashMap) {
        this.config = hashMap;
        Boolean bl = (Boolean)this.config.get("enableFlag");
        String string = (String)this.config.get("level");
        String string2 = (String)this.config.get("maxFiles");
        String string3 = (String)this.config.get("maxFileSize");
        this.enableTrace.setSelected(bl);
        if (bl.booleanValue()) {
            this.label.setEnabled(true);
            this.lComboBox.setEnabled(true);
            this.lComboBox.setSelectedItem(string);
        } else {
            this.label.setEnabled(false);
            this.lComboBox.setEnabled(false);
        }
        this.mfSpinBox.setValue(Integer.parseInt(string2));
        this.mfsSpinBox.setValue(Integer.parseInt(string3) / 1000);
    }

    public void handleResponse(short s, Response response) {
        if (s != 0) {
            String string = null;
            string = this.isAgent ? MessageLog.getMessage("ADG0309E", this.name) : MessageLog.getMessage("ADG0316E");
            JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0307L"), 0);
        }
        this.hide();
    }
}

