/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import javax.swing.JPanel;

public abstract class AperiChartAdapter
extends JPanel {
    public static final int CHART_TYPE_HISTORY = 0;
    public static final int CHART_TYPE_PIE = 1;
    public static final int CHART_TYPE_BAR = 2;
    public static final int CHART_TYPE_STACKEDBAR = 3;
    public static final int CHART_SUBTYPE_EXPLOSIVE = 0;
    public static final int CHART_SUBTYPE_MULTICHART = 1;
    public static final int ORIENT_HORIZONTAL = 0;
    public static final int ORIENT_VERTICAL = 1;
    public static final int ANCHOR_NORTH = 0;
    public static final int ANCHOR_NORTH_EAST = 1;
    public static final int ANCHOR_EAST = 2;
    public static final int ANCHOR_SOUTH_EAST = 3;
    public static final int ANCHOR_SOUTH = 4;
    public static final int ANCHOR_SOUTH_WEST = 5;
    public static final int ANCHOR_WEST = 6;
    public static final int ANCHOR_NORTH_WEST = 7;
    public static final int SCALING_ABSOLUTE = 0;
    public static final int SCALING_PERCENT = 1;
    public static final int SCALING_LOGARITHMIC = 2;
    public static final int FORMAT_NONE = 0;
    public static final int FORMAT_BYTES = 1;
    public static final int FORMAT_DECIMAL = 2;
    public static final int FORMAT_MILLISECONDS = 3;
    public static final int FORMAT_DURATION = 4;
    public static final int FORMAT_DATETIME = 5;
    public static final int FORMAT_NUMBER = 6;
    public static final int FORMAT_TEXT = 7;
    public static final int FORMAT_PERCENT = 8;
    private int chartType = 1;
    private int chartSubtype = 0;
    private int chartOrientation = 1;
    private String chartTitle = "Chart";
    private boolean chartTitleVisible = true;
    private boolean legendVisible = true;
    private int legendOrientation = 0;
    private int legendAnchor = 4;
    private String yAxisTitleText = "Y Axis";
    private boolean yAxisTitleVisible = false;
    private int yAxisTitleOrientation = 1;
    private int yAxisScaling = 0;
    private int yValueFormat = 2;
    private boolean yValueLabelsVisible = true;
    private int yValueLabelsOrientation = 1;
    private boolean yValuePointsVisible = true;
    private String xAxisTitleText = "X Axis";
    private int xValueFormat = 2;
    private boolean xAxisTitleVisible = false;
    private int xAxisTitleOrientation = 0;
    private String[] ySeriesNames = null;
    private Number[][] ySeries = null;
    private Object[] xCategories = null;
    private double[][] yValues = null;
    private double[][] xValues = null;
    private boolean trendLineVisible = true;
    protected double[][] yTrend = null;
    protected double[][] xTrend = null;
    private int seriesOffset = 0;
    private int seriesPerChart = Integer.MAX_VALUE;
    private int categoryOffset = 0;
    private int chartsPerView = Integer.MAX_VALUE;

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int n) {
        this.checkChartType(n);
        this.chartType = n;
    }

    public int getChartOrientation() {
        return this.chartOrientation;
    }

    public void setChartOrientation(int n) {
        this.checkOrientation(n);
        this.chartOrientation = n;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public void setLegendVisible(boolean bl) {
        this.legendVisible = bl;
    }

    public int getLegendAnchor() {
        return this.legendAnchor;
    }

    public void setLegendAnchor(int n) {
        this.checkAnchor(n);
        this.legendAnchor = n;
    }

    public int getLegendOrientation() {
        return this.legendOrientation;
    }

    public void setLegendOrientation(int n) {
        this.checkOrientation(n);
        this.legendOrientation = n;
    }

    public String getXAxisTitleText() {
        return this.xAxisTitleText;
    }

    public void setXAxisTitleText(String string) {
        this.xAxisTitleText = string;
    }

    public boolean isXAxisTitleVisible() {
        return this.xAxisTitleVisible;
    }

    public void setXAxisTitleVisible(boolean bl) {
        this.xAxisTitleVisible = bl;
    }

    public String getYAxisTitleText() {
        return this.yAxisTitleText;
    }

    public void setYAxisTitleText(String string) {
        this.yAxisTitleText = string;
    }

    public boolean isYAxisTitleVisible() {
        return this.yAxisTitleVisible;
    }

    public void setYAxisTitleVisible(boolean bl) {
        this.yAxisTitleVisible = bl;
    }

    public Number[][] getYSeries() {
        return this.ySeries;
    }

    public void setYSeries(Number[][] numberArray) {
        if (this.getChartType() == 0) {
            throw new RuntimeException("Chart type must not be CHART_TYPE_HISTORY for category charts");
        }
        this.ySeries = numberArray;
    }

    public Object[] getXCategories() {
        return this.xCategories;
    }

    public void setXCategories(Object[] objectArray) {
        if (this.getChartType() == 0) {
            throw new RuntimeException("Chart type must not be CHART_TYPE_HISTORY for category charts");
        }
        this.xCategories = objectArray;
    }

    public String[] getYSeriesNames() {
        return this.ySeriesNames;
    }

    public void setYSeriesNames(String[] stringArray) {
        this.ySeriesNames = stringArray;
    }

    public int getYAxisScaling() {
        return this.yAxisScaling;
    }

    public void setYAxisScaling(int n) {
        this.yAxisScaling = n;
    }

    private void checkChartType(int n) {
        if (n < 0 || n > 3) {
            throw new RuntimeException("Bad Chart Type " + n);
        }
    }

    private void checkAnchor(int n) {
        if (n < 0 || n > 7) {
            throw new RuntimeException("Bad Chart Legend Anchor " + n);
        }
    }

    private void checkOrientation(int n) {
        if (n < 0 || n > 2) {
            throw new RuntimeException("Bad Orientation " + n);
        }
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void setChartTitle(String string) {
        this.chartTitle = string;
    }

    public boolean isChartTitleVisible() {
        return this.chartTitleVisible;
    }

    public void setChartTitleVisible(boolean bl) {
        this.chartTitleVisible = bl;
    }

    public int getYAxisTitleOrientation() {
        return this.yAxisTitleOrientation;
    }

    public void setYAxisTitleOrientation(int n) {
        this.yAxisTitleOrientation = n;
    }

    public int getXAxisTitleOrientation() {
        return this.xAxisTitleOrientation;
    }

    public void setXAxisTitleOrientation(int n) {
        this.xAxisTitleOrientation = n;
    }

    public boolean isYValueLabelsVisible() {
        return this.yValueLabelsVisible;
    }

    public void setYValueLabelsVisible(boolean bl) {
        this.yValueLabelsVisible = bl;
    }

    public boolean isYValuePointsVisible() {
        return this.yValuePointsVisible;
    }

    public void setYValuePointsVisible(boolean bl) {
        this.yValuePointsVisible = bl;
    }

    public int getYValueLabelsOrientation() {
        return this.yValueLabelsOrientation;
    }

    public void setYValueLabelsOrientation(int n) {
        this.yValueLabelsOrientation = n;
    }

    public int getYValueFormat() {
        return this.yValueFormat;
    }

    public void setYValueFormat(int n) {
        if (n < 0 || n > 8) {
            throw new RuntimeException("Bad value format " + n);
        }
        this.yValueFormat = n;
    }

    public int getXValueFormat() {
        return this.xValueFormat;
    }

    public void setXValueFormat(int n) {
        this.xValueFormat = n;
    }

    public double[][] getXValues() {
        return this.xValues;
    }

    public double[][] getYValues() {
        return this.yValues;
    }

    private void setXValues(double[][] dArray) {
        this.xValues = dArray;
    }

    private void setYValues(double[][] dArray) {
        this.yValues = dArray;
    }

    public void setXYValues(double[][] dArray, double[][] dArray2) {
        if (this.getChartType() != 0) {
            throw new RuntimeException("Chart type must be CHART_TYPE_HISTORY for (x,y) plot");
        }
        if (dArray == null || dArray2 == null) {
            throw new RuntimeException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new RuntimeException("X and Y vectors must be greater than zero length");
        }
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("X and Y series vectors must be the same length");
        }
        int n = 0;
        while (n < dArray.length) {
            if (!(dArray[n] instanceof double[]) || !(dArray2[n] instanceof double[])) {
                throw new RuntimeException("X and Y vectors must be of type Double[]");
            }
            if (dArray[n].length != dArray2[n].length) {
                throw new RuntimeException("Corresponding X and Y vector pairs must be the same length");
            }
            int n2 = 0;
            while (n2 < dArray[n].length) {
                if (dArray[n][n2] < 0.0 || dArray2[n][n2] < 0.0) {
                    throw new RuntimeException("Negatives not allowed in X or Y vectors");
                }
                ++n2;
            }
            ++n;
        }
        this.setXValues(dArray);
        this.setYValues(dArray2);
    }

    public boolean isTrendLineVisible() {
        return this.trendLineVisible;
    }

    public void setTrendLineVisible(boolean bl) {
        this.trendLineVisible = bl;
    }

    protected void createTrendValues() {
        if (this.getChartType() != 0) {
            throw new RuntimeException();
        }
        if (this.xValues == null || this.yValues == null) {
            throw new RuntimeException();
        }
        int n = this.getXValues().length;
        this.xTrend = new double[n][2];
        this.yTrend = new double[n][2];
        int n2 = 0;
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n3 = 0;
        while (n3 < n) {
            double d3;
            double d4;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n4 = 0;
            while (n4 < this.getXValues()[n3].length) {
                d4 = this.getXValues()[n3][n4];
                d3 = this.getYValues()[n3][n4];
                d5 += d4 * d4;
                d6 += d4 * d3;
                d7 += d4;
                d8 += d3;
                if (d4 < d) {
                    d = d4;
                }
                if (d4 > d2) {
                    d2 = d4;
                }
                ++n4;
            }
            if (n4 > n2) {
                n2 = n4;
            }
            if (n4 < 2) {
                this.xTrend[n3][0] = Double.MIN_VALUE;
                this.yTrend[n3][0] = Double.MIN_VALUE;
                this.xTrend[n3][1] = Double.MIN_VALUE;
                this.yTrend[n3][1] = Double.MIN_VALUE;
            } else {
                d4 = d5 - d7 * d7 / (double)n4;
                d3 = d6 - d7 * d8 / (double)n4;
                double d9 = d3 / d4;
                double d10 = (d8 - d9 * d7) / (double)n4;
                this.xTrend[n3][0] = this.getXValues()[n3][n4 - 1];
                this.yTrend[n3][0] = this.getYValues()[n3][n4 - 1];
                this.xTrend[n3][1] = this.getXValues()[n3][n4 - 1] + (this.getXValues()[n3][n4 - 1] - this.getXValues()[n3][0]) / 2.0;
                this.yTrend[n3][1] = d10 + d9 * this.xTrend[n3][1];
                if (this.yTrend[n3][1] < 0.0) {
                    double d11 = this.xTrend[n3][1] - this.xTrend[n3][0];
                    double d12 = this.yTrend[n3][1] - this.yTrend[n3][0];
                    double d13 = d11 / d12;
                    this.yTrend[n3][1] = 0.0;
                    this.xTrend[n3][1] = this.xTrend[n3][0] - d13 * this.yTrend[n3][0];
                }
            }
            ++n3;
        }
        if (n2 < 2 && d <= d2 && d2 < 8.64E7 + d) {
            d -= 8.64E7;
            d2 += 8.64E7;
        }
        n3 = 0;
        while (n3 < n) {
            if (this.xTrend[n3][0] == Double.MIN_VALUE) {
                this.xTrend[n3][0] = d;
            }
            if (this.xTrend[n3][1] == Double.MIN_VALUE) {
                this.xTrend[n3][1] = d2;
            }
            ++n3;
        }
    }

    public void setSeriesPerChart(int n, int n2) {
        this.seriesOffset = n;
        this.seriesPerChart = n2;
    }

    protected int getSeriesOffset() {
        return this.seriesOffset;
    }

    protected int getSeriesPerChart() {
        return this.seriesPerChart;
    }

    public void setChartsPerView(int n, int n2) {
        this.categoryOffset = n;
        this.chartsPerView = n2;
    }

    protected int getChartsPerView() {
        return this.chartsPerView;
    }

    protected int getCategoryOffset() {
        return this.categoryOffset;
    }

    public int getChartSubtype() {
        return this.chartSubtype;
    }

    public void setChartSubtype(int n) {
        if (this.getChartType() == 0) {
            throw new RuntimeException("Chart subtype cannot be applied to HISTORY charts");
        }
        if (n < 0 || n > 1) {
            throw new RuntimeException("Bad chart subtype " + n);
        }
        this.chartSubtype = n;
    }
}

