/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialogCallbackInterface;
import org.eclipse.aperi.xmsg.MessageLog;

public class AperiChartCustomizationDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_LENGTH_MAX = 96;
    private int docOffset;
    private JButton saveButton;
    private JButton defaultsButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel panel;
    private JComboBox maxCharts = null;
    private JComboBox maxPerChart = null;
    private JRadioButton hoverOnly = null;
    private JRadioButton textOnly = null;
    private ChartOptions defaultOptions;
    private ChartOptions newOptions;
    private Insets inset2 = new Insets(0, 26, 0, 0);
    private Insets insetL1 = new Insets(2, 12, 2, 8);
    private JRadioButton typePie = null;
    private JRadioButton typeBar = null;
    private JRadioButton typeStacked = null;
    private JRadioButton typeStacked100 = null;
    private JRadioButton orientHoriz = null;
    private JRadioButton orientVert = null;
    private JCheckBox showTrends;
    private JTextField titleField;
    private boolean maxChartsEnabled;
    private boolean maxPerChartEnabled;
    private boolean hoverOnlyEnabled;
    private boolean chartTypeEnabled;
    private boolean historyEnabled;
    private AperiChartCustomizationDialogCallbackInterface customizableChart;

    public AperiChartCustomizationDialog(Frame frame, AperiChartCustomizationDialogCallbackInterface aperiChartCustomizationDialogCallbackInterface, String string, String string2, ChartOptions chartOptions, ChartOptions chartOptions2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(frame, string, true);
        this.defaultOptions = chartOptions2;
        this.newOptions = (ChartOptions)chartOptions.clone();
        this.setMaxChartsEnabled(bl);
        this.setHoverOnlyEnabled(bl2);
        this.setChartTypeEnabled(bl3);
        this.setMaxPerChartEnabled(bl4);
        this.setHistoryEnabled(bl5);
        this.setCustomizableChart(aperiChartCustomizationDialogCallbackInterface);
        this.configureHelp(string2);
        this.getContentPane().add(this.getMainPanel());
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.defaultsButton) {
            this.displayDefaults();
        }
        if (object == this.applyButton) {
            this.applyChanges();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.saveButton || object == this.okButton) {
            this.applyChanges();
            this.saveChanges();
            this.dispose();
        } else if (object == this.maxCharts) {
            this.newOptions.chartsPerView = this.maxCharts.getSelectedIndex() + 1;
        } else if (object == this.maxPerChart) {
            this.newOptions.seriesPerChart = this.maxPerChart.getSelectedIndex() + 1;
        } else if (object == this.hoverOnly || object == this.textOnly) {
            this.newOptions.hoverText = !this.textOnly.isSelected();
        } else if (object == this.typePie) {
            this.newOptions.chartType = 1;
            this.orientVert.setEnabled(false);
            this.orientHoriz.setEnabled(false);
        } else if (object == this.typeBar || object == this.typeStacked || object == this.typeStacked100 || object == this.orientHoriz || object == this.orientVert) {
            this.setGraphType();
        } else if (object == this.showTrends) {
            this.newOptions.trends = this.showTrends.isSelected();
        }
    }

    private boolean isHoverOnlyEnabled() {
        return this.hoverOnlyEnabled;
    }

    private void setHoverOnlyEnabled(boolean bl) {
        this.hoverOnlyEnabled = bl;
    }

    private JPanel getMainPanel() {
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        JTextArea jTextArea = new JTextArea(Util.getString("DESC_CHART_CUST_INSTRUCTIONS"));
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEditable(false);
        gridBagConstraints.insets = new Insets(5, 12, 2, 8);
        this.panel.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 12, 1, 8);
        this.panel.add((Component)this.getTitlePanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.getMaxChartsPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.getHoverPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.getGraphPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.getHistPanel(), gridBagConstraints);
        this.defaultsButton = new JButton(Util.getString("RESTORE_DEFAULTS"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 12, 1, 8);
        this.panel.add((Component)this.defaultsButton, gridBagConstraints);
        this.defaultsButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 12, 1, 8);
        this.panel.add((Component)this.getButtonPanel(), gridBagConstraints);
        return this.panel;
    }

    private void displayDefaults() {
        this.newOptions = (ChartOptions)this.defaultOptions.clone();
        if (this.maxCharts.isEnabled()) {
            this.maxCharts.setSelectedIndex(this.newOptions.chartsPerView - 1);
        }
        if (this.maxPerChart.isEnabled()) {
            this.maxPerChart.setSelectedIndex(this.newOptions.seriesPerChart - 2);
        }
        this.hoverOnly.setSelected(this.newOptions.hoverText);
        this.displayGraphType(this.newOptions.chartType);
        if (this.showTrends.isEnabled()) {
            this.showTrends.setSelected(this.newOptions.trends);
        }
        this.titleField.setText(this.newOptions.title);
    }

    private void saveChanges() {
        this.newOptions.title = this.titleField.getText();
        this.getCustomizableChart().saveCustomOptions(this.newOptions);
    }

    private void applyChanges() {
        this.newOptions.title = this.titleField.getText();
        this.getCustomizableChart().setCustomOptions(this.newOptions);
    }

    private GridBagPanel getButtonPanel() {
        this.saveButton = new JButton(Util.getString("LABEL_SAVE"));
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.applyButton = new JButton(Util.getString("LABEL_APPLY"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.getRootPane().setDefaultButton(this.saveButton);
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.add(this.applyButton, -1, 0, 1, 1, 22, 0, new Insets(4, 4, 4, 4));
        gridBagPanel.add(this.saveButton, -1, 1, 1, 1, 22, 0, new Insets(4, 4, 4, 4));
        gridBagPanel.add(this.cancelButton, -1, 2, 1, 1, 22, 0, new Insets(4, 4, 4, 4));
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.okButton.addActionListener(this);
        return gridBagPanel;
    }

    private JPanel getTitlePanel() {
        Insets insets;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(4, 12, 4, 8);
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(Util.getString("CHART_TITLE"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.titleField = new JTextField(new SizeLimitedDocument(96, false), this.newOptions.title, 0);
        if (!this.defaultOptions.isTitleCustomizable) {
            this.titleField.setEditable(false);
        } else {
            this.titleField.getDocument().addDocumentListener(this);
        }
        jPanel.add((Component)this.titleField, gridBagConstraints);
        jLabel.setLabelFor(this.titleField);
        return jPanel;
    }

    private JPanel getMaxChartsPanel() {
        Insets insets;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(1, 12, 1, 8);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(Util.getString("MAX_NUM_CHARTS"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.maxCharts = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"});
        jLabel.setLabelFor(this.maxCharts);
        this.maxCharts.setEnabled(this.isMaxChartsEnabled());
        this.maxCharts.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.maxCharts, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel2 = new JLabel(Util.getString("MAX_NUM_SERIES"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.maxPerChart = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"});
        jLabel2.setLabelFor(this.maxPerChart);
        this.maxPerChart.setEnabled(this.isMaxPerChartEnabled());
        this.maxPerChart.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.maxPerChart, gridBagConstraints);
        return jPanel;
    }

    private JPanel getHoverPanel() {
        Insets insets;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(1, 12, 1, 8);
        gridBagConstraints.anchor = 17;
        this.hoverOnly = new JRadioButton(Util.getString("HOVER_ONLY"));
        gridBagConstraints.weightx = 1.0;
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel jLabel = new JLabel(Util.getString("SHOW_VALUES"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        gridBagConstraints.gridy = 1;
        this.textOnly = new JRadioButton(Util.getString("ALWAYS"));
        jLabel.setLabelFor(this.hoverOnly);
        jPanel.add((Component)this.hoverOnly, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.textOnly, gridBagConstraints);
        buttonGroup.add(this.hoverOnly);
        buttonGroup.add(this.textOnly);
        if (this.isHoverOnlyEnabled()) {
            this.hoverOnly.setEnabled(true);
            this.textOnly.setEnabled(true);
            if (this.newOptions.hoverText) {
                this.textOnly.setSelected(false);
                this.hoverOnly.setSelected(true);
            } else {
                this.textOnly.setSelected(true);
                this.hoverOnly.setSelected(false);
            }
        } else {
            this.hoverOnly.setEnabled(false);
            this.textOnly.setEnabled(false);
        }
        this.hoverOnly.addActionListener(this);
        this.textOnly.addActionListener(this);
        return jPanel;
    }

    private JPanel getGraphPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 12, 1, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        jPanel.setBorder(GuiUtil.getBorder(Util.getString("GRAPH_CHARTS")));
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JLabel jLabel = new JLabel(Util.getString("CHART_TYPE"));
        jLabel.setLabelFor(this.typePie);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.typePie = new JRadioButton(MessageLog.getMessageNoID("STG1261T"));
        this.typeBar = new JRadioButton(MessageLog.getMessageNoID("STG1262T"));
        this.typeStacked = new JRadioButton(MessageLog.getMessageNoID("STG1264T"));
        this.typeStacked100 = new JRadioButton(MessageLog.getMessageNoID("STG1265T"));
        if (!this.isChartTypeEnabled()) {
            this.typePie.setEnabled(false);
            this.typeBar.setEnabled(false);
            this.typeStacked.setEnabled(false);
            this.typeStacked100.setEnabled(false);
        } else {
            this.typePie.addActionListener(this);
            this.typeBar.addActionListener(this);
            this.typeStacked.addActionListener(this);
            this.typeStacked100.addActionListener(this);
            buttonGroup.add(this.typePie);
            buttonGroup.add(this.typeBar);
            buttonGroup.add(this.typeStacked);
            buttonGroup.add(this.typeStacked100);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = this.inset2;
        jPanel.add((Component)this.typePie, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.typeBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.typeStacked, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.typeStacked100, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = this.insetL1;
        jLabel = new JLabel(Util.getString("CHART_ORIENTATION"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = this.inset2;
        this.orientHoriz = new JRadioButton(Util.getString("HORIZONTAL"));
        this.orientVert = new JRadioButton(Util.getString("VERTICAL"));
        jLabel.setLabelFor(this.orientHoriz);
        if (this.isChartTypeEnabled()) {
            this.orientHoriz.addActionListener(this);
            this.orientVert.addActionListener(this);
            buttonGroup2.add(this.orientHoriz);
            buttonGroup2.add(this.orientVert);
        } else {
            this.orientHoriz.setEnabled(false);
            this.orientVert.setEnabled(false);
        }
        switch (this.newOptions.chartType) {
            case 2: {
                buttonGroup.setSelected(this.typeBar.getModel(), true);
                buttonGroup2.setSelected(this.orientHoriz.getModel(), true);
                break;
            }
            case 3: {
                buttonGroup.setSelected(this.typeBar.getModel(), true);
                buttonGroup2.setSelected(this.orientVert.getModel(), true);
                break;
            }
            case 1: {
                buttonGroup.setSelected(this.typePie.getModel(), true);
                buttonGroup2.setSelected(this.orientHoriz.getModel(), true);
                this.orientVert.setEnabled(false);
                this.orientHoriz.setEnabled(false);
                break;
            }
            case 4: {
                buttonGroup.setSelected(this.typeStacked.getModel(), true);
                buttonGroup2.setSelected(this.orientHoriz.getModel(), true);
                break;
            }
            case 5: {
                buttonGroup.setSelected(this.typeStacked.getModel(), true);
                buttonGroup2.setSelected(this.orientVert.getModel(), true);
                break;
            }
            case 6: {
                buttonGroup.setSelected(this.typeStacked100.getModel(), true);
                buttonGroup2.setSelected(this.orientHoriz.getModel(), true);
                break;
            }
            case 7: {
                buttonGroup.setSelected(this.typeStacked100.getModel(), true);
                buttonGroup2.setSelected(this.orientVert.getModel(), true);
            }
        }
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.orientHoriz, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.orientVert, gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    private void setGraphType() {
        int n;
        int n2 = n = this.orientVert.isSelected() ? 1 : 0;
        if (this.typeBar.getModel().isSelected()) {
            this.newOptions.chartType = 2 + n;
        }
        if (this.typeStacked.getModel().isSelected()) {
            this.newOptions.chartType = 4 + n;
        }
        if (this.typeStacked100.getModel().isSelected()) {
            this.newOptions.chartType = 6 + n;
        }
        this.orientVert.setEnabled(true);
        this.orientHoriz.setEnabled(true);
    }

    private void displayGraphType(int n) {
        this.orientHoriz.setSelected(true);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.typePie.getModel().setSelected(true);
                break;
            }
            case 2: {
                this.typeBar.getModel().setSelected(true);
                this.orientHoriz.setSelected(true);
                break;
            }
            case 3: {
                this.typeBar.getModel().setSelected(true);
                break;
            }
            case 4: {
                this.typeStacked.getModel().setSelected(true);
                this.orientHoriz.setSelected(true);
                break;
            }
            case 5: {
                this.typeStacked.getModel().setSelected(true);
                break;
            }
            case 6: {
                this.typeStacked100.getModel().setSelected(true);
                this.orientHoriz.setSelected(true);
                break;
            }
            case 7: {
                this.typeStacked100.getModel().setSelected(true);
            }
        }
    }

    private JPanel getHistPanel() {
        Insets insets;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(2, 12, 2, 8);
        gridBagConstraints.anchor = 17;
        jPanel.setBorder(GuiUtil.getBorder(Util.getString("HISTORY_CHARTS")));
        this.showTrends = new JCheckBox(MessageLog.getMessageNoID("STG2095T"));
        jPanel.add((Component)this.showTrends, gridBagConstraints);
        if (!this.isHistoryEnabled()) {
            this.showTrends.setEnabled(false);
        } else {
            this.showTrends.setSelected(this.newOptions.trends);
            this.showTrends.addActionListener(this);
        }
        gridBagConstraints.gridy = 1;
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkForUndoEvent(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkForUndoEvent(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    private void checkForUndoEvent(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() > 96) {
            this.docOffset = documentEvent.getOffset();
            EventQueue eventQueue = new EventQueue();
            eventQueue.postEvent(new UndoEvent());
        }
    }

    private void configureHelp(String string) {
        if (string != null) {
            Help.setHelpID(this.getRootPane(), string);
            this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
            this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        }
    }

    private boolean isMaxChartsEnabled() {
        return this.maxChartsEnabled;
    }

    private void setMaxChartsEnabled(boolean bl) {
        this.maxChartsEnabled = bl;
    }

    private boolean isChartTypeEnabled() {
        return this.chartTypeEnabled;
    }

    private void setChartTypeEnabled(boolean bl) {
        this.chartTypeEnabled = bl;
    }

    private boolean isMaxPerChartEnabled() {
        return this.maxPerChartEnabled;
    }

    private void setMaxPerChartEnabled(boolean bl) {
        this.maxPerChartEnabled = bl;
    }

    private boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    private void setHistoryEnabled(boolean bl) {
        this.historyEnabled = bl;
    }

    private AperiChartCustomizationDialogCallbackInterface getCustomizableChart() {
        return this.customizableChart;
    }

    private void setCustomizableChart(AperiChartCustomizationDialogCallbackInterface aperiChartCustomizationDialogCallbackInterface) {
        this.customizableChart = aperiChartCustomizationDialogCallbackInterface;
    }

    private class UndoEvent
    extends AWTEvent
    implements ActiveEvent {
        private static final long serialVersionUID = 1L;

        public UndoEvent() {
            super(new Object(), 2000);
        }

        public void dispatch() {
            try {
                AperiChartCustomizationDialog.this.titleField.getDocument().remove(AperiChartCustomizationDialog.this.docOffset, 1);
                AperiChartCustomizationDialog.this.titleField.setCaretPosition(AperiChartCustomizationDialog.this.docOffset);
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

