/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.CIMOMMgmtAddCIMOMDialog;
import org.eclipse.aperi.gui.common.CIMOMMgmtAgentTreeNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class CIMOMMgmtAgentTreeLabel
extends BaseTreeNode {
    public CIMOMMgmtAgentTreeLabel() {
        super(Util.getString("CIMOM_MGMT_LABEL"));
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        this.launchCIMOMCollector();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            JPopupMenu jPopupMenu = this.getPopupMenu();
            jPopupMenu.add(this.refreshMenu());
            jPopupMenu.add(this.addCIMOMMenu());
            this.showPopupMenu(jPopupMenu, mouseEvent);
        }
    }

    private JMenuItem addCIMOMMenu() {
        JMenuItem jMenuItem = new JMenuItem(Util.getString("CIMOM_MGMT_ADD"));
        jMenuItem.setToolTipText(Util.getString("CIMOM_MGMT_ADD_TIP"));
        final CIMOMMgmtAgentTreeLabel cIMOMMgmtAgentTreeLabel = this;
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new CIMOMMgmtAddCIMOMDialog(CIMOMMgmtAgentTreeLabel.access$0().getFrame(), Util.getString("CIMOM_MGMT_ADD_TITLE"), cIMOMMgmtAgentTreeLabel);
            }
        });
        jMenuItem.setEnabled(this.capabilities.isAperiAdmin());
        return jMenuItem;
    }

    private JMenuItem refreshMenu() {
        JMenuItem jMenuItem = new JMenuItem(MessageLog.getMessageNoID("ADG0003L"));
        jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CIMOMMgmtAgentTreeLabel.this.launchCIMOMCollector();
            }
        });
        return jMenuItem;
    }

    private void launchCIMOMCollector() {
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtGetCIMOMsHandler");
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    CIMOMMgmtAgentTreeLabel.this.buildCIMOMList((CIMOM[])response.responseData);
                }
            }
        }, request);
    }

    public void buildCIMOMList(CIMOM[] cIMOMArray) {
        HashMap hashMap = this.cleanAndRemoveChildren();
        this.addAndRenewChildren(cIMOMArray, hashMap);
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    private void addAndRenewChildren(CIMOM[] cIMOMArray, HashMap hashMap) {
        int n = 0;
        while (n < cIMOMArray.length) {
            CIMOMMgmtAgentTreeNode cIMOMMgmtAgentTreeNode = new CIMOMMgmtAgentTreeNode(cIMOMArray[n]);
            cIMOMMgmtAgentTreeNode.setState(hashMap.get(cIMOMMgmtAgentTreeNode.getUniqueID()));
            this.addSorted(cIMOMMgmtAgentTreeNode);
            ++n;
        }
    }

    private HashMap cleanAndRemoveChildren() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                CIMOMMgmtAgentTreeNode cIMOMMgmtAgentTreeNode = (CIMOMMgmtAgentTreeNode)iterator.next();
                hashMap.put(cIMOMMgmtAgentTreeNode.getUniqueID(), cIMOMMgmtAgentTreeNode.getState());
                cIMOMMgmtAgentTreeNode.cleanYourself();
            }
            this.removeAllChildren();
        }
        return hashMap;
    }

    static /* synthetic */ IGuiMain access$0() {
        return BaseTreeNode.guiMain;
    }
}

