/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.jobs;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryRunDDI;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.fabric.jobs.FabricJobsNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class FabricJobsHelper
implements GuiRequestor,
NameListToTreeNode {
    private FabricJobsNode jobNode;
    private int scheduleID;
    private String description;

    public FabricJobsHelper(FabricJobsNode fabricJobsNode, String string, int n) {
        this.jobNode = fabricJobsNode;
        this.description = string;
        this.scheduleID = n;
    }

    public void sendRequest() {
        SchHistoryRequestNode schHistoryRequestNode = new SchHistoryRequestNode();
        schHistoryRequestNode.queryType = 1;
        schHistoryRequestNode.queryID = this.scheduleID;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler";
        request.requestData = schHistoryRequestNode;
        GuiClient.doRequest(this, request);
    }

    public void sendUpdateRequest() {
        SchHistoryRequestNode schHistoryRequestNode = new SchHistoryRequestNode();
        Request request = new Request();
        schHistoryRequestNode.queryID = this.scheduleID;
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.UpdateJobStatusHndlr";
        request.requestData = schHistoryRequestNode;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        this.jobNode.refresh(response, this);
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        Enumeration<TreeNode> enumeration = this.jobNode.children();
        while (enumeration.hasMoreElements()) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)enumeration.nextElement();
            DataDisplayInfo dataDisplayInfo2 = baseTreeNode.ddi;
            if (dataDisplayInfo2 == null) continue;
            dataDisplayInfo2.nullOutPanel();
            if (dataDisplayInfo2 != dataDisplayInfo) continue;
            dataDisplayInfo2.reDisplay();
        }
    }

    public void makeRunDDI() {
        Object[] objectArray = new Object[]{this.description};
        String string = MessageLog.getMessageNoID("JSS1000L", objectArray);
        new EditableObjectHistoryRunDDI(this.scheduleID, this.jobNode, string);
    }

    public BaseTreeNode makeChild(NameList nameList) {
        return new EditableObjectHistoryNode(nameList, this.description){};
    }

    public int getKey(NameList nameList) {
        return nameList.nlID2;
    }
}

