/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetTablePanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneTablePanel;

public class ZoneDefinitionPanel
extends JPanel
implements ActionListener {
    protected ZoneCNS zoneCNS = null;
    private JButton activateButton = new JButton(FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"));
    private JButton updateButton = new JButton(FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"));
    private boolean closeNow = false;
    private ZoneTablePanel zoneTable;
    private ZoneSetTablePanel zoneSetTable;
    private String sanWWN = null;
    private String sanLabel = null;

    public ZoneDefinitionPanel(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createButtonPanel(), "North");
        this.add((Component)this.createTablesPanel(), "Center");
        this.activateButton.addActionListener(this);
        this.updateButton.addActionListener(this);
    }

    private JPanel createTablesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.zoneTable = new ZoneTablePanel(this.zoneCNS);
        this.zoneSetTable = new ZoneSetTablePanel(this.zoneCNS);
        jPanel.add((Component)this.zoneSetTable, "North");
        jPanel.add((Component)this.zoneTable, "Center");
        return jPanel;
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        GuiUtil.setAccessible(this.activateButton, FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"), FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"));
        this.activateButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricButtonMnemonic_updateAndActivate")));
        jPanel.add(this.activateButton);
        if (this.zoneCNS.getZoneCapabilities().isSupportsFullZoneDB()) {
            GuiUtil.setAccessible(this.updateButton, FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"), FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"));
            this.updateButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricButtonMnemonic_updateOnly")));
            jPanel.add(this.updateButton);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(Util.getString("FabricZone_DisplayZones")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    public void refreshDefPanel() {
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.zoneTable.refreshTable(this.zoneCNS);
        this.zoneSetTable.refreshTable(this.zoneCNS);
        this.repaint();
    }

    public String getSanWWN() {
        return this.sanWWN;
    }

    public String getSanLabel() {
        return this.sanLabel;
    }

    public void setCloseNow(boolean bl) {
        this.closeNow = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.activateButton) {
            if (this.zoneCNS.hasAnyZoneError() || this.zoneCNS.hasAnyZoneSetError()) {
                this.displayZoneDefError();
                return;
            }
            this.zoneCNS.saveZoneDef(this, 1);
        } else if (object == this.updateButton) {
            if (this.zoneCNS.hasAnyZoneError() || this.zoneCNS.hasAnyZoneSetError()) {
                this.displayZoneDefError();
                return;
            }
            this.zoneCNS.saveZoneDef(this, 0);
        }
    }

    private int promptForSaveAction() {
        int n = 1;
        if (this.zoneCNS.getZoneCapabilities().isSupportsFullZoneDB()) {
            Object[] objectArray = new Object[]{FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"), FabricGuiUtil.getString("FabricZoneNotebook_updateOnly"), FabricGuiUtil.getString("FabricButton_Cancel")};
            int n2 = JOptionPane.showOptionDialog(this, String.valueOf(FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_ua")) + FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_u") + FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_c"), FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestionTitle"), -1, 2, null, objectArray, objectArray[0]);
            if (n2 == 2) {
                n = 9;
            } else if (n2 == 1) {
                n = 0;
            }
        } else {
            Object[] objectArray = new Object[]{FabricGuiUtil.getString("FabricZoneNotebook_updateAndActivate"), FabricGuiUtil.getString("FabricButton_Cancel")};
            n = JOptionPane.showOptionDialog(this, String.valueOf(FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_ua")) + FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestion_c"), FabricGuiUtil.getString("FabricZoneNotebook_applyToActiveQuestionTitle"), -1, 2, null, objectArray, objectArray[0]);
            if (n == 1) {
                n = 9;
            }
        }
        return n;
    }

    public boolean closeNow() {
        return this.closeNow;
    }

    private void displayZoneDefError() {
        String string = Util.getString("FabricZoneNotebook_IncorrectZoningConfig");
        JOptionPane.showMessageDialog(this, string);
    }

    public void cleanOnExit() {
        if (!this.closeNow) {
            this.zoneCNS.cleanBeforeWindowClosing();
        }
    }
}

