/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.AssignZonesStep;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetNameDescriptionStep;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneSetWizard
extends Wizard {
    private ZoneCNS zoneCNS;
    private AssignZonesStep assignZonesStep = null;
    private ZoneSetNameDescriptionStep nameDescStep = null;
    private int NO_BACK_WIZARD_FLAGS = 26;
    private int NO_NEXT_WIZARD_FLAGS = 29;
    private ZoneSet zs = null;
    private ZoneSet origZS = null;
    private Zone[] zonesInZS = null;
    private boolean duplicate = false;
    private boolean isActive = false;
    private boolean isOrigActive = false;
    private boolean isEditZS = false;

    public ZoneSetWizard(ZoneSet zoneSet, ZoneCNS zoneCNS, boolean bl, boolean bl2) {
        this.zoneCNS = zoneCNS;
        if (bl2) {
            this.isActive = this.zoneCNS.isZoneSetActive(zoneSet);
        }
        if (bl2) {
            this.isOrigActive = this.zoneCNS.isOriginalActiveZoneSet(zoneSet);
        }
        this.zs = zoneSet;
        this.duplicate = bl;
        this.isEditZS = bl2;
        this.origZS = zoneSet;
        if (this.duplicate) {
            String string = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_ZoneSetNameCopy"), new Object[]{zoneSet.getName()});
            this.zs = new ZoneSet(string.trim());
            this.zs.setDescription(zoneSet.getDescription());
        }
        this.zonesInZS = this.zoneCNS.getZones(zoneSet);
        this.addWizardListener(this);
        this.nameDescStep = new ZoneSetNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, false, this.zs.getName(), this.zs.getDescription());
        this.add(this.nameDescStep);
        this.assignZonesStep = new AssignZonesStep(this.NO_NEXT_WIZARD_FLAGS, this.zs, this.zoneCNS, this.zonesInZS);
        this.add(this.assignZonesStep);
    }

    public ZoneSetWizard(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        this.zs = new ZoneSet("");
        this.addWizardListener(this);
        this.nameDescStep = new ZoneSetNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, true, this.zs.getName(), this.zs.getDescription());
        this.add(this.nameDescStep);
        this.assignZonesStep = new AssignZonesStep(this.NO_NEXT_WIZARD_FLAGS, this.zs, this.zoneCNS, this.zonesInZS);
        this.add(this.assignZonesStep);
    }

    public boolean hasZoneSet(String string) {
        return this.zoneCNS.containsZoneSet(string);
    }

    public boolean isSupportsSameZoneSetAndZoneName() {
        return this.zoneCNS.getZoneCapabilities().isSupportsSameZoneSetAndZoneName();
    }

    public boolean hasZone(String string) {
        return this.zoneCNS.getZone(string) != null;
    }

    public String checkZSNameString(String string) {
        String string2 = null;
        if (string.indexOf(32) != -1) {
            return Util.getString("FMSG_FabricZoneSetFrame_BadCharZoneSetNameErrorMsg");
        }
        if (!this.zoneCNS.getZoneCapabilities().isAllowsNumericNameStart() && this.zoneCNS.isNum(string.charAt(0))) {
            string2 = Util.getString("FabricZoneSetFrame_NumericalZoneSetNameErrorMsg");
            return string2;
        }
        if (!this.zoneCNS.getZoneCapabilities().isSupportsSpecialCharacters() && this.zoneCNS.isUnsupportedChar(string)) {
            string2 = Util.getString("FMSG_FabricZoneSetFrame_BadCharZoneSetNameErrorMsg");
            return string2;
        }
        if (this.zoneCNS.containsZoneSet(string) && !this.isEditZS) {
            string2 = Util.getString("FabricZoneSetFrame_DuplicateZoneSetNameErrorMsg");
        }
        return string2;
    }

    public void setZSNameDesc(String string, String string2) {
        this.zs = new ZoneSet(string);
        this.zs.setDescription(string2);
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void nextBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.nameDescStep) {
            wizardEvent.setNewPage(this.assignZonesStep);
        }
    }

    public void finished(WizardEvent wizardEvent) {
        block8: {
            Vector vector;
            block10: {
                ArrayList arrayList;
                block9: {
                    super.finished(wizardEvent);
                    if ((WizardPage)wizardEvent.getCurrentPage() != this.assignZonesStep) break block8;
                    if (!this.duplicate || this.isEditZS) {
                        this.zoneCNS.deleteZoneSet(this.origZS);
                    }
                    if ((arrayList = this.assignZonesStep.getSelectedList()) != null && !arrayList.isEmpty()) break block9;
                    int n = JOptionPane.showConfirmDialog(this, Util.getString("FabricZoneSetFrame_ZoneNotAssignedWarningMsg"), Util.getString("FabricZoneSetFrame_ZoneSetConfigurationErrorTitle"), 0);
                    if (n != 0) break block10;
                    this.zoneCNS.addZoneSetConfigError(this.zs.getName());
                    this.zoneCNS.addZoneSet(this.zs);
                    if (this.isActive) {
                        this.zoneCNS.activateZoneSet(this.zs);
                    }
                    if (!this.isOrigActive) break block10;
                    this.zoneCNS.setOriginalActivatedZoneSet(this.zs);
                    break block10;
                }
                Integer n = new Integer(this.zoneCNS.getZoneCapabilities().getMaxZonesInSet());
                Integer n2 = new Integer(arrayList.size());
                if (!n.equals(new Integer(-1)) && n2 > n) {
                    Object[] objectArray = new Integer[]{n2, n};
                    String string = IntlMessageFormat.format(Util.getString("FabricZoneFrame_MaxZonesInSet"), objectArray);
                    JOptionPane.showMessageDialog(this, string);
                    return;
                }
                this.zoneCNS.addZoneSet(this.zs);
                if (this.isActive) {
                    this.zoneCNS.activateZoneSet(this.zs);
                }
                if (this.isOrigActive) {
                    this.zoneCNS.setOriginalActivatedZoneSet(this.zs);
                }
                this.zoneCNS.removeZoneSetConfigError(this.zs.getName());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Zone zone = this.zoneCNS.getZone((String)iterator.next());
                    if (zone == null) continue;
                    this.zoneCNS.addZone(zone, this.zs);
                    this.zoneCNS.removeZoneConfigError(zone.getName());
                }
            }
            if (!this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones() && (vector = this.zoneCNS.checkForOrphanZones()) != null && vector.size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    this.zoneCNS.addZoneConfigError(((Zone)vector.get(n)).getName());
                    ++n;
                }
            }
            this.zoneCNS.refreshDefinitionPanel();
            this.closeWizard();
        }
    }

    public void canceled(WizardEvent wizardEvent) {
        super.canceled(wizardEvent);
        this.closeWizard();
    }

    private void closeWizard() {
        JDialog jDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        jDialog.dispose();
    }
}

