/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.ioports;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.tape.common.TapeLocation;
import org.eclipse.aperi.gui.tape.common.model.GUIIOPort;
import org.eclipse.aperi.gui.tape.ioports.IOPortsDDI;

public class IOPortsTableModel
extends BaseTableModel {
    private IOPortsDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_IOPORTS_LABEL"), Util.getString("TAPE_EXTENDED_LABEL"), Util.getString("TAPE_DESCRIPTION_LABEL"), Util.getString("TAPE_LOCATION_LABEL"), Util.getString("TAPEMEDIATYPESSUPPORTED"), Util.getString("TAPE_CARTRIDGE_LABEL_LABEL")};
    private static final int LIB_NAME = 0;
    private static final int LIB_EXT = 1;
    private static final int LIB_DESC = 2;
    private static final int LIB_LOC = 3;
    private static final int LIB_MEDIA_TYPE = 4;
    private static final int LIB_CARTRIDGE_LABEL = 5;

    IOPortsTableModel(IOPortsDDI iOPortsDDI) {
        this.aDDI = iOPortsDDI;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getIoPorts().size();
    }

    public Object getTableDataItem(int n, int n2) {
        GUIIOPort gUIIOPort = (GUIIOPort)this.aDDI.getIoPorts().elementAt(n);
        switch (n2) {
            case 0: {
                return gUIIOPort.getName();
            }
            case 1: {
                if (!gUIIOPort.isExtended()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 2: {
                return gUIIOPort.getDescription();
            }
            case 3: {
                return new TapeLocation(gUIIOPort.getLocation());
            }
            case 4: {
                return gUIIOPort.getMediaTypeSupported();
            }
            case 5: {
                return gUIIOPort.getCartridge_Label();
            }
        }
        return "";
    }
}

