/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;

public class GraphDebug {
    public static final String VM_PROP = "TopologyViewerDebug";
    public static final String VM_PROP2 = "TopologyViewerDebugOutputFile";
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_TEMPORARY = 3;
    public static final int LEVEL_HIGHLIGHT = 4;
    public static final int LEVEL_INFO = 5;
    public static final int LEVEL_TRACE = 6;
    public static String[] PREFIX = new String[]{"[OFF]", "[ERROR]", "[WARNING]", "[TEMPORARY]", "[HIGHLIGHT]", "[INFO]", "[TRACE]"};
    public static int current_level = 2;
    public static PrintWriter pw;

    static {
        try {
            String string;
            String string2 = System.getProperty(VM_PROP);
            if (string2 != null) {
                current_level = Integer.parseInt(string2);
            }
            if ((string = System.getProperty(VM_PROP2)) != null) {
                pw = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int getCurrentLevel() {
        return current_level;
    }

    public static void setCurrentLevel(int n) {
        current_level = n;
    }

    private static void template(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date(System.currentTimeMillis());
        stringBuffer.append(date.toString());
        stringBuffer.append(" ");
        stringBuffer.append(PREFIX[n]);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
        if (pw != null) {
            try {
                pw.println(stringBuffer.toString());
                pw.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void template(int n, Throwable throwable) {
        throwable.printStackTrace(System.out);
        if (pw != null) {
            throwable.printStackTrace(pw);
        }
    }

    public static boolean isErrorVisible() {
        return 1 <= current_level;
    }

    public static void error(String string) {
        if (GraphDebug.isErrorVisible()) {
            GraphDebug.template(1, string);
        }
    }

    public static boolean isWarningVisible() {
        return 2 <= current_level;
    }

    public static void warning(String string) {
        if (GraphDebug.isWarningVisible()) {
            GraphDebug.template(2, string);
        }
    }

    public static boolean isTemporaryVisible() {
        return 3 <= current_level;
    }

    public static void temporary(String string) {
        if (GraphDebug.isTemporaryVisible()) {
            GraphDebug.template(3, string);
        }
    }

    public static boolean isHighlightVisible() {
        return 4 <= current_level;
    }

    public static void highlight(String string) {
        if (GraphDebug.isHighlightVisible()) {
            GraphDebug.template(4, string);
        }
    }

    public static boolean isInfoVisible() {
        return 5 <= current_level;
    }

    public static void info(String string) {
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.template(5, string);
        }
    }

    public static boolean isTraceVisible() {
        return 6 <= current_level;
    }

    public static void trace(String string) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.template(6, string);
        }
    }

    public static void throwable(Throwable throwable) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.template(6, throwable);
        }
    }

    public static void exception(Throwable throwable) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.template(6, throwable);
        }
    }
}

