/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;
import org.eclipse.aperi.gui.topo.widget.JTopoTableComputer;
import org.eclipse.aperi.gui.topo.widget.JTopoTableOther;
import org.eclipse.aperi.gui.topo.widget.JTopoTableSubsystem;
import org.eclipse.aperi.gui.topo.widget.JTopoTableSwitch;
import org.eclipse.aperi.gui.topo.widget.JTopoTableTapeLibrary;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoTable
extends AbstractJTopoBase {
    protected AbstractJTopoTabular tabular;
    protected GraphModel dataModel;
    protected JCustomRendererTable table;
    protected DefaultTopoTableColumnModel tableColumnModel;
    protected DefaultTopoTableModel tableModel;
    protected DefaultListSelectionModel tableSelectionModel;
    protected ML_Table ml_table;
    protected KL_Table kl_table;
    protected LSL_Table lsl_table;
    protected ArrangeRecord arrangeRecordGroup;
    protected ArrangeRecord arrangeRecord;
    protected boolean isUpdatingTableRowSelection;

    protected AbstractJTopoTable() {
        this.setLayout(new BorderLayout());
        this.ml_table = new ML_Table();
        this.lsl_table = new LSL_Table();
        this.table = new JCustomRendererTable();
        this.table.setAutoResizeMode(0);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.addMouseListener(this.ml_table);
        this.tableSelectionModel = (DefaultListSelectionModel)this.table.getSelectionModel();
        this.tableSelectionModel.addListSelectionListener(this.lsl_table);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(new ColumnHeaderListener());
        this.table.setAutoCreateColumnsFromModel(false);
    }

    private void initState() {
        this.tabular = null;
        this.dataModel = null;
        this.arrangeRecordGroup = null;
        this.arrangeRecord = null;
    }

    public void resetState() {
        this.initState();
    }

    public AbstractJTopoTabular getTabular() {
        return this.tabular;
    }

    public void setSessionModel(AbstractJTopoTabular abstractJTopoTabular) {
        this.tabular = abstractJTopoTabular;
    }

    public GraphModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel graphModel) {
        if (graphModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("AbstractJTopoTable.setModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = graphModel;
        this.updateContainer();
    }

    public JCustomRendererTable getTable() {
        return this.table;
    }

    public DefaultTopoTableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    public DefaultTopoTableModel getTableModel() {
        return this.tableModel;
    }

    public DefaultListSelectionModel getTableSelectionModel() {
        return this.tableSelectionModel;
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        DefaultTopoTableModel.MemberNode memberNode = this.tableModel.findMemberNode(n);
        if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
            DefaultTopoTableModel.GroupNode groupNode = (DefaultTopoTableModel.GroupNode)memberNode;
            int n2 = this.tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n2 == -1) {
                return;
            }
            TableColumn tableColumn = this.tableColumnModel.getColumn(n2);
            String string = (String)tableColumn.getIdentifier();
            if (string.equals("TOPO_LABEL_ATTR_COMMON_GROUP")) {
                int n3 = tableColumn.getModelIndex();
                JCustomRendererTable.GroupLabelCell groupLabelCell = (JCustomRendererTable.GroupLabelCell)memberNode.getData(n3);
                int n4 = groupLabelCell.getIconPosStart();
                int n5 = groupLabelCell.getIconPosEnd();
                Rectangle rectangle = this.table.getCellRect(n, n2, true);
                int n6 = mouseEvent.getX() - rectangle.x;
                if (n6 > n4 && n6 < n5) {
                    groupNode.setCollapse(!groupNode.isCollapsed());
                    this.tableModel.resetRowIndex();
                    this.tableModel.fireTableDataChanged();
                    this.updateTableRowSelection();
                }
            }
        }
    }

    protected void handleTableSelection() {
        if (this.isUpdatingTableRowSelection) {
            return;
        }
        ControllerView controllerView = this.tabular.getControllerView();
        ControllerView.SelectionDelta selectionDelta = new ControllerView.SelectionDelta(controllerView.getSelection());
        selectionDelta.setFromCanvas(false);
        selectionDelta.removeAll();
        int[] nArray = this.table.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            DefaultTopoTableModel.MemberNode memberNode = this.tableModel.findMemberNode(n2);
            GraphEntity.ID iD = memberNode.getRef();
            selectionDelta.add(iD);
            selectionDelta.setClickedEntityID(iD);
            ++n;
        }
        selectionDelta.setClickedWidget(this);
        controllerView.updateSelection(selectionDelta);
    }

    public boolean applySelection(ControllerView.SelectionDelta selectionDelta) {
        boolean bl;
        DefaultTopoTableModel.MemberNode memberNode;
        GraphEntity.ID iD;
        Iterator iterator = selectionDelta.iteratorRemove();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            memberNode = this.tableModel.findMemberNode(iD);
            if (memberNode == null) continue;
            memberNode.setSelected(false);
        }
        selectionDelta.isAltDown();
        iterator = selectionDelta.iteratorAdd();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            memberNode = this.tableModel.findMemberNode(iD);
            if (memberNode == null) continue;
            memberNode.setSelected(true);
        }
        iD = selectionDelta.getClickedEntityID();
        memberNode = this.tableModel.findMemberNode(iD);
        boolean bl2 = bl = memberNode != null;
        if (selectionDelta.isFromCanvas() && bl) {
            int n;
            Rectangle rectangle;
            boolean bl3 = memberNode.expand();
            if (bl3) {
                this.tableModel.resetRowIndex();
                this.tableModel.fireTableDataChanged();
            }
            if ((rectangle = this.table.getCellRect(n = memberNode.getRowIndex(), 0, true)) != null) {
                this.table.scrollRectToVisible(rectangle);
            }
        }
        this.updateTableRowSelection();
        return bl;
    }

    protected void updateTableRowSelection() {
        this.isUpdatingTableRowSelection = true;
        this.tableSelectionModel.setValueIsAdjusting(true);
        this.updateTableRowSelection_helper(this.tableModel.getRootNode());
        this.tableSelectionModel.setValueIsAdjusting(false);
        this.isUpdatingTableRowSelection = false;
    }

    protected void updateTableRowSelection_helper(DefaultTopoTableModel.GroupNode groupNode) {
        Vector vector = groupNode.getMemberVector();
        int n = 0;
        while (n < vector.size()) {
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector.elementAt(n);
            int n2 = memberNode.getRowIndex();
            if (n2 != -1) {
                if (memberNode.isSelected() && !this.table.isRowSelected(n2)) {
                    this.tableSelectionModel.addSelectionInterval(n2, n2);
                } else if (!memberNode.isSelected() && this.table.isRowSelected(n2)) {
                    this.tableSelectionModel.removeSelectionInterval(n2, n2);
                }
            }
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                DefaultTopoTableModel.GroupNode groupNode2 = (DefaultTopoTableModel.GroupNode)memberNode;
                this.updateTableRowSelection_helper(groupNode2);
            }
            ++n;
        }
    }

    public boolean locate(ControllerView.LocateDelta locateDelta, String string) {
        DefaultTopoTableModel.RootNode rootNode = this.tableModel.getRootNode();
        return this.locate_helper(locateDelta, rootNode, string);
    }

    protected boolean locate_helper(ControllerView.LocateDelta locateDelta, DefaultTopoTableModel.GroupNode groupNode, String string) {
        boolean bl = false;
        Vector vector = groupNode.getMemberVector();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector.elementAt(n);
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                object = (DefaultTopoTableModel.GroupNode)memberNode;
                bl |= this.locate_helper(locateDelta, (DefaultTopoTableModel.GroupNode)object, string);
            } else {
                object = new Vector();
                Vector vector2 = memberNode.getDataVector();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    String string2;
                    JCustomRendererTable.CustomCell customCell = (JCustomRendererTable.CustomCell)memberNode.getData(n2);
                    if (customCell != null && (string2 = customCell.toString()).toLowerCase().indexOf(string) != -1) {
                        ((Vector)object).add(customCell);
                    }
                    ++n2;
                }
                GraphEntity.ID iD = memberNode.getRef();
                if (((Vector)object).size() > 0) {
                    bl |= true;
                    if (locateDelta.isInSrc(iD)) {
                        locateDelta.change(iD);
                    } else {
                        locateDelta.add(iD);
                    }
                    locateDelta.putCells(memberNode, (Vector)object);
                } else {
                    locateDelta.remove(iD);
                    locateDelta.removeCells(memberNode);
                }
            }
            ++n;
        }
        return bl;
    }

    public void applyLocate(ControllerView.LocateDelta locateDelta) {
        JCustomRendererTable.CustomCell customCell;
        int n;
        Vector vector;
        JCustomRendererTable.CustomCell customCell2;
        DefaultTopoTableModel.MemberNode memberNode;
        GraphEntity.ID iD;
        int n2 = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_LOCATED");
        int n3 = this.tableColumnModel.getColumn(n2).getModelIndex();
        DefaultTopoTableModel.RootNode rootNode = this.tableModel.getRootNode();
        boolean bl = false;
        Iterator iterator = locateDelta.iteratorRemove();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            memberNode = this.tableModel.findMemberNode(iD);
            if (memberNode == null) continue;
            bl = true;
            customCell2 = (JCustomRendererTable.CustomCell)memberNode.getData(n3);
            customCell2.setValue(null);
            customCell2.setSorting(null);
            customCell2.setIcon(null);
            customCell2.setAux(null);
            vector = memberNode.getDataVector();
            n = 0;
            while (n < vector.size()) {
                customCell = (JCustomRendererTable.CustomCell)memberNode.getData(n);
                customCell.setHighlighted(false);
                ++n;
            }
        }
        iterator = locateDelta.iteratorAdd();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            memberNode = this.tableModel.findMemberNode(iD);
            if (memberNode == null) continue;
            bl = true;
            customCell2 = (JCustomRendererTable.CustomCell)memberNode.getData(n3);
            customCell2.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LOCATED"));
            customCell2.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_LOCATED"));
            customCell2.setIcon(TopoResource.ICON_LOCATE_MATCH);
            customCell2.setAux(Boolean.TRUE);
            vector = locateDelta.getCells(memberNode);
            if (vector == null) continue;
            n = 0;
            while (n < vector.size()) {
                customCell = (JCustomRendererTable.CustomCell)vector.elementAt(n);
                customCell.setHighlighted(true);
                ++n;
            }
        }
        iterator = locateDelta.iteratorChange();
        while (iterator.hasNext()) {
            iD = (GraphEntity.ID)iterator.next();
            memberNode = this.tableModel.findMemberNode(iD);
            if (memberNode == null) continue;
            bl = true;
            customCell2 = (JCustomRendererTable.CustomCell)memberNode.getData(n3);
            customCell2.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LOCATED"));
            customCell2.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_LOCATED"));
            customCell2.setIcon(TopoResource.ICON_LOCATE_MATCH);
            customCell2.setAux(Boolean.TRUE);
            vector = memberNode.getDataVector();
            int n4 = 0;
            while (n4 < vector.size()) {
                JCustomRendererTable.CustomCell customCell3 = (JCustomRendererTable.CustomCell)memberNode.getData(n4);
                customCell3.setHighlighted(false);
                ++n4;
            }
            Vector vector2 = locateDelta.getCells(memberNode);
            if (vector2 == null) continue;
            int n5 = 0;
            while (n5 < vector2.size()) {
                JCustomRendererTable.CustomCell customCell4 = (JCustomRendererTable.CustomCell)vector2.elementAt(n5);
                customCell4.setHighlighted(true);
                ++n5;
            }
        }
        if (bl) {
            this.applyLocate_propagate(rootNode);
            this.tableModel.fireTableDataChanged();
            this.applyLocate_scroll(rootNode);
        }
    }

    public boolean applyLocate_propagate(DefaultTopoTableModel.GroupNode groupNode) {
        int n = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_LOCATED");
        int n2 = this.tableColumnModel.getColumn(n).getModelIndex();
        boolean bl = false;
        Vector vector = groupNode.getMemberVector();
        int n3 = 0;
        while (n3 < vector.size()) {
            Object object;
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector.elementAt(n3);
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                object = (DefaultTopoTableModel.GroupNode)memberNode;
                bl |= this.applyLocate_propagate((DefaultTopoTableModel.GroupNode)object);
            } else {
                object = (JCustomRendererTable.CustomCell)memberNode.getData(n2);
                Boolean bl2 = (Boolean)((JCustomRendererTable.CustomCell)object).getAux();
                bl |= bl2 != null ? bl2 : false;
            }
            ++n3;
        }
        JCustomRendererTable.CustomCell customCell = (JCustomRendererTable.CustomCell)groupNode.getData(n2);
        if (customCell != null) {
            if (bl) {
                customCell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_LOCATED"));
                customCell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_LOCATED"));
                customCell.setIcon(TopoResource.ICON_LOCATE_MATCH);
                customCell.setAux(Boolean.TRUE);
            } else {
                customCell.setValue(null);
                customCell.setSorting(null);
                customCell.setIcon(null);
                customCell.setAux(null);
            }
        }
        return bl;
    }

    public boolean applyLocate_scroll(DefaultTopoTableModel.GroupNode groupNode) {
        int n = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_LOCATED");
        int n2 = this.tableColumnModel.getColumn(n).getModelIndex();
        boolean bl = false;
        Vector vector = groupNode.getMemberVector();
        int n3 = 0;
        while (n3 < vector.size()) {
            Object object;
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector.elementAt(n3);
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                object = (DefaultTopoTableModel.GroupNode)memberNode;
                bl = this.applyLocate_scroll((DefaultTopoTableModel.GroupNode)object);
            } else {
                object = (JCustomRendererTable.CustomCell)memberNode.getData(n2);
                Boolean bl2 = (Boolean)((JCustomRendererTable.CustomCell)object).getAux();
                if (bl2 != null && bl2.booleanValue()) {
                    Vector vector2 = memberNode.getDataVector();
                    int n4 = 0;
                    while (n4 < vector2.size()) {
                        JCustomRendererTable.CustomCell customCell = (JCustomRendererTable.CustomCell)memberNode.getData(n4);
                        if (customCell.isHighlighted()) {
                            int n5;
                            int n6;
                            Rectangle rectangle;
                            boolean bl3 = memberNode.expand();
                            if (bl3) {
                                this.tableModel.resetRowIndex();
                                this.tableModel.fireTableDataChanged();
                                this.updateTableRowSelection();
                            }
                            if ((rectangle = this.table.getCellRect(n6 = memberNode.getRowIndex(), n5 = this.table.convertColumnIndexToView(n4), true)) != null) {
                                this.table.scrollRectToVisible(rectangle);
                            }
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                }
            }
            if (bl) break;
            ++n3;
        }
        return bl;
    }

    public void expandAll() {
        this.tableModel.collapseAll(false);
        this.updateTableRowSelection();
    }

    public void collapseAll() {
        this.tableModel.collapseAll(true);
        this.updateTableRowSelection();
    }

    public void arrange() {
        if (this.arrangeRecordGroup != null) {
            this.sort(this.arrangeRecordGroup.getIdentifier(), this.arrangeRecordGroup.isAsc());
        }
        if (this.arrangeRecord != null) {
            this.sort(this.arrangeRecord.getIdentifier(), this.arrangeRecord.isAsc());
        }
    }

    public void sort(Object object, boolean bl) {
        if (object == null) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = this.tableColumnModel.getColumn(n2);
            JCustomRendererTable.CustomHeader customHeader = (JCustomRendererTable.CustomHeader)tableColumn.getHeaderValue();
            if (object.equals(tableColumn.getIdentifier())) {
                ImageIcon imageIcon = bl ? TopoResource.ICON_SORT_ASC : TopoResource.ICON_SORT_DSC;
                customHeader.setIcon(imageIcon);
                n = n2;
            } else {
                customHeader.setIcon(null);
            }
            ++n2;
        }
        if (n != -1) {
            n2 = this.tableColumnModel.getColumn(n).getModelIndex();
            this.tableModel.sort(n2, bl);
            this.tableModel.resetRowIndex();
            this.tableModel.fireTableDataChanged();
            this.table.getTableHeader().repaint();
        }
    }

    public void setShowConnectionEnabled(boolean bl) {
    }

    public void setShowZoneEnabled(boolean bl) {
    }

    public void setOverlayHealthEnabled(boolean bl) {
        this.tableColumnModel.setOverlayHealthEnabled(bl);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setOverlayPerfEnabled(boolean bl) {
        this.tableColumnModel.setOverlayPerfEnabled(bl);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setFilteringLevel(int n) {
        this.updateContainer();
    }

    public void setPinnedList(PinList pinList) {
        if (this instanceof JTopoTableSubsystem || this instanceof JTopoTableComputer || this instanceof JTopoTableSwitch || this instanceof JTopoTableTapeLibrary || this instanceof JTopoTableOther) {
            DefaultTopoTableModel.RootNode rootNode = this.tableModel.getRootNode();
            Vector vector = pinList.getPins();
            int n = this.tableColumnModel.getColumnIndex("TOPO_LABEL_ATTR_COMMON_PINNED");
            int n2 = this.tableColumnModel.getColumn(n).getModelIndex();
            this.setPinnedList_helper(rootNode, vector, n2);
            this.tableModel.fireTableDataChanged();
        }
    }

    protected boolean setPinnedList_helper(DefaultTopoTableModel.GroupNode groupNode, Vector vector, int n) {
        Vector vector2 = groupNode.getMemberVector();
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector2.size()) {
            Object object;
            DefaultTopoTableModel.MemberNode memberNode = (DefaultTopoTableModel.MemberNode)vector2.elementAt(n2);
            boolean bl2 = false;
            if (memberNode instanceof DefaultTopoTableModel.GroupNode) {
                object = (DefaultTopoTableModel.GroupNode)memberNode;
                boolean bl3 = this.setPinnedList_helper((DefaultTopoTableModel.GroupNode)object, vector, n);
                bl2 = bl2 || bl3;
                bl = bl || bl3;
            } else {
                int n3 = 0;
                while (n3 < vector.size()) {
                    GraphEntity.ID iD = (GraphEntity.ID)vector.elementAt(n3);
                    if (memberNode.getRef().equals(iD)) {
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            object = (JCustomRendererTable.CustomCell)memberNode.getData(n);
            if (object != null) {
                if (bl2) {
                    ((JCustomRendererTable.CustomCell)object).setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PINNED"));
                    ((JCustomRendererTable.CustomCell)object).setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_PINNED"));
                    ((JCustomRendererTable.CustomCell)object).setIcon(TopoResource.ICON_PIN_ON);
                    ((JCustomRendererTable.CustomCell)object).setAux(Boolean.TRUE);
                } else {
                    ((JCustomRendererTable.CustomCell)object).setValue(null);
                    ((JCustomRendererTable.CustomCell)object).setSorting(null);
                    ((JCustomRendererTable.CustomCell)object).setIcon(null);
                    ((JCustomRendererTable.CustomCell)object).setAux(null);
                }
            }
            ++n2;
        }
        JCustomRendererTable.CustomCell customCell = (JCustomRendererTable.CustomCell)groupNode.getData(n);
        if (customCell != null) {
            if (bl) {
                customCell.setValue(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PINNED"));
                customCell.setSorting((Comparable)((Object)"TOPO_LABEL_ATTR_COMMON_PINNED"));
                customCell.setIcon(TopoResource.ICON_PIN_ON);
                customCell.setAux(Boolean.TRUE);
            } else {
                customCell.setValue(null);
                customCell.setSorting(null);
                customCell.setIcon(null);
                customCell.setAux(null);
            }
        }
        return bl;
    }

    protected class ML_Table
    extends MouseAdapter {
        protected ML_Table() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractJTopoTable.this.handleMouseClick(mouseEvent);
        }
    }

    protected class LSL_Table
    implements ListSelectionListener {
        protected LSL_Table() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                AbstractJTopoTable.this.handleTableSelection();
            }
        }
    }

    protected class KL_Table
    extends KeyAdapter {
        protected KL_Table() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    protected class ArrangeRecord {
        private Object identifier;
        private boolean isAsc;

        public ArrangeRecord() {
        }

        public ArrangeRecord(Object object, boolean bl) {
            this.identifier = object;
            this.isAsc = bl;
        }

        public boolean isAsc() {
            return this.isAsc;
        }

        public void setAsc(boolean bl) {
            this.isAsc = bl;
        }

        public Object getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Object object) {
            this.identifier = object;
        }
    }

    protected class ColumnHeaderListener
    extends MouseAdapter {
        protected ColumnHeaderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = AbstractJTopoTable.this.tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n == -1) {
                return;
            }
            TableColumn tableColumn = AbstractJTopoTable.this.tableColumnModel.getColumn(n);
            Object object = tableColumn.getIdentifier();
            if (AbstractJTopoTable.this.arrangeRecordGroup != null && object.equals(AbstractJTopoTable.this.arrangeRecordGroup.getIdentifier())) {
                AbstractJTopoTable.this.arrangeRecordGroup.setAsc(!AbstractJTopoTable.this.arrangeRecordGroup.isAsc());
            } else if (AbstractJTopoTable.this.arrangeRecord != null) {
                if (object.equals(AbstractJTopoTable.this.arrangeRecord.getIdentifier())) {
                    AbstractJTopoTable.this.arrangeRecord.setAsc(!AbstractJTopoTable.this.arrangeRecord.isAsc());
                } else {
                    AbstractJTopoTable.this.arrangeRecord.setIdentifier(object);
                }
            }
            AbstractJTopoTable.this.arrange();
        }
    }
}

