/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphScopedID;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.event.TopoUnitModelListener;

public abstract class AbstractJTopoUnit
extends AbstractJTopoBase
implements TopoUnitModelListener {
    protected AbstractJTopoCanvas canvas;
    protected String scope;
    protected GraphScopedID scopedID;
    protected GraphEntity.ID focusEntityID;
    protected GraphEntity focusEntity;
    protected Object widgetModel;
    protected boolean isWidgetModelListener;
    protected ML_Click mlClick;
    protected ML_Drag mlDrag;
    protected boolean isAlwaysVisible;
    protected boolean isChecked;
    protected AbstractJTopoEntity logicalParent;

    protected AbstractJTopoUnit() {
        this((ITopoUnitModel)null, true);
    }

    protected AbstractJTopoUnit(ITopoUnitModel iTopoUnitModel, boolean bl) {
        if (iTopoUnitModel == null) {
            this.widgetModel = this.createWidgetModel();
            this.isWidgetModelListener = true;
        } else {
            this.widgetModel = iTopoUnitModel;
            this.isWidgetModelListener = bl;
        }
        this.setLayout(this.createDefaultLayout());
        this.setBackground(TopoResource.COLOR_BACKGROUND);
        this.mlClick = new ML_Click();
        this.addMouseListener(this.mlClick);
        this.mlDrag = new ML_Drag();
        this.addMouseListener(this.mlDrag);
        this.addMouseMotionListener(this.mlDrag);
        this.initState();
    }

    private void initState() {
        this.canvas = null;
        this.scope = null;
        this.scopedID = null;
        this.focusEntityID = null;
        this.focusEntity = null;
        this.isAlwaysVisible = false;
        this.isChecked = false;
        this.logicalParent = null;
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
        this.setBounds(0, 0, 0, 0);
        this.setVisible(true);
        ITopoUnitModel iTopoUnitModel = (ITopoUnitModel)this.widgetModel;
        if (this.isWidgetModelListener) {
            iTopoUnitModel.init();
            iTopoUnitModel.addModelChangeListener(this);
        }
    }

    public void resetState() {
        this.initState();
    }

    public AbstractJTopoCanvas getCanvas() {
        return this.canvas;
    }

    public String getScope() {
        return this.scope;
    }

    public GraphScopedID getScopedID() {
        return this.scopedID;
    }

    public void setSessionModel(AbstractJTopoCanvas abstractJTopoCanvas, String string) {
        this.canvas = abstractJTopoCanvas;
        this.scope = string;
        TopoSetting topoSetting = abstractJTopoCanvas.getControllerView().getControllerApp().getTopoSetting();
        this.setOverlayHealthEnabled(topoSetting.isOverlayHealthEnabled());
        this.setOverlayPerfEnabled(topoSetting.isOverlayPerfEnabled());
    }

    public GraphEntity.ID getFocusEntityID() {
        return this.focusEntityID;
    }

    public GraphEntity getFocusEntity() {
        return this.focusEntity;
    }

    public void setDataModel(GraphEntity graphEntity) {
        if (graphEntity != null) {
            this.focusEntity = graphEntity;
            this.focusEntityID = graphEntity.getEntityID();
            this.scopedID = new GraphScopedID(this.focusEntityID, this.scope);
        }
        this.updateContainer();
    }

    protected abstract Object createWidgetModel();

    public Object getWidgetModel() {
        return this.widgetModel;
    }

    public void setWidgetModel(Object object) {
        this.widgetModel = object;
    }

    public void modelChanged() {
    }

    public void selectionChanged() {
    }

    public void highlightChanged() {
    }

    public void pinChanged() {
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isAlwaysVisible ? true : bl;
        super.setVisible(bl2);
    }

    public AbstractJTopoEntity getLogicalParent() {
        return this.logicalParent;
    }

    public void setLogicalParent(AbstractJTopoEntity abstractJTopoEntity) {
        this.logicalParent = abstractJTopoEntity;
    }

    public abstract void setOverlayHealthEnabled(boolean var1);

    public abstract void setOverlayPerfEnabled(boolean var1);

    public abstract void setArrange(AbstractJTopoCanvas.ArrangeRecord var1);

    public boolean isAlwaysVisible() {
        return this.isAlwaysVisible;
    }

    public void setAlwaysVisible(boolean bl) {
        this.isAlwaysVisible = bl;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean bl) {
        this.isChecked = bl;
    }

    public AbstractJTopoUnit getLastVisibleUnit() {
        AbstractJTopoUnit abstractJTopoUnit = this;
        AbstractJTopoUnit abstractJTopoUnit2 = this;
        while (abstractJTopoUnit2 != null) {
            if (abstractJTopoUnit2 instanceof AbstractJTopoGroup && !((AbstractJTopoGroup)abstractJTopoUnit2).isExpanded()) {
                abstractJTopoUnit = abstractJTopoUnit2;
            }
            abstractJTopoUnit2 = abstractJTopoUnit2.getLogicalParent();
        }
        return abstractJTopoUnit;
    }

    protected Point getConnectingPoint() {
        return new Point(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        this.handleMouseClick_background(mouseEvent);
    }

    protected final void handleMouseClick_background(MouseEvent mouseEvent) {
        if (this.logicalParent != null) {
            this.logicalParent.handleMouseClick_regular(mouseEvent);
        } else {
            this.canvas.handleMouseClick(mouseEvent);
        }
    }

    protected final void handleMouseClick_regular(MouseEvent mouseEvent) {
        TopoEventSource topoEventSource = (TopoEventSource)mouseEvent.getSource();
        topoEventSource.setHandler(this);
        boolean bl = false;
        this.canvas.handleUnitClick(mouseEvent, bl);
    }

    protected final void handleMouseClick_recursive(MouseEvent mouseEvent) {
        TopoEventSource topoEventSource = (TopoEventSource)mouseEvent.getSource();
        topoEventSource.setHandler(this.logicalParent);
        boolean bl = true;
        this.canvas.handleUnitClick(mouseEvent, bl);
    }

    protected abstract LayoutManager createDefaultLayout();

    protected class ML_Click
    extends MouseAdapter {
        protected ML_Click() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.setSource(new TopoEventSource(mouseEvent));
            AbstractJTopoUnit.this.handleMouseClick(mouseEvent);
        }
    }

    protected class ML_Drag
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point last;
        protected boolean isCursorSet;

        protected ML_Drag() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isAltDown()) {
                this.last = mouseEvent.getPoint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isAltDown()) {
                if (!this.isCursorSet) {
                    AbstractJTopoUnit.this.canvas.setCursor(Cursor.getPredefinedCursor(13));
                    this.isCursorSet = true;
                }
                Point point = mouseEvent.getPoint();
                Point point2 = new Point(point.x - this.last.x, point.y - this.last.y);
                AbstractJTopoUnit.this.canvas.handleUnitMouseDrag(point2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.last = null;
            if (this.isCursorSet) {
                AbstractJTopoUnit.this.canvas.setCursor(Cursor.getPredefinedCursor(0));
                this.isCursorSet = false;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

