/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTabular;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasFabricL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasFabricL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasOverview;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasStorageL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSubsystemL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSubsystemL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL0;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL2;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasTapeLibraryL1;
import org.eclipse.aperi.gui.topo.widget.JTopoCanvasTapeLibraryL2;
import org.eclipse.aperi.gui.topo.widget.JTopoMiniMap;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularFabricL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularFabricL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularOverview;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularStorageL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL0;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL2;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularTapeLibraryL1;
import org.eclipse.aperi.gui.topo.widget.JTopoTabularTapeLibraryL2;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class JTopoView
extends AbstractJTopoBase {
    protected ControllerView controllerView;
    protected GraphModel dataModel;
    protected JSplitPane split;
    protected AbstractJTopoCanvas canvas;
    protected JTopoMiniMap miniMap;
    protected AbstractJTopoTabular tabular;
    protected boolean refreshInProgress;
    protected Object refreshInProgressLock;
    protected InvalidPanel invalidPanel;
    protected String viewTitle;
    protected Integer viewStatus;

    public JTopoView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, constructor");
        }
        this.setLayout(this.createDefaultLayout());
        this.split = new JSplitPane(0);
        this.split.setDividerSize(5);
        this.split.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JTopoView.this.dataModel != null && !JTopoView.this.dataModel.isEmpty()) {
                    double d = (double)JTopoView.this.split.getDividerLocation() / (double)JTopoView.this.split.getHeight();
                    TopoSetting topoSetting = JTopoView.this.controllerView.getControllerApp().getTopoSetting();
                    TopoSetting.SettingPerViewType settingPerViewType = topoSetting.getSettingPerViewType(JTopoView.this.dataModel.getModelID().getFocusLevel());
                    settingPerViewType.setSplitRatio(d);
                }
            }
        });
        this.add(this.split);
        this.refreshInProgressLock = new Object();
        this.invalidPanel = new InvalidPanel();
        this.initState();
    }

    private void initState() {
        this.controllerView = null;
        this.dataModel = null;
        this.split.setTopComponent(null);
        this.split.setBottomComponent(null);
        this.canvas = null;
        this.miniMap = null;
        this.tabular = null;
        this.refreshInProgress = false;
        this.viewTitle = null;
        this.viewStatus = null;
        this.setEnabled(true);
    }

    public void resetState() {
        WidgetPool widgetPool = WidgetPool.getInstance();
        widgetPool.recycleWidget(this.canvas);
        widgetPool.recycleWidget(this.miniMap);
        widgetPool.recycleWidget(this.tabular);
        this.initState();
    }

    public ControllerView getControllerView() {
        return this.controllerView;
    }

    public void setSessionModel(ControllerView controllerView) {
        GraphModel.ID iD = controllerView.getModelID();
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, setSessionModel(), modelID=" + iD + ", controllerView=" + controllerView);
        }
        this.controllerView = controllerView;
        this.canvas = this.createCanvas(iD);
        this.split.setTopComponent(this.canvas);
        this.miniMap = this.createMiniMap(this.canvas);
        this.tabular = this.createTabular(iD);
        this.split.setBottomComponent(this.tabular);
        this.canvas.setSessionModel(controllerView);
        this.tabular.setSessionModel(controllerView);
    }

    public GraphModel getDtataModel() {
        return this.dataModel;
    }

    public void setDataModel(GraphModel graphModel) {
        Object object;
        Serializable serializable;
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, setDataModel(), modelID=" + graphModel.getModelID());
        }
        if (graphModel == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("JTopoView.setDataModel(), dataModel=null");
            }
            return;
        }
        this.dataModel = graphModel;
        GraphModel.ID iD = graphModel.getModelID();
        String string = iD.getFocusLevel();
        String string2 = GraphModelUtilities.getViewAlias(string);
        GraphEntity.ID iD2 = iD.getFocusEntityID();
        if (iD2 != null) {
            serializable = graphModel.get(iD2);
            object = null;
            object = serializable != null ? ((GraphEntity)serializable).getDisplayName() : iD2.getID().toString();
            if (((String)object).length() > 6) {
                object = String.valueOf(((String)object).substring(0, 6)) + "...";
            }
            string2 = String.valueOf(string2) + "-" + (String)object;
        }
        this.setTitle(string2);
        this.setStatus(null);
        this.canvas.setDataModel(graphModel);
        this.tabular.setDataModel(graphModel);
        serializable = this.controllerView.getControllerApp().getTopoSetting();
        object = ((TopoSetting)serializable).getSettingPerViewType(graphModel.getModelID().getFocusLevel());
        double d = ((TopoSetting.SettingPerViewType)object).getSplitRatio();
        SwingUtilities.invokeLater(new SplitDividerLocation(this.split, d));
        this.updateContainer();
    }

    protected void reattach() {
    }

    public JSplitPane getSplitPane() {
        return this.split;
    }

    public AbstractJTopoCanvas getCanvas() {
        return this.canvas;
    }

    public AbstractJTopoTabular getTabular() {
        return this.tabular;
    }

    public JTopoMiniMap getMiniMap() {
        return this.miniMap;
    }

    protected AbstractJTopoCanvas createCanvas(GraphModel.ID iD) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, createCanvas(), modelID=" + iD);
        }
        String string = iD.getFocusLevel();
        WidgetPool widgetPool = WidgetPool.getInstance();
        AbstractJTopoCanvas abstractJTopoCanvas = null;
        if ("Overview".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasOverview");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasOverview)widgetPool.getWidget(clazz);
        } else if ("FabricL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasFabricL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasFabricL0)widgetPool.getWidget(clazz);
        } else if ("FabricL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasFabricL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasFabricL2)widgetPool.getWidget(clazz);
        } else if ("ComputerL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasComputerL0)widgetPool.getWidget(clazz);
        } else if ("ComputerL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasComputerL1)widgetPool.getWidget(clazz);
        } else if ("ComputerL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasComputerL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasComputerL2)widgetPool.getWidget(clazz);
        } else if ("SwitchL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasSwitchL0)widgetPool.getWidget(clazz);
        } else if ("SwitchL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasSwitchL1)widgetPool.getWidget(clazz);
        } else if ("SwitchL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasSwitchL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasSwitchL2)widgetPool.getWidget(clazz);
        } else if ("StorageL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasStorageL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasStorageL0)widgetPool.getWidget(clazz);
        } else if ("SubsystemL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasSubsystemL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasSubsystemL1)widgetPool.getWidget(clazz);
        } else if ("SubsystemL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasSubsystemL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasSubsystemL2)widgetPool.getWidget(clazz);
        } else if ("TapeLibraryL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasTapeLibraryL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasTapeLibraryL1)widgetPool.getWidget(clazz);
        } else if ("TapeLibraryL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasTapeLibraryL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasTapeLibraryL2)widgetPool.getWidget(clazz);
        } else if ("OtherL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasOtherL0)widgetPool.getWidget(clazz);
        } else if ("OtherL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasOtherL1)widgetPool.getWidget(clazz);
        } else if ("OtherL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoCanvasOtherL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoCanvas = (JTopoCanvasOtherL2)widgetPool.getWidget(clazz);
        } else if (GraphDebug.isErrorVisible()) {
            GraphDebug.error("JTopoViewer, createCanvas(), invalid focusLevel=" + string);
        }
        return abstractJTopoCanvas;
    }

    protected JTopoMiniMap createMiniMap(AbstractJTopoCanvas abstractJTopoCanvas) {
        Class<?> clazz;
        WidgetPool widgetPool = WidgetPool.getInstance();
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoMiniMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        JTopoMiniMap jTopoMiniMap = (JTopoMiniMap)widgetPool.getWidget(clazz);
        jTopoMiniMap.setDataModel(abstractJTopoCanvas);
        return jTopoMiniMap;
    }

    protected AbstractJTopoTabular createTabular(GraphModel.ID iD) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, createTabular(), modelID=" + iD);
        }
        String string = iD.getFocusLevel();
        WidgetPool widgetPool = WidgetPool.getInstance();
        AbstractJTopoTabular abstractJTopoTabular = null;
        if ("Overview".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularOverview");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularOverview)widgetPool.getWidget(clazz);
        } else if ("FabricL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularFabricL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularFabricL0)widgetPool.getWidget(clazz);
        } else if ("FabricL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularFabricL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularFabricL2)widgetPool.getWidget(clazz);
        } else if ("ComputerL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularComputerL0)widgetPool.getWidget(clazz);
        } else if ("ComputerL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularComputerL1)widgetPool.getWidget(clazz);
        } else if ("ComputerL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularComputerL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularComputerL2)widgetPool.getWidget(clazz);
        } else if ("SwitchL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularSwitchL0)widgetPool.getWidget(clazz);
        } else if ("SwitchL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularSwitchL1)widgetPool.getWidget(clazz);
        } else if ("SwitchL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularSwitchL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularSwitchL2)widgetPool.getWidget(clazz);
        } else if ("StorageL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularStorageL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularStorageL0)widgetPool.getWidget(clazz);
        } else if ("SubsystemL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularSubsystemL1)widgetPool.getWidget(clazz);
        } else if ("SubsystemL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularSubsystemL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularSubsystemL2)widgetPool.getWidget(clazz);
        } else if ("TapeLibraryL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularTapeLibraryL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularTapeLibraryL1)widgetPool.getWidget(clazz);
        } else if ("TapeLibraryL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularTapeLibraryL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularTapeLibraryL2)widgetPool.getWidget(clazz);
        } else if ("OtherL0".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularOtherL0)widgetPool.getWidget(clazz);
        } else if ("OtherL1".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularOtherL1)widgetPool.getWidget(clazz);
        } else if ("OtherL2".equals(string)) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.gui.topo.widget.JTopoTabularOtherL2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            abstractJTopoTabular = (JTopoTabularOtherL2)widgetPool.getWidget(clazz);
        } else if (GraphDebug.isErrorVisible()) {
            GraphDebug.error("JTopoViewer, createTabular(), invalid focusLevel=" + string);
        }
        return abstractJTopoTabular;
    }

    public String getTitle() {
        return this.viewTitle;
    }

    public void setTitle(String string) {
        this.viewTitle = string;
        this.controllerView.getControllerApp().getTopoApp().getTopoViewGroup().setViewTitle(this, string);
    }

    public Integer getStatus() {
        return this.viewStatus;
    }

    public void setStatus(Integer n) {
        this.viewStatus = n;
        this.controllerView.getControllerApp().getTopoApp().getTopoViewGroup().setViewStatus(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRefreshInProgress() {
        Object object = this.refreshInProgressLock;
        synchronized (object) {
            return this.refreshInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshInProgress(boolean bl) {
        Object object = this.refreshInProgressLock;
        synchronized (object) {
            this.refreshInProgress = bl;
        }
    }

    public void setEnabled(boolean bl) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoView, setEnabled(), enabled=" + bl);
        }
        this.remove(this.invalidPanel);
        if (!bl) {
            this.add((Component)this.invalidPanel, 0);
        }
        super.setEnabled(bl);
        if (this.miniMap != null) {
            this.miniMap.setEnabled(bl);
        }
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    private class SplitDividerLocation
    implements Runnable {
        private JSplitPane split;
        private double ratio;

        public SplitDividerLocation(JSplitPane jSplitPane, double d) {
            this.split = jSplitPane;
            this.ratio = d;
        }

        public void run() {
            this.split.setDividerLocation((int)(this.ratio * (double)this.split.getHeight()));
            this.split.setResizeWeight(this.ratio);
        }
    }

    protected class InvalidPanel
    extends JPanel {
        public InvalidPanel() {
            this.setBackground(new Color(255, 255, 255, 200));
            this.addMouseListener(new DummyMouseAdapter());
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(TopoResource.COLOR_MISSING);
            graphics2D.setFont(TopoResource.FONT_CANVASPANELCONTAINER);
            graphics2D.drawString(GuiUtil.getString("TOPO_LABEL_VIEW_INVALID"), 0, 70);
        }

        protected class DummyMouseAdapter
        extends MouseAdapter {
            protected DummyMouseAdapter() {
            }
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected DefaultLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = container.getWidth() - insets.left - insets.right;
            int n4 = container.getHeight() - insets.top - insets.bottom;
            Component[] componentArray = container.getComponents();
            int n5 = 0;
            while (n5 < componentArray.length) {
                componentArray[n5].setBounds(n, n2, n3, n4);
                ++n5;
            }
        }
    }
}

