/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Model;
import org.eclipse.aperi.infrastructure.database.sql.SqlHost;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class ControllerXmlToDBMapper
extends DBAttributeMapper {
    private static final String GUID = "GUID";
    private static final String NAME = "Name";
    private static final String UNINAME = "Uni Name";
    private static final String SERIALNUMBER = "Serial Number";
    private static final String DRIVERVERSION = "Driver Version";
    private static final String OPTIONALROMVERSION = "Optional Rom Version";
    private static final String HARDWAREVERSION = "Hardware Version";
    private static final String FIRMWAREVERSION = "Firmware Version";
    private static final String DRIVERNAME = "Driver Name";
    private static final String COMMONAPIVERSION = "Common API Version";
    private static final String MODEL = "Model";
    private static final String VENDOR = "Vendor";
    private static final String HOSTID = "Host ID";
    private static final String MODELDESCRIPTION = "Model Description";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "ControllerXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public ControllerXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 3);
        this.m_dataConverter.addComplexDataConversion(UNINAME.toLowerCase(), ":", 4);
        ColumnInfo columnInfo = Hba.getColumnInfo("NAME");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), mapperInfo);
        this.m_htAttribToMapperInfo.put(UNINAME.toLowerCase(), mapperInfo);
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(Hba.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put(DRIVERVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("DRIVER_VERSION")));
        this.m_htAttribToMapperInfo.put(OPTIONALROMVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("ROM_VERSION")));
        this.m_htAttribToMapperInfo.put(HARDWAREVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("HW_VERSION")));
        this.m_htAttribToMapperInfo.put(FIRMWAREVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("FIRMWARE_VERSION")));
        this.m_htAttribToMapperInfo.put(DRIVERNAME.toLowerCase(), new MapperInfo(Hba.getColumnInfo("DRIVER_NAME")));
        this.m_htAttribToMapperInfo.put(COMMONAPIVERSION.toLowerCase(), new MapperInfo(Hba.getColumnInfo("API_VERSION")));
        ColumnInfo columnInfo2 = Hba.getColumnInfo("HOST_ID");
        columnInfo2.setIsPrimaryKey();
        MapperInfo mapperInfo2 = new MapperInfo(columnInfo2);
        this.m_htAttribToMapperInfo.put(HOSTID.toLowerCase(), mapperInfo2);
        ColumnInfo columnInfo3 = Hba.getColumnInfo("HBA_WWN");
        columnInfo3.setIsPrimaryKey();
        MapperInfo mapperInfo3 = new MapperInfo(columnInfo3);
        ColumnInfo columnInfo4 = Hba.getColumnInfo("HBA_ID");
        columnInfo4.setAutoGenerated();
        mapperInfo3.setDerivedColumn(columnInfo4);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), mapperInfo3);
        this.m_htAttribToMapperInfo.put(MODEL.toLowerCase(), new MapperInfo(Hba.getColumnInfo("MODEL_ID")));
        this.m_htAttribToMapperInfo.put(VENDOR.toLowerCase(), new MapperInfo(Hba.getColumnInfo("VENDOR_ID")));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        Object object2;
        block13: {
            String string2 = "persist(DBConnection conn, Hashtable htValues,String scanID)";
            if (dBConnection == null) throw new SQLException("ControllerXml mapper requires non-null DBConnection and Hashtable objects.");
            if (hashtable == null) {
                throw new SQLException("ControllerXml mapper requires non-null DBConnection and Hashtable objects.");
            }
            String string3 = (String)hashtable.get("UniqueIdXml");
            if (string3 == null) {
                throw new SQLException("ControllerXML mapper requires the UniqueIdXml key.");
            }
            String string4 = (String)hashtable.get(NAME.toLowerCase());
            if (string4 == null) {
                hashtable.put(UNINAME, string3);
            }
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put(GUID, string3);
            this.m_dataConverter.addComplexDataConversion(GUID, ":", 2);
            this.m_dataConverter.performDataConversion(hashtable2);
            string3 = (String)hashtable2.get(GUID);
            if (string3 != null && string3.indexOf(46) >= 0) {
                try {
                    object2 = new GUID(string3);
                    string3 = ((GUID)object2).toNoDotString();
                }
                catch (Exception exception) {
                    string3 = null;
                }
            }
            if (string3 == null) break block13;
            object2 = new Hashtable<ColumnInfo, String>();
            ((Hashtable)object2).put(Host.getColumnInfo(GUID), string3);
            object = null;
            try {
                try {
                    this.logInfo(this.myClassname, string2, "About to query to T_RES_HOST table for an entry with GUID: " + string3);
                    object = SqlHost.sqlQuery(dBConnection, 2, (Hashtable)object2);
                    if (!((DBResultSet)object).next()) {
                        this.logInfo(this.myClassname, string2, "Query for entry in T_RES_HOST table returned no results, meaning the HOST has yet to be added to the database.  This information is required to persist the HBA.");
                        throw new SQLException("ControllerXml mapper requires that an entry for the guid provided to it (" + string3 + ") be in T_RES_HOST");
                    }
                    int n = ((DBResultSet)object).getInt("COMPUTER_ID");
                    this.logInfo(this.myClassname, string2, "Query for entry in T_RES_HOST table returned an auto-id value of: " + n);
                    hashtable.put(HOSTID, String.valueOf(n));
                }
                catch (Exception exception) {
                    this.logException(this.myClassname, string2, exception, "Error occurred while attempting to retrieve the HOST auto-id value, the HOST_ID column will be blank.");
                    throw new SQLException("ControllerXml mapper requires that an entry for the guid provided to it (" + string3 + ") be in T_RES_HOST");
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (object == null) throw throwable;
                ((DBResultSet)object).close();
                if (((DBResultSet)object).getStatement() == null) throw throwable;
                ((DBResultSet)object).getStatement().close();
                throw throwable;
            }
            {
                Object var11_15 = null;
                if (object == null) break block13;
            }
            ((DBResultSet)object).close();
            if (((DBResultSet)object).getStatement() != null) {
                ((DBResultSet)object).getStatement().close();
            }
        }
        this.m_dataConverter.removeComplexDataConversion(GUID);
        object2 = super.persist(dBConnection, hashtable, string);
        object = (String)hashtable.get(MODELDESCRIPTION);
        String string5 = (String)hashtable.get(MODEL);
        if (object == null) return object2;
        if (string5 == null) return object2;
        return this.persistModelDescription((String)object, string5, (MapperResult)object2, dBConnection);
    }

    private MapperResult persistModelDescription(String string, String string2, MapperResult mapperResult, DBConnection dBConnection) {
        String string3 = "persistModelDescription(String modelDes, String model, MapperResult mr, DBConnection conn)";
        Hashtable hashtable = mapperResult.getAllRows();
        Hashtable hashtable2 = (Hashtable)hashtable.get(Hba.getTablename());
        String string4 = (String)hashtable2.get("MODEL_ID");
        if (string4 != null) {
            Hashtable<ColumnInfo, String> hashtable3 = new Hashtable<ColumnInfo, String>();
            hashtable3.put(Model.getColumnInfo("MODEL_NAME"), string2);
            hashtable3.put(Model.getColumnInfo("MODEL_ID"), string4);
            hashtable3.put(Model.getColumnInfo("MODEL_DESCRIPTION"), string);
            Model model = new Model();
            try {
                model.update(dBConnection, hashtable3);
                mapperResult.addUpdatedRow(Model.getTablename(), hashtable3);
            }
            catch (SQLException sQLException) {
                this.logException(this.myClassname, string3, sQLException, "Attempt to update the T_RES_MODEL table with the model description failed.  Values used were: " + string2 + ", " + string + ", " + string4);
            }
        }
        return mapperResult;
    }
}

