/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISSwitchToDBMapper
extends DBAttributeMapper {
    private static final String sNAMEFORMAT = "nameformat";
    private static final String sNAME = "name";
    private static final String sOPERATIONALSTATUS = "operationalstatus";
    private static final String sCONSOLIDATEDSTATUS = "consolidatedstatus";
    private static final String sSWITCHNAME = "switchname";
    private static final String sCIMNAMESPACEID = "CIM_NAMESPACE_ID";
    private static final String sCREATIONCLASSNAME = "creationclassname";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_ComputerSystem";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "5";
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4, string5);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISSwitchToDBMapper() {
        ColumnInfo columnInfo = Switch.getColumnInfo("SWITCH_WWN");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = Switch.getColumnInfo("SWITCH_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put(sNAME.toLowerCase(), mapperInfo);
        this.m_htAttribToMapperInfo.put(sOPERATIONALSTATUS.toLowerCase(), new MapperInfo(Switch.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(sCONSOLIDATEDSTATUS.toLowerCase(), new MapperInfo(Switch.getColumnInfo("CONSOLIDATED_STATUS")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("SMISSwitchToDBMapper requires non-null values for the provided DBConnection and hashtable.");
        }
        String string3 = (String)hashtable.get(sNAMEFORMAT.toLowerCase());
        if (string3 == null || !string3.equalsIgnoreCase("14") && !string3.equalsIgnoreCase("WWN")) {
            return new MapperResult();
        }
        String string4 = (String)hashtable.get(sOPERATIONALSTATUS);
        if (string4 != null) {
            object = SMISSwitchToDBMapper.processArrayvalues(string4);
            if ((string4 = DBConstants.convertOperationalstatusArrayToBitValue((Vector)object)) != null) {
                hashtable.put(sOPERATIONALSTATUS, string4);
            } else {
                hashtable.remove(sOPERATIONALSTATUS);
            }
            string4 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object);
            if (string4 != null) {
                hashtable.put(sCONSOLIDATEDSTATUS.toLowerCase(), string4);
            }
        }
        if ((object = (String)hashtable.get(sNAME.toLowerCase())) != null) {
            hashtable.put(sSWITCHNAME.toLowerCase(), object);
        }
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        SMISCimkeySwitchToDBMapper sMISCimkeySwitchToDBMapper = new SMISCimkeySwitchToDBMapper();
        MapperResult mapperResult2 = sMISCimkeySwitchToDBMapper.persist(dBConnection, hashtable, string);
        mapperResult.addMapperResult(mapperResult2);
        mapperResult.addKeyReference("ref_toplevelsystem_id", Switch.getColumnInfo("SWITCH_ID"));
        mapperResult.addKeyReference("ref_switch_wwn", Switch.getColumnInfo("SWITCH_WWN"));
        try {
            mapperResult.addKeyReference("ref_toplevelsystem_cimom2namespaceid", CimkeySwitch.getColumnInfo(sCIMNAMESPACEID));
        }
        catch (Exception exception) {
            this.logInfo(this.myClassname, string2, "CIMOM2NAMESPACEID could not be persisted - namespace ref might not have been passed in!");
        }
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }

    private class SMISCimkeySwitchToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeySwitchToDBMapper() {
            ColumnInfo columnInfo = CimkeySwitch.getColumnInfo("NAME");
            columnInfo.setIsPrimaryKey();
            MapperInfo mapperInfo = new MapperInfo(columnInfo);
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sNAME, mapperInfo);
            ColumnInfo columnInfo2 = CimkeySwitch.getColumnInfo("SWITCH_WWN");
            columnInfo2.setIsPrimaryKey();
            MapperInfo mapperInfo2 = new MapperInfo(columnInfo2);
            ColumnInfo columnInfo3 = CimkeySwitch.getColumnInfo("CIMKEY_SWITCH_ID");
            columnInfo3.setAutoGenerated();
            mapperInfo2.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sSWITCHNAME, mapperInfo2);
            this.m_dataConverter.addSimpleDataConversion(SMISSwitchToDBMapper.sNAMEFORMAT, "SMISName_Format");
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sNAMEFORMAT, new MapperInfo(CimkeySwitch.getColumnInfo("NAME_FORMAT")));
            ColumnInfo columnInfo4 = CimkeySwitch.getColumnInfo(SMISSwitchToDBMapper.sCIMNAMESPACEID);
            columnInfo4.setIsPrimaryKey();
            MapperInfo mapperInfo3 = new MapperInfo(columnInfo4);
            mapperInfo3.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", mapperInfo3);
            this.m_htAttribToMapperInfo.put(SMISSwitchToDBMapper.sCREATIONCLASSNAME, new MapperInfo(CimkeySwitch.getColumnInfo("CREATION_CLASS_NAME_ID")));
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
            new Hashtable();
            String string2 = (String)hashtable.get("ref_serviceurl");
            if (string2 != null) {
                RegisteredCimom registeredCimom = new RegisteredCimom();
                registeredCimom.setServiceUrl(string2);
                boolean bl = registeredCimom.retrieve(dBConnection);
                if (bl) {
                    int n = registeredCimom.getRegCimomId();
                    string2 = (String)hashtable.get("ref_namespace");
                    if (string2 != null) {
                        Cimom2namespace cimom2namespace = new Cimom2namespace();
                        cimom2namespace.setCimomId(n);
                        cimom2namespace.setNamespace(string2);
                        bl = cimom2namespace.retrieve(dBConnection);
                        if (bl) {
                            hashtable.put("cimnamespaceid", new String(String.valueOf(cimom2namespace.getCimNamespaceId())));
                            MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
                            return mapperResult;
                        }
                    }
                }
            }
            MapperResult mapperResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
            return mapperResult;
        }
    }
}

