/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.sql.SqlHost;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SystemXmlToDBMapper
extends DBAttributeMapper {
    private static final String GUID = "GUID";
    private static final String HOSTNAME = "Hostname";
    private static final String IPADDRESS = "IP Address";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "SystemXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SystemXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml".toLowerCase(), ":", 2);
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        MapperResult mapperResult = new MapperResult();
        this.m_dataConverter.performDataConversion(hashtable);
        String string3 = (String)hashtable.get("UniqueIdXml");
        if (string3 == null) {
            string3 = (String)hashtable.get(GUID);
        }
        if (string3 != null && string3.indexOf(46) >= 0) {
            try {
                object = new GUID(string3);
                string3 = ((GUID)object).toNoDotString();
            }
            catch (Exception exception) {
                string3 = null;
            }
        }
        object = (String)hashtable.get(HOSTNAME);
        String string4 = (String)hashtable.get(IPADDRESS);
        if (string3 == null && object == null && string4 == null) {
            throw new SQLException("SystemXml mapper requires at least one of the following attributes: Hostname, IP Address, and GUID (or UniqueIdXml.");
        }
        String string5 = "";
        string5 = string3 != null ? (object != null ? (string4 != null ? " where GUID = '" + string3 + "' OR HOST_NAME = '" + (String)object + "' OR IP_ADDRESS = '" + string4 + "'" : " where GUID = '" + string3 + "' OR HOST_NAME = '" + (String)object + "'") : (string4 != null ? " where GUID = '" + string3 + "' OR IP_ADDRESS = '" + string4 + "'" : " where GUID = '" + string3 + "'")) : (object != null ? (string4 != null ? " where HOST_NAME = '" + (String)object + "' OR IP_ADDRESS = '" + string4 + "'" : " where HOST_NAME = '" + (String)object + "'") : " where IP_ADDRESS = '" + string4 + "'");
        if (object == null) {
            object = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
        Vector<Object> vector2 = new Vector<Object>();
        Hashtable<ColumnInfo, Object> hashtable2 = new Hashtable<ColumnInfo, Object>();
        Host host = new Host();
        host.setDetectable((short)1);
        hashtable2.put(Host.getColumnInfo("DETECTABLE"), "1");
        vector.add(Host.getColumnInfo("DETECTABLE"));
        vector2.add("1");
        Timestamp timestamp = CurrentTime.getTimestamp(dBConnection);
        host.setUpdateTimestamp(timestamp);
        ColumnInfo columnInfo = Host.getColumnInfo("UPDATE_TIMESTAMP");
        hashtable2.put(columnInfo, timestamp);
        vector.add(columnInfo);
        vector2.add(timestamp);
        host.setGuid(string3);
        hashtable2.put(Host.getColumnInfo(GUID), string3);
        vector.add(Host.getColumnInfo(GUID));
        vector2.add(string3);
        host.setHostName((String)object);
        hashtable2.put(Host.getColumnInfo("HOST_NAME"), object);
        vector.add(Host.getColumnInfo("HOST_NAME"));
        vector2.add(object);
        host.setIpAddress(string4);
        hashtable2.put(Host.getColumnInfo("IP_ADDRESS"), string4);
        vector.add(Host.getColumnInfo("IP_ADDRESS"));
        vector2.add(string4);
        Hashtable hashtable3 = ComplexQuery.generateHashtable(vector, vector2);
        int n = 0;
        n = SqlHost.sqlUpdate(dBConnection, 0, string5, hashtable3);
        int n2 = -1;
        Hashtable<ColumnInfo, String> hashtable4 = new Hashtable<ColumnInfo, String>();
        if (n == 0) {
            host.setDiscoveredTime(timestamp);
            hashtable2.put(Host.getColumnInfo("DISCOVERED_TIME"), timestamp);
            n2 = AutoIdentifier.getIdentifier(1, 1);
            host.setComputerId(n2);
            hashtable2.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(n2));
            boolean bl = host.insert(dBConnection, hashtable2);
            if (bl) {
                mapperResult.addInsertedRow(Host.getTablename(), hashtable2);
            }
        } else {
            mapperResult.addUpdatedRow(Host.getTablename(), hashtable2);
            try {
                DBResultSet dBResultSet = SqlHost.sqlQuery(dBConnection, 1, string5, null);
                dBResultSet.next();
                n2 = dBResultSet.getShort("COMPUTER_ID");
                dBResultSet.close();
            }
            catch (Exception exception) {
                this.logException(this.myClassname, string2, exception, "Attempt to retrieve auto-generated COMPUTER_ID value from T_RES_HOST failed.");
            }
        }
        dBConnection.commit();
        hashtable4.put(Host.getColumnInfo("COMPUTER_ID"), String.valueOf(n2));
        try {
            DetectabilityService.tableUpdated(string, Host.getTablename(), hashtable4);
        }
        catch (Exception exception) {
            this.logException(this.myClassname, string2, exception, "Call to detectability layer's tableUpdated function produced following exception.  Will attempt to continue.");
        }
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }
}

