/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.ServerException;
import org.sblim.wbem.cim.CIMObjectPath;

public class CIMOMMgmtGUIServer
implements ICIMOMMgmtService {
    ICIMOMMgmtService cimomProxy = null;
    private static CIMOMMgmtGUIServer instance = null;
    private static HashMap cimomDB = new HashMap();
    private static int toggle;

    static {
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("One"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Two"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Three"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Four"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Five"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Six"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Seven"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Eight"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Nine"));
        CIMOMMgmtGUIServer.addCIMOM(CIMOMMgmtGUIServer.newCIMOM("Ten"));
        toggle = 1;
    }

    private CIMOMMgmtGUIServer() {
    }

    private static CIMOM newCIMOM(String string) {
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl("ServiceUrl" + string);
        cIMOM.setHiName("HiName" + string);
        cIMOM.setDescription("Description" + string);
        cIMOM.setSoftwareLevel("SoftwareLevel" + string);
        cIMOM.setProtocolVersion("ProtocolVersion" + string);
        cIMOM.setAuthenticationMechanism("AuthenticationMechanism" + string);
        cIMOM.setUserId("UserId" + string);
        cIMOM.setPassword("Password" + string);
        cIMOM.setTrustStoreLocation("TrustStoreLocation" + string);
        cIMOM.setTrustStorePassphrase("TrustStorePassphrase" + string);
        cIMOM.setAlias("Alias" + string);
        cIMOM.setServiceId("ServiceId" + string);
        cIMOM.setInteropSchemaNamespace("InteropSchemaNamespace" + string);
        cIMOM.setProtocol("Protocol" + string);
        cIMOM.setDisplayName("DisplayName" + string);
        cIMOM.setSlpAttributes("SlpAttributes" + string);
        cIMOM.setStatus(CIMOMMgmtGUIServer.getStatus());
        cIMOM.setStatusTimestamp(Calendar.getInstance());
        return cIMOM;
    }

    private static CIMOMConnectionStatus getStatus() {
        CIMOMConnectionStatus cIMOMConnectionStatus;
        switch (toggle++ % 10) {
            case 0: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.UNCONFIGURED;
                break;
            }
            case 1: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.UNKNOWN;
                break;
            }
            case 2: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.INVALID_NAMESPACE;
                break;
            }
            case 3: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.TIMEOUT;
                break;
            }
            case 4: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.REFUSED;
                break;
            }
            case 5: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.LOGIN_FAILED;
                break;
            }
            case 6: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR;
                break;
            }
            case 7: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                break;
            }
            case 8: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.CIMCLIENT_ERROR;
                break;
            }
            default: {
                cIMOMConnectionStatus = CIMOMConnectionStatus.SUCCESS;
            }
        }
        return cIMOMConnectionStatus;
    }

    private static void addCIMOM(CIMOM cIMOM) {
        cimomDB.put(cIMOM.getServiceUrl(), cIMOM);
    }

    public static synchronized ICIMOMMgmtService getInstance() {
        if (instance == null) {
            instance = new CIMOMMgmtGUIServer();
        }
        return instance;
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, boolean bl) throws ServerException {
        return new AsyncResult();
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, Boolean bl) throws ServerException {
        return new AsyncResult();
    }

    public CIMOM[] getCIMOMs() throws ServerException {
        return cimomDB.values().toArray(new CIMOM[0]);
    }

    public String[] getCIMOMIDs() throws ServerException {
        return cimomDB.keySet().toArray(new String[0]);
    }

    public void modifyCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        int n = 0;
        while (n < cIMOMArray.length) {
            cimomDB.put(cIMOMArray[n].getServiceUrl(), cIMOMArray[n]);
            ++n;
        }
    }

    public String[] addCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < cIMOMArray.length) {
            cimomDB.put(cIMOMArray[n].getServiceUrl(), cIMOMArray[n]);
            arrayList.add(cIMOMArray[n].getServiceUrl());
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    public void deleteCIMOMs(String[] stringArray) throws ServerException {
        int n = 0;
        while (n < stringArray.length) {
            cimomDB.remove(stringArray[n]);
            ++n;
        }
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cIMOMArray) throws ServerException {
        CIMOMConnectionStatus[] cIMOMConnectionStatusArray = new CIMOMConnectionStatus[cIMOMArray.length];
        int n = 0;
        while (n < cIMOMArray.length) {
            switch (toggle++ % 10) {
                case 0: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.UNCONFIGURED;
                    break;
                }
                case 1: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.UNKNOWN;
                    break;
                }
                case 2: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.INVALID_NAMESPACE;
                    break;
                }
                case 3: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.TIMEOUT;
                    break;
                }
                case 4: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.REFUSED;
                    break;
                }
                case 5: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.LOGIN_FAILED;
                    break;
                }
                case 6: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR;
                    break;
                }
                case 7: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                    break;
                }
                case 8: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.CIMCLIENT_ERROR;
                    break;
                }
                default: {
                    cIMOMConnectionStatusArray[n] = CIMOMConnectionStatus.SUCCESS;
                }
            }
            ++n;
        }
        return cIMOMConnectionStatusArray;
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cIMOMArray, CIMObjectPath cIMObjectPath) throws ServerException {
        return null;
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return null;
    }

    public ArrayList getCIMOMtoDevices(String string) throws RemoteException, ServerException {
        return null;
    }
}

