/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.DiskCapacityAdjuster;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskCapacityGrapher
extends Grapher {
    private String title;
    public static final byte CHART_SPACE = 101;
    public static final byte CHART_SPACE_X = 102;
    public static final byte CHART_NET_SPACE = 103;
    public static final byte CHART_NET_CAPACITY = 104;
    public static final String CHART_SELECTED = "STG5556T";
    public static final String CHART_ALL = "STG1294T";
    public static final String CHART_NETWORK_SIZE = "STG5525L";
    public static final String CHART_NETWORK_CAP = "STG5524L";
    public static final String CHART_NETWORK_CAP_ALL = "STG7529L";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_HIST_ALL = "STG7530L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String FREE_PERCENT_HIST_ALL = "STG7531L";
    public static final String CAPACITY_HIST = "STG5109L";
    public static final String CAPACITY_HIST_ALL = "STG7555L";
    private String legend;
    private static final String DOMAINS = MessageLog.getMessageNoID("STG5004L");
    private static final String COMPGROUPS = MessageLog.getMessageNoID("STG3012L");
    private static final String COMPUTERS = MessageLog.getMessageNoID("STG4041L");
    private static final String DISKS = MessageLog.getMessageNoID("STG1004L");
    private static final String CLUSTERS = MessageLog.getMessageNoID("STG1149L");
    private static final String SUBSYSTEMS = MessageLog.getMessageNoID("SAG0002L");
    private byte action;

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        this.action = guiReportReq.chartSubtype;
        if (guiReportReq.chartSubtype > 0) {
            return null;
        }
        this.title = guiReportReq.histSubtype == 1 ? FREE_HIST : (guiReportReq.histSubtype == 2 ? FREE_PERCENT_HIST : CAPACITY_HIST);
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        AperiChart aperiChart = null;
        if (guiReportReq.chartSubtype > 0) {
            this.setLegend(guiReportReq);
            aperiChart = guiReportReq.chartSubtype == 103 ? this.createPieChart(guiReportReq, objectArray, reportDataAdjuster, null, guiChartSettingsReq) : this.createChart(guiReportReq, objectArray, nArray, reportDataAdjuster, null, guiChartSettingsReq);
        } else {
            GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray, this.title);
            aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        }
        return aperiChart;
    }

    public void setLegend(GuiReportReq guiReportReq) {
        if (guiReportReq.reportType == 72) {
            this.legend = SUBSYSTEMS;
        } else {
            switch (guiReportReq.reportSubtype) {
                case 27: {
                    this.legend = DISKS;
                    break;
                }
                case 12: {
                    this.legend = COMPUTERS;
                    break;
                }
                case 13: {
                    this.legend = COMPGROUPS;
                    break;
                }
                case 82: {
                    this.legend = CLUSTERS;
                    break;
                }
                case 14: {
                    this.legend = DOMAINS;
                    break;
                }
                case 77: {
                    this.legend = SUBSYSTEMS;
                }
            }
        }
    }

    public AperiCustomizableChart createPieChart(GuiReportReq guiReportReq, Object[] objectArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskCapacityGrapher.class.getName(), "createPieChart", "grr, pData, pAdjuster, ddi, gcsr");
        }
        RespFSspace[] respFSspaceArray = (RespFSspace[])objectArray;
        DiskCapacityAdjuster diskCapacityAdjuster = (DiskCapacityAdjuster)reportDataAdjuster;
        Number[][] numberArray = new Number[6][1];
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[]{DiskCapacityAdjuster.USED_SPACE, DiskCapacityAdjuster.FREE_SPACE, DiskCapacityAdjuster.RAW_CAPACITY, DiskCapacityAdjuster.OVERHEAD, DiskCapacityAdjuster.UNALLOCATED, DiskCapacityAdjuster.UNKNOWN_LCAP};
        numberArray[0][0] = new Double(respFSspaceArray[0].usedSpace);
        numberArray[1][0] = new Double(respFSspaceArray[0].fsFreeSpace);
        numberArray[2][0] = new Double(respFSspaceArray[0].fs_capacity);
        numberArray[3][0] = new Double(respFSspaceArray[0].overhead);
        numberArray[4][0] = new Double(respFSspaceArray[0].unallocated);
        numberArray[5][0] = new Double(respFSspaceArray[0].unknown);
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(1, 7, numberArray, stringArray2, stringArray, new ChartOptions(), guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        AperiCustomizableChart aperiCustomizableChart2 = aperiCustomizableChart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskCapacityGrapher.class.getName(), "createPieChart", aperiCustomizableChart2);
        }
        return aperiCustomizableChart2;
    }

    public AperiCustomizableChart createChart(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskCapacityGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        RespFSspace[] respFSspaceArray = (RespFSspace[])objectArray;
        int n = nArray.length;
        Number[][] numberArray = new Number[n][1];
        String[] stringArray = new String[n];
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            numberArray[n2][0] = new Double(respFSspaceArray[n3].capacity);
            l += respFSspaceArray[n3].capacity;
            stringArray[n2] = respFSspaceArray[n3].creator.equals(" ") ? respFSspaceArray[n3].getName() : String.valueOf(respFSspaceArray[n3].creator) + "." + respFSspaceArray[n3].getName();
            ++n2;
        }
        ChartOptions chartOptions = new ChartOptions();
        chartOptions.chartType = 3;
        chartOptions.chartsPerView = 1;
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(1, 7, numberArray, stringArray, new String[]{"Capacity"}, chartOptions, guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        AperiCustomizableChart aperiCustomizableChart2 = aperiCustomizableChart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskCapacityGrapher.class.getName(), "createChart", aperiCustomizableChart2);
        }
        return aperiCustomizableChart2;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskCapacityGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand");
        }
        RespFSspace[] respFSspaceArray = (RespFSspace[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        guiReportReq2.selectedResources = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            RespFSspace respFSspace = respFSspaceArray[nArray[n]];
            int n2 = respFSspace.id;
            if (guiReportReq.reportSubtype == 27) {
                n2 = respFSspace.fs_id;
            }
            guiReportReq2.selectedResources[n] = n2;
            SpaceHistChart.addLegend(guiReportReq2, respFSspace.creator, respFSspace.getName(), n2);
            ++n;
        }
        if (string == FREE_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = 1;
            guiReportReq2.historyTitle = "STG5111L";
        } else if (string == FREE_PERCENT_HIST) {
            guiReportReq2.chartLabelType = (byte)8;
            guiReportReq2.histSubtype = (byte)2;
            guiReportReq2.historyTitle = "STG5112L";
        } else {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = (byte)5;
            guiReportReq2.historyTitle = "STG5113L";
        }
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        guiReportReq2.reportSubtype = 28;
        GuiReportReq guiReportReq3 = guiReportReq2;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskCapacityGrapher.class.getName(), "createHistory", guiReportReq3);
        }
        return guiReportReq3;
    }
}

